/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.gui.windows;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titanium.graph.clustering.BaseCluster;
import org.eclipse.titanium.graph.clustering.ClustererBuilder;
import org.eclipse.titanium.graph.clustering.visualization.ClusterNode;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeColours;
import org.eclipse.titanium.graph.components.NodeDescriptor;
import org.eclipse.titanium.graph.generators.ModuleGraphGenerator;
import org.eclipse.titanium.graph.gui.common.Layouts;
import org.eclipse.titanium.graph.gui.utils.LayoutEntry;
import org.eclipse.titanium.graph.gui.utils.MetricsEntry;
import org.eclipse.titanium.graph.gui.utils.MetricsLayoutEntry;
import org.eclipse.titanium.graph.gui.windows.GraphEditor;
import org.eclipse.titanium.graph.visualization.MeasureableGraphHandler;
import org.eclipse.titanium.metrics.AltstepMetric;
import org.eclipse.titanium.metrics.FunctionMetric;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.ModuleMetric;
import org.eclipse.titanium.metrics.TestcaseMetric;
import org.eclipse.titanium.metrics.preferences.PreferenceManager;
import org.eclipse.titanium.metrics.utils.WrapperStore;
import org.eclipse.ui.IFileEditorInput;

public class ModuleGraphEditor
extends GraphEditor {
    protected MetricsEntry chosenMetric;
    protected DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> originalGraph = null;
    protected final ButtonGroup metricsGroup = new ButtonGroup();
    protected final JMenu metricsMenu = new JMenu("Metrics");
    protected final JMenu clusteringMenu = new JMenu("Clustering");
    protected final JMenu knotClusteringMenu = new JMenu("Grouping clusterer");
    protected final JMenu graphClusteringMenu = new JMenu("Graph generating clusterer");
    protected final JMenuItem nameKnotCluster = new JMenuItem("By module names");
    protected final JMenu nameClusteringMenu = new JMenu("By module names");
    protected final JMenuItem nameGraphCluster = new JMenuItem("Show edges representing import hierarchy");
    protected final JMenuItem fullNameGraphCluster = new JMenuItem("Show full tree module name hierarhy");
    protected final JMenuItem sparseNameGraphCluster = new JMenuItem("Show non-empty nodes only in the tree");
    protected final JMenuItem regKnotCluster = new JMenuItem("Using regular expressions");
    protected final JMenuItem regGraphCluster = new JMenuItem("Using regular expressions");
    protected final JMenuItem autoKnotCluster = new JMenuItem("Automatically");
    protected final JMenuItem folderKnotCluster = new JMenuItem("By folder name");
    protected final JMenuItem folderGraphCluster = new JMenuItem("By folder name");
    protected final JMenuItem linkedKnotCluster = new JMenuItem("By linked file location");
    protected final JMenuItem linkedGraphCluster = new JMenuItem("By linked file location");
    protected final JMenuItem locationKnotCluster = new JMenuItem("By module location");
    protected final JMenuItem locationGraphCluster = new JMenuItem("By module location");
    protected final JMenuItem closeGraphClusters = new JMenuItem("Leave cluster graph");
    protected final JRadioButtonMenuItem isom = Layouts.LAYOUT_ISOM.newInstance();
    protected final JRadioButtonMenuItem kk = Layouts.LAYOUT_KK.newInstance();
    protected final JRadioButtonMenuItem fr = Layouts.LAYOUT_FR.newInstance();
    protected final JRadioButtonMenuItem spring = Layouts.LAYOUT_SPRING.newInstance();
    protected final JRadioButtonMenuItem circle = Layouts.LAYOUT_CIRCLE.newInstance();
    protected final JRadioButtonMenuItem tdag = Layouts.LAYOUT_TDAG.newInstance();
    protected final JRadioButtonMenuItem rtdag = Layouts.LAYOUT_RTDAG.newInstance();
    protected final JMenu metricLayoutMenu = new JMenu("Metric layouts");
    public static final String ID = "org.eclipse.titanium.graph.editors.ModuleGraphEditor";

    @Override
    protected void initWindow() {
        MetricsLayoutEntry layoutItem;
        MetricsEntry item;
        super.initWindow();
        this.isom.addActionListener(this.layoutListener);
        this.layoutGroup.add(this.isom);
        this.layoutMenu.add(this.isom);
        this.kk.addActionListener(this.layoutListener);
        this.layoutGroup.add(this.kk);
        this.layoutMenu.add(this.kk);
        this.fr.addActionListener(this.layoutListener);
        this.layoutGroup.add(this.fr);
        this.layoutMenu.add(this.fr);
        this.spring.addActionListener(this.layoutListener);
        this.layoutMenu.add(this.spring);
        this.layoutGroup.add(this.spring);
        this.circle.addActionListener(this.layoutListener);
        this.layoutMenu.add(this.circle);
        this.layoutGroup.add(this.circle);
        JMenu dagMenu = new JMenu("Directed layouts");
        this.layoutMenu.add(dagMenu);
        this.tdag.setSelected(true);
        this.tdag.addActionListener(this.layoutListener);
        dagMenu.add(this.tdag);
        this.layoutGroup.add(this.tdag);
        this.rtdag.addActionListener(this.layoutListener);
        dagMenu.add(this.rtdag);
        this.layoutGroup.add(this.rtdag);
        this.layoutMenu.add(this.metricLayoutMenu);
        ActionListener changeMetrics = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetricsEntry metric;
                ModuleGraphEditor.this.chosenMetric = metric = (MetricsEntry)e.getSource();
                for (NodeDescriptor node : ModuleGraphEditor.this.graph.getVertices()) {
                    ((MeasureableGraphHandler)ModuleGraphEditor.this.handler).calculateColour(node, ModuleGraphEditor.this.chosenMetric.getMetric());
                }
                ModuleGraphEditor.this.drawArea.repaint();
                if (ModuleGraphEditor.this.satView != null) {
                    ModuleGraphEditor.this.satView.repaint();
                }
            }
        };
        boolean isFirst = true;
        JMenu actMenu = new JMenu("Module");
        JMenu actLayoutMenu = new JMenu("Module");
        this.metricsMenu.add(actMenu);
        this.metricLayoutMenu.add(actLayoutMenu);
        for (ModuleMetric moduleMetric : ModuleMetric.values()) {
            if (!PreferenceManager.isEnabledOnModuleGraph(moduleMetric)) continue;
            item = new MetricsEntry(moduleMetric.getName(), moduleMetric);
            if (isFirst) {
                item.setSelected(true);
                this.chosenMetric = item;
                isFirst = false;
            }
            item.addActionListener(changeMetrics);
            this.metricsGroup.add(item);
            actMenu.add(item);
            layoutItem = new MetricsLayoutEntry(moduleMetric);
            layoutItem.addActionListener(this.layoutListener);
            this.layoutGroup.add(layoutItem);
            actLayoutMenu.add(layoutItem);
        }
        actMenu = new JMenu("Altstep");
        actLayoutMenu = new JMenu("Altstep");
        this.metricsMenu.add(actMenu);
        this.metricLayoutMenu.add(actLayoutMenu);
        for (Enum enum_ : AltstepMetric.values()) {
            if (!PreferenceManager.isEnabledOnModuleGraph((IMetricEnum)((Object)enum_))) continue;
            item = new MetricsEntry(((AltstepMetric)enum_).getName(), (IMetricEnum)((Object)enum_));
            item.addActionListener(changeMetrics);
            this.metricsGroup.add(item);
            actMenu.add(item);
            layoutItem = new MetricsLayoutEntry((IMetricEnum)((Object)enum_));
            layoutItem.addActionListener(this.layoutListener);
            this.layoutGroup.add(layoutItem);
            actLayoutMenu.add(layoutItem);
        }
        actMenu = new JMenu("Function");
        actLayoutMenu = new JMenu("Function");
        this.metricLayoutMenu.add(actLayoutMenu);
        this.metricsMenu.add(actMenu);
        for (Enum enum_ : FunctionMetric.values()) {
            if (!PreferenceManager.isEnabledOnModuleGraph((IMetricEnum)((Object)enum_))) continue;
            item = new MetricsEntry(((FunctionMetric)enum_).getName(), (IMetricEnum)((Object)enum_));
            item.addActionListener(changeMetrics);
            this.metricsGroup.add(item);
            actMenu.add(item);
            layoutItem = new MetricsLayoutEntry((IMetricEnum)((Object)enum_));
            layoutItem.addActionListener(this.layoutListener);
            this.layoutGroup.add(layoutItem);
            actLayoutMenu.add(layoutItem);
        }
        actMenu = new JMenu("Testcase");
        actLayoutMenu = new JMenu("Testcase");
        this.metricLayoutMenu.add(actLayoutMenu);
        this.metricsMenu.add(actMenu);
        for (Enum enum_ : TestcaseMetric.values()) {
            if (!PreferenceManager.isEnabledOnModuleGraph((IMetricEnum)((Object)enum_))) continue;
            item = new MetricsEntry(((TestcaseMetric)enum_).getName(), (IMetricEnum)((Object)enum_));
            item.addActionListener(changeMetrics);
            this.metricsGroup.add(item);
            actMenu.add(item);
            layoutItem = new MetricsLayoutEntry((IMetricEnum)((Object)enum_));
            layoutItem.addActionListener(this.layoutListener);
            this.layoutGroup.add(layoutItem);
            actLayoutMenu.add(layoutItem);
        }
        JMenuItem recalcItem = new JMenuItem("Recalculate metrics");
        recalcItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WrapperStore.clearStore();
                GlobalParser.reAnalyzeSemantically();
                ModuleGraphEditor.this.recolour(ModuleGraphEditor.this.graph.getVertices());
                if (ModuleGraphEditor.this.chosenLayout instanceof MetricsLayoutEntry) {
                    ModuleGraphEditor.this.chosenLayout.doClick();
                }
            }
        });
        this.metricsMenu.add(recalcItem);
        this.folderKnotCluster.addActionListener(new ClusteringAction("foldername", true));
        this.knotClusteringMenu.add(this.folderKnotCluster);
        this.folderGraphCluster.addActionListener(new ClusteringAction("foldername", false));
        this.graphClusteringMenu.add(this.folderGraphCluster);
        this.linkedKnotCluster.addActionListener(new ClusteringAction("linkedlocation", true));
        this.knotClusteringMenu.add(this.linkedKnotCluster);
        this.linkedGraphCluster.addActionListener(new ClusteringAction("linkedlocation", false));
        this.graphClusteringMenu.add(this.linkedGraphCluster);
        this.locationKnotCluster.addActionListener(new ClusteringAction("modulelocation", true));
        this.knotClusteringMenu.add(this.locationKnotCluster);
        this.locationGraphCluster.addActionListener(new ClusteringAction("modulelocation", false));
        this.graphClusteringMenu.add(this.locationGraphCluster);
        this.regKnotCluster.addActionListener(new ClusteringAction("regularexpression", true));
        this.knotClusteringMenu.add(this.regKnotCluster);
        this.regGraphCluster.addActionListener(new ClusteringAction("regularexpression", false));
        this.graphClusteringMenu.add(this.regGraphCluster);
        this.nameKnotCluster.addActionListener(new ClusteringAction("modulename", true));
        this.knotClusteringMenu.add(this.nameKnotCluster);
        this.nameGraphCluster.addActionListener(new ClusteringAction("modulename", false));
        this.nameClusteringMenu.add(this.nameGraphCluster);
        this.fullNameGraphCluster.addActionListener(new ClusteringAction("fullmodulenametree", false, (LayoutEntry)this.tdag));
        this.nameClusteringMenu.add(this.fullNameGraphCluster);
        this.sparseNameGraphCluster.addActionListener(new ClusteringAction("sparsemodulenametree", false, (LayoutEntry)this.tdag));
        this.nameClusteringMenu.add(this.sparseNameGraphCluster);
        this.autoKnotCluster.addActionListener(new ClusteringAction("automatic", true));
        this.knotClusteringMenu.add(this.autoKnotCluster);
        this.closeGraphClusters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModuleGraphEditor.this.chosenLayout.setSelected(false);
                ModuleGraphEditor.this.tdag.setSelected(true);
                ModuleGraphEditor.this.chosenLayout = (LayoutEntry)ModuleGraphEditor.this.tdag;
                ModuleGraphEditor.this.enableModuleMenus(true);
                ModuleGraphEditor.this.setGraph(ModuleGraphEditor.this.originalGraph);
            }
        });
        this.closeGraphClusters.setEnabled(false);
        this.menuBar.add(this.metricsMenu);
        this.clusteringMenu.add(this.knotClusteringMenu);
        this.graphClusteringMenu.add(this.nameClusteringMenu);
        this.clusteringMenu.add(this.graphClusteringMenu);
        this.clusteringMenu.add(this.closeGraphClusters);
        this.menuBar.add(this.clusteringMenu);
    }

    @Override
    public void recolour(Collection<NodeDescriptor> nodeSet) {
        for (NodeDescriptor v : nodeSet) {
            if (v instanceof ClusterNode) {
                v.setNodeColour(NodeColours.DARK_GREEN);
                continue;
            }
            ((MeasureableGraphHandler)this.handler).calculateColour(v, this.chosenMetric.getMetric());
        }
        this.refresh();
    }

    protected void enableModuleMenus(boolean value) {
        ((MeasureableGraphHandler)this.handler).enableInfoWindow(value);
        this.metricsMenu.setEnabled(value);
        this.closeGraphClusters.setEnabled(!value);
        this.nameKnotCluster.setEnabled(value);
        this.autoKnotCluster.setEnabled(value);
        this.regKnotCluster.setEnabled(value);
        this.folderKnotCluster.setEnabled(value);
        this.nameClusteringMenu.setEnabled(value);
        this.regGraphCluster.setEnabled(value);
        this.folderGraphCluster.setEnabled(value);
        this.linkedKnotCluster.setEnabled(value);
        this.linkedGraphCluster.setEnabled(value);
        this.locationKnotCluster.setEnabled(value);
        this.locationGraphCluster.setEnabled(value);
        this.metricLayoutMenu.setEnabled(value);
        this.handler.setMenusEnabled(value);
    }

    @Override
    protected void initGeneratorAndHandler(Composite parent) {
        this.handler = new MeasureableGraphHandler(parent.getShell());
        this.generator = new ModuleGraphGenerator(((IFileEditorInput)this.getEditorInput()).getFile().getProject(), this.errorHandler);
    }

    protected class ClusteringJob
    extends Job {
        private final BaseCluster clusterer;
        private final boolean grouping;
        private final ActionEvent event;
        private final LayoutEntry layout;

        public ClusteringJob(String name, BaseCluster clusterer, boolean grouping, ActionEvent event, LayoutEntry layout) {
            super(name);
            this.clusterer = clusterer;
            this.grouping = grouping;
            this.event = event;
            this.layout = layout;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.clusterer.run(monitor, this.grouping);
            if (!this.clusterer.isOK()) {
                return Status.OK_STATUS;
            }
            if (this.grouping) {
                ModuleGraphEditor.this.chosenLayout.setSelected(false);
                ModuleGraphEditor.this.chosenLayout = new LayoutEntry("Cluster", "");
                ModuleGraphEditor.this.handler.setClusters(this.clusterer.getClusters());
                this.event.setSource(ModuleGraphEditor.this.chosenLayout);
                ModuleGraphEditor.this.layoutListener.actionPerformed(this.event);
            } else {
                ModuleGraphEditor.this.enableModuleMenus(false);
                if (this.layout != null) {
                    ModuleGraphEditor.this.chosenLayout.setSelected(false);
                    ModuleGraphEditor.this.chosenLayout = this.layout;
                    ModuleGraphEditor.this.chosenLayout.setSelected(true);
                }
                ModuleGraphEditor.this.originalGraph = ModuleGraphEditor.this.graph;
                ModuleGraphEditor.this.setGraph(this.clusterer.getGraph());
            }
            return Status.OK_STATUS;
        }
    }

    protected class ClusteringAction
    implements ActionListener {
        private String algorithm;
        private boolean grouping;
        private LayoutEntry layout;

        public ClusteringAction(String algorithm, boolean grouping) {
            this(algorithm, grouping, null);
        }

        public ClusteringAction(String algorithm, boolean grouping, LayoutEntry layout) {
            this.algorithm = algorithm;
            this.grouping = grouping;
            this.layout = layout;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            BaseCluster clusterer = new ClustererBuilder().setAlgorithm(this.algorithm).setGraph((DirectedSparseGraph<NodeDescriptor, EdgeDescriptor>)ModuleGraphEditor.this.graph).setProject(ModuleGraphEditor.this.project).build();
            ClusteringJob job = new ClusteringJob("Clustering of the module graph", clusterer, this.grouping, event, this.layout);
            job.setSystem(false);
            job.setUser(true);
            job.schedule();
        }
    }
}

