/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.titan.designer.AST.ASN1.ASN1Assignment;
import org.eclipse.titan.designer.AST.ASN1.Undefined_Assignment;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseProjectCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class UnusedGlobalDefinition
extends BaseProjectCodeSmellSpotter {
    public UnusedGlobalDefinition() {
        super(CodeSmellType.UNUSED_GLOBAL_DEFINITION);
    }

    @Override
    protected void process(IProject project, BaseCodeSmellSpotter.Problems problems) {
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)project);
        Set knownModuleNames = projectSourceParser.getKnownModuleNames();
        ArrayList<Module> modules = new ArrayList<Module>();
        HashSet<Assignment> unused = new HashSet<Assignment>();
        for (String moduleName : new TreeSet(knownModuleNames)) {
            Module module = projectSourceParser.getModuleByName(moduleName);
            modules.add(module);
            GlobalDefinitionCheck chek = new GlobalDefinitionCheck();
            module.accept((ASTVisitor)chek);
            unused.addAll(chek.getDefinitions());
        }
        for (Module module : modules) {
            GlobalUsedDefinitionCheck chekUsed = new GlobalUsedDefinitionCheck();
            module.accept((ASTVisitor)chekUsed);
            Set<Assignment> used = chekUsed.getDefinitions();
            unused.removeAll(used);
            ArrayList<Assignment> tobeRemoved = new ArrayList<Assignment>();
            for (Assignment assignment : unused) {
                ASN1Assignment realAssignment;
                if (!(assignment instanceof Undefined_Assignment) || !used.contains(realAssignment = ((Undefined_Assignment)assignment).getRealAssignment(CompilationTimeStamp.getBaseTimestamp()))) continue;
                tobeRemoved.add(assignment);
            }
            unused.removeAll(tobeRemoved);
        }
        for (Assignment ass : unused) {
            String name = ass.getIdentifier().getDisplayName();
            String msg = MessageFormat.format("The {0} `{1}'' seems to be never used globally", ass.getAssignmentName(), name);
            problems.report(ass.getIdentifier().getLocation(), msg);
        }
    }

    class GlobalUsedDefinitionCheck
    extends ASTVisitor {
        private final Set<Assignment> setOfDefinition = new HashSet<Assignment>();

        public GlobalUsedDefinitionCheck() {
            this.setOfDefinition.clear();
        }

        public Set<Assignment> getDefinitions() {
            return this.setOfDefinition;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Reference) {
                if (((Reference)node).getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
                    return 3;
                }
                Assignment assignment = ((Reference)node).getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false, null);
                if (assignment != null && !assignment.isLocal()) {
                    this.setOfDefinition.add(assignment);
                }
            }
            return 3;
        }
    }

    class GlobalDefinitionCheck
    extends ASTVisitor {
        private final Set<Assignment> setOfDefinition = new HashSet<Assignment>();

        public GlobalDefinitionCheck() {
            this.setOfDefinition.clear();
        }

        public Set<Assignment> getDefinitions() {
            return this.setOfDefinition;
        }

        public int visit(IVisitableNode node) {
            Assignment assignment;
            if (node instanceof Assignment && !(assignment = (Assignment)node).isLocal()) {
                this.setOfDefinition.add(assignment);
            }
            return 3;
        }
    }
}

