/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.executors;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.executor.perspectives.ExecutingPerspective;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public abstract class TitanLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    private final String ALWAYS = "always";
    private final String PROMPT = "prompt";
    private final String MODE_RUN = "run";

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new Launch(configuration, mode, null);
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IResource[] resources = configuration.getMappedResources();
        if (resources == null) {
            return null;
        }
        ArrayList<IProject> result = new ArrayList<IProject>();
        for (IResource resource : resources) {
            if (!(resource instanceof IProject)) continue;
            result.add((IProject)resource);
        }
        return this.computeReferencedBuildOrder(result.toArray(new IProject[result.size()]));
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.getBuildOrder(configuration, mode);
    }

    protected void showExecutionPerspective(ILaunchConfigurationType configurationType) {
        String perspectiveId;
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        DebugUIPlugin debugPlugin = DebugUIPlugin.getDefault();
        String pref = debugPlugin.getPreferenceStore().getString("org.eclipse.debug.ui.switch_to_perspective");
        if (pref == null || pref.isEmpty()) {
            pref = "always";
        }
        if ((perspectiveId = debugPlugin.getPerspectiveManager().getLaunchPerspective(configurationType, "run")) == null || pref.isEmpty()) {
            perspectiveId = ExecutingPerspective.class.getClass().getName();
        }
        try {
            boolean result;
            if (pref.equals("always")) {
                workbench.showPerspective(perspectiveId, workbench.getActiveWorkbenchWindow());
            } else if (pref.equals("prompt") && (result = MessageDialog.openConfirm((Shell)new Shell(), (String)"Confirm Perspective Switch", (String)"Do you want to switch perspective?"))) {
                workbench.showPerspective(perspectiveId, workbench.getActiveWorkbenchWindow());
            }
        }
        catch (WorkbenchException e) {
            ErrorDialog.openError(null, (String)("Selecting the perspective failed: " + perspectiveId), (String)e.getMessage(), (IStatus)e.getStatus());
        }
    }
}

