/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.core;

import org.eclipse.swt.graphics.Color;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.views.msc.ui.core.ComponentCreation;
import org.eclipse.titan.log.viewer.views.msc.ui.core.ComponentTermination;
import org.eclipse.titan.log.viewer.views.msc.ui.core.Frame;
import org.eclipse.titan.log.viewer.views.msc.ui.core.MSCNode;
import org.eclipse.titan.log.viewer.views.msc.ui.view.IGC;
import org.eclipse.titan.log.viewer.views.msc.util.MSCConstants;

public final class Lifeline
extends MSCNode {
    private int indexInFrame = 1;
    private Frame frame = null;
    private int eventOccurrence = 0;
    private ComponentCreation start = null;
    private ComponentTermination stop = null;

    public Lifeline() {
        super(0);
    }

    @Override
    public int getX() {
        return this.indexInFrame * MSCConstants.COLUMN_WIDTH + MSCConstants.COLUMN_WIDTH / 2;
    }

    @Override
    public int getY() {
        if (this.start != null) {
            return this.start.getY();
        }
        return 0;
    }

    @Override
    public int getWidth() {
        return 1;
    }

    @Override
    public int getHeight() {
        if (this.start != null && this.stop != null) {
            return this.stop.getY() + this.stop.getHeight() - this.start.getY();
        }
        return 0;
    }

    protected void setFrame(Frame parentFrame) {
        this.frame = parentFrame;
        if (this.frame.getMaxEventOccurrence() < this.getEventOccurrence() + 1) {
            this.frame.setMaxEventOccurrence(this.getEventOccurrence() + 1);
        }
    }

    public void setStart(ComponentCreation start) {
        this.start = start;
    }

    public void setStop(ComponentTermination stop) {
        this.stop = stop;
    }

    public boolean hasStopBeenSet() {
        return this.stop != null;
    }

    protected Frame getFrame() {
        return this.frame;
    }

    protected void setIndex(int index) {
        this.indexInFrame = index;
    }

    public int getIndex() {
        return this.indexInFrame;
    }

    public void setCurrentEventOccurrence(int eventOcc) {
        if (this.frame != null && this.frame.getMaxEventOccurrence() < eventOcc) {
            this.frame.setMaxEventOccurrence(eventOcc);
        }
        this.eventOccurrence = eventOcc;
    }

    public int getEventOccurrence() {
        return this.eventOccurrence;
    }

    public int getNewEventOccurrence() {
        this.setCurrentEventOccurrence(this.eventOccurrence + 1);
        return this.eventOccurrence;
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.frame == null) {
            return false;
        }
        return MSCNode.contains(this.getX(), this.getY(), this.getWidth(), this.getHeight(), x, y);
    }

    public void draw(IGC context, int x, int y) {
        int yStop;
        int yStart;
        int visYStart = this.frame.getVisibleAreaY();
        int visYStop = visYStart + this.frame.getVisibleAreaHeight();
        if (this.start == null) {
            yStart = visYStart;
        } else {
            yStart = this.start.getY() + this.start.getHeight();
            if (visYStart > yStart) {
                yStart = visYStart;
            }
        }
        if (this.stop == null) {
            yStop = visYStop;
        } else {
            yStop = this.stop.getY();
            if (visYStop < yStop) {
                yStop = visYStop;
            }
        }
        context.setLineStyle(context.getLineSolidStyle());
        context.setLineWidth(1);
        context.setForeground((Color)Activator.getDefault().getCachedResource("COLOR_DARK_GREY"));
        context.drawLine(x, yStart, x, yStop);
    }

    @Override
    public void draw(IGC context) {
        this.draw(context, this.getX(), this.getY());
    }

    @Override
    public MSCNode.Type getType() {
        return MSCNode.Type.LIFE_LINE;
    }

    @Override
    public boolean positiveDistanceToPoint(int x, int y) {
        return this.getX() > x;
    }
}

