/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;

public final class MSCConstants {
    private static final String COLOR_KEY_BLACK = "COLOR_BLACK";
    private static final String COLOR_KEY_WHITE = "COLOR_WHITE";
    private static final String COLOR_KEY_LIGHTER_GREY = "COLOR_LIGHTER_GREY";
    private static final String COLOR_KEY_LIGHT_GREY = "COLOR_LIGHT_GREY";
    private static final String COLOR_KEY_GREY = "COLOR_GREY";
    private static final String COLOR_KEY_DARK_GREY = "COLOR_DARK_GREY";
    private static final String COLOR_KEY_SOFT_BLUE = "COLOR_SOFT_BLUE";
    private static final String COLOR_KEY_EVENT_RED = "COLOR_EVENT_RED";
    private static final String COLOR_KEY_EVENT_BLUE = "COLOR_EVENT_BLUE";
    private static final String COLOR_KEY_EVENT_YELLOW = "COLOR_EVENT_YELLOW";
    private static final String COLOR_KEY_EVENT_GREEN = "COLOR_EVENT_GREEN";
    private static final String COLOR_KEY_EVENT_ORANGE = "COLOR_EVENT_ORANGE";
    private static final String COLOR_KEY_EVENT_LIME = "COLOR_EVENT_LIME";
    private static final String COLOR_KEY_EVENT_DARK_BLUE = "COLOR_EVENT_DARK_BLUE";
    private static final String COLOR_KEY_EVENT_LIGHT_YELLOW = "COLOR_EVENT_LIGHT_YELLOW";
    private static final String COLOR_KEY_EVENT_LIGHT_ORANGE = "COLOR_EVENT_LIGHT_ORANGE";
    private static final String COLOR_KEY_EVENT_CORAL = "COLOR_EVENT_CORAL";
    private static final String COLOR_KEY_EVENT_FUCHSIA = "COLOR_EVENT_FUCHSIA";
    private static final String COLOR_KEY_EVENT_LIGHT_GREEN = "COLOR_EVENT_LIGHT_GREEN";
    private static final String COLOR_KEY_EVENT_PINK = "COLOR_EVENT_PINK";
    private static final String COLOR_KEY_EVENT_LIGHT_BLUE = "COLOR_EVENT_LIGHT_BLUE";
    private static final String COLOR_KEY_EVENT_DARK_PURPLE = "COLOR_EVENT_DARK_PURPLE";
    private static final String COLOR_KEY_EVENT_PALE_PURPLE = "COLOR_EVENT_PALE_PURPLE";
    private static final String COLOR_KEY_VERDICT_FAIL_ERROR = "COLOR_VERDICT_FAIL_ERROR";
    private static final String COLOR_KEY_VERDICT_INCONC = "COLOR_VERDICT_INCONC";
    private static final String COLOR_KEY_VERDICT_PASS = "COLOR_VERDICT_PASS";
    private static final String COLOR_KEY_VERDICT_NONE = "COLOR_VERDICT_NONE";
    public static final String FONT_DEFAULT_KEY = "FONT_DEFAULT";
    public static final String FONT_BOLD_KEY = "FONT_BOLD";
    public static final String READ_ONLY = "r";
    public static final String READ_WRITE = "rw";
    public static final byte LF = 10;
    public static final byte CR = 13;
    public static final int K = 1024;
    public static final int INITIAL_BUFFER_SIZE = 16384;
    public static final String ID_ZOOM_IN = "org.eclipse.titan.log.viewer.views.msc.ui.actions.ZoomInCoolBar";
    public static final String ID_ZOOM_OUT = "org.eclipse.titan.log.viewer.views.msc.ui.actions.ZoomOutCoolBar";
    public static final String ID_NO_ZOOM = "org.eclipse.titan.log.viewer.views.msc.ui.actions.NoZoom";
    public static final String ID_RESET_ZOOM = "org.eclipse.titan.log.viewer.views.msc.ui.actions.ResetZoom";
    public static final String ID_ZOOM_GROUP = "ZOOM_GROUP";
    public static final String SUT_NAME = "System";
    public static final String MTC_NAME = "MTC";
    public static final String ICON_ZOOM_MASK = "icons/zoom_mask.bmp";
    public static final String ICON_ZOOM_IN_SOURCE = "icons/zoomin_source.bmp";
    public static final String ICON_ZOOM_OUT_SOURCE = "icons/zoomout_source.bmp";
    public static final String ICON_RESET_ZOOM = "icons/home_nav.gif";
    public static final String ICON_MOVE = "icons/move.gif";
    public static final String ICON_ZOOM_IN = "icons/zoomin_nav.gif";
    public static final String ICON_ZOOM_OUT = "icons/zoomout_nav.gif";
    public static final boolean DRAW_BORDER = true;
    public static final boolean DRAW_GRADIENT = true;
    public static final boolean DRAW_SHADOW = true;
    public static final String VERDICT_FAIL_ERROR = "COLOR_VERDICT_FAIL_ERROR";
    public static final String VERDICT_INCONC = "COLOR_VERDICT_INCONC";
    public static final String VERDICT_PASS = "COLOR_VERDICT_PASS";
    public static final String VERDICT_NONE = "COLOR_VERDICT_NONE";
    public static final Map<String, String> SILENT_EVENT_COLORS = new HashMap<String, String>();
    public static final String COMPONENT_BG_COLOR = "COLOR_LIGHT_GREY";
    public static final String COMPONENT_SHADOW_COLOR = "COLOR_GREY";
    public static final String COMPONENT_LINE_COLOR = "COLOR_BLACK";
    public static final String COMPONENT_FONT_COLOR = "COLOR_BLACK";
    public static final String DEFAULT_FOREGROUND_COLOR = "COLOR_BLACK";
    public static final String DEFAULT_BACKGROUND_COLOR = "COLOR_WHITE";
    public static final String LIFELIFE_HEADER_BG_COLOR = "COLOR_SOFT_BLUE";
    public static final String LIFELIFE_HEADER_SHADOW_COLOR = "COLOR_GREY";
    public static final String LIFELIFE_HEADER_LINE_COLOR = "COLOR_BLACK";
    public static final String LIFELIFE_HEADER_FONT_COLOR = "COLOR_BLACK";
    public static final String LIFELIFE_LINE_COLOR = "COLOR_DARK_GREY";
    public static final String MESSAGE_LINE_COLOR = "COLOR_SOFT_BLUE";
    public static final String MESSAGE_FONT_COLOR = "COLOR_BLACK";
    public static final String SETVERDICT_FONT_COLOR = "COLOR_BLACK";
    public static final String SETVERDICT_LINE_COLOR = "COLOR_BLACK";
    public static final String SETVERDICT_SHADOW_COLOR = "COLOR_GREY";
    public static final String SILENT_EVENT_BG_COLOR = "COLOR_LIGHT_GREY";
    public static final String SILENT_EVENT_LINE_COLOR = "COLOR_BLACK";
    public static final String SILENT_EVENT_SHADOW_COLOR = "COLOR_GREY";
    public static final String TESTCASESTART_FONT_COLOR = "COLOR_BLACK";
    public static final String TESTCASEEND_FONT_COLOR = "COLOR_BLACK";
    public static final String TESTCASEEND_LINE_COLOR = "COLOR_BLACK";
    public static final String TESTCASEEND_SHADOW_COLOR = "COLOR_GREY";
    public static final String TIMESTAMP_FONT_COLOR = "COLOR_DARK_GREY";
    public static final String SELECTION_COLOR = "COLOR_LIGHTER_GREY";
    public static final String MSC_DEFAULT_FONT = "FONT_DEFAULT";
    public static final String MSC_BOLD_FONT = "FONT_BOLD";
    private static int fontHeight;
    private static int defaultFontWidth;
    private static int boldFontWidth;
    public static final int ROW_SPACING = 10;
    public static final int COLUMN_SPACING = 12;
    public static final int ROW_HEIGHT;
    public static final int COLUMN_WIDTH;
    public static final int LEFT_MARGIN = 10;
    public static final int RIGHT_MARGIN = 50;
    public static final int TOP_MARGIN = 10;
    public static final int BOTTOM_MARGIN = 50;
    public static final int HEADER_TEXT_H_SPACING = 10;
    public static final int HEADER_TEXT_V_SPACING = 10;
    public static final int HEADER_SHADOW_SIZE = 1;
    public static final int COMPONENT_TEXT_H_SPACING = 10;
    public static final int COMPONENT_SHADOW_SIZE = 1;
    public static final int MESSAGE_SYMBOL_SIZE = 8;
    public static final int MESSAGES_TEXT_VERTICAL_SPACING = 10;
    public static final int INTERNAL_MESSAGE_WIDTH = 20;
    public static final int INTERNAL_MESSAGE_H_MARGIN = 5;
    public static final int SYNC_INTERNAL_MESSAGE_HEIGHT = 10;
    public static final int NORMAL_LINE_WIDTH = 1;
    public static final int SILENT_EVENT_SHADOW_SIZE = 1;
    public static final int SETVERDICT_SIZE = 4;
    public static final int SETVERDICT_SHADOW_SIZE = 1;
    public static final int TESTCASEEND_SHADOW_SIZE = 1;
    public static final int LIFELINE_SIGNIFICANT_HSPACING = 10;
    public static final int MESSAGE_SIGNIFICANT_VSPACING = 1;
    public static final String ARROW_LEFT = " <- ";
    public static final String ARROW_RIGHT = " -> ";

    private MSCConstants() {
    }

    public static Resource getResource(String resourceKey) {
        Resources resourceValue = Resources.getResourceValue(resourceKey);
        if (resourceValue == null) {
            return null;
        }
        Display defaultDisplay = Display.getDefault();
        switch (resourceValue) {
            case COLOR_BLACK: {
                return new Color((Device)defaultDisplay, 0, 0, 0);
            }
            case COLOR_WHITE: {
                return new Color((Device)defaultDisplay, 255, 255, 255);
            }
            case COLOR_LIGHTER_GREY: {
                return new Color((Device)defaultDisplay, 220, 220, 220);
            }
            case COLOR_LIGHT_GREY: {
                return new Color((Device)defaultDisplay, 200, 200, 200);
            }
            case COLOR_GREY: {
                return new Color((Device)defaultDisplay, 150, 150, 150);
            }
            case COLOR_DARK_GREY: {
                return new Color((Device)defaultDisplay, 100, 100, 100);
            }
            case COLOR_SOFT_BLUE: {
                return new Color((Device)defaultDisplay, 135, 155, 165);
            }
            case COLOR_EVENT_RED: {
                return new Color((Device)defaultDisplay, 255, 0, 0);
            }
            case COLOR_EVENT_BLUE: {
                return new Color((Device)defaultDisplay, 0, 0, 255);
            }
            case COLOR_EVENT_YELLOW: {
                return new Color((Device)defaultDisplay, 255, 255, 0);
            }
            case COLOR_EVENT_GREEN: {
                return new Color((Device)defaultDisplay, 0, 255, 0);
            }
            case COLOR_EVENT_ORANGE: {
                return new Color((Device)defaultDisplay, 255, 153, 0);
            }
            case COLOR_EVENT_LIME: {
                return new Color((Device)defaultDisplay, 204, 255, 0);
            }
            case COLOR_EVENT_DARK_BLUE: {
                return new Color((Device)defaultDisplay, 51, 0, 102);
            }
            case COLOR_EVENT_LIGHT_YELLOW: {
                return new Color((Device)defaultDisplay, 255, 255, 204);
            }
            case COLOR_EVENT_LIGHT_ORANGE: {
                return new Color((Device)defaultDisplay, 255, 204, 102);
            }
            case COLOR_EVENT_CORAL: {
                return new Color((Device)defaultDisplay, 255, 127, 80);
            }
            case COLOR_EVENT_FUCHSIA: {
                return new Color((Device)defaultDisplay, 255, 0, 255);
            }
            case COLOR_EVENT_LIGHT_GREEN: {
                return new Color((Device)defaultDisplay, 102, 255, 102);
            }
            case COLOR_EVENT_PINK: {
                return new Color((Device)defaultDisplay, 255, 102, 204);
            }
            case COLOR_EVENT_LIGHT_BLUE: {
                return new Color((Device)defaultDisplay, 0, 204, 255);
            }
            case COLOR_EVENT_DARK_PURPLE: {
                return new Color((Device)defaultDisplay, 102, 0, 153);
            }
            case COLOR_EVENT_PALE_PURPLE: {
                return new Color((Device)defaultDisplay, 255, 204, 255);
            }
            case COLOR_VERDICT_FAIL_ERROR: {
                return new Color((Device)defaultDisplay, 255, 102, 102);
            }
            case COLOR_VERDICT_INCONC: {
                return new Color((Device)defaultDisplay, 232, 242, 254);
            }
            case COLOR_VERDICT_PASS: {
                return new Color((Device)defaultDisplay, 102, 204, 102);
            }
            case COLOR_VERDICT_NONE: {
                return new Color((Device)defaultDisplay, 200, 200, 200);
            }
            case FONT_DEFAULT: {
                FontData fontData = defaultDisplay.getSystemFont().getFontData()[0];
                return new Font((Device)defaultDisplay, fontData.getName(), fontData.getHeight(), 0);
            }
            case FONT_BOLD: {
                FontData fontData = defaultDisplay.getSystemFont().getFontData()[0];
                return new Font((Device)defaultDisplay, fontData.getName(), fontData.getHeight(), 1);
            }
        }
        return null;
    }

    public static String getVerdictColor(String verdict) {
        if (verdict.equals("pass")) {
            return "COLOR_VERDICT_PASS";
        }
        if (verdict.equals("fail") || verdict.equals("error")) {
            return "COLOR_VERDICT_FAIL_ERROR";
        }
        if (verdict.equals("inconc")) {
            return "COLOR_VERDICT_INCONC";
        }
        return "COLOR_VERDICT_NONE";
    }

    public static void setFontHeight(int height) {
        fontHeight = height;
    }

    public static int getFontHeight() {
        return fontHeight;
    }

    public static void setDefaultFontWidth(int width) {
        defaultFontWidth = width;
    }

    public static int getDefaultFontWidth() {
        return defaultFontWidth;
    }

    public static void setBoldFontWidth(int width) {
        boldFontWidth = width;
    }

    public static int getBoldFontWidth() {
        return boldFontWidth;
    }

    static {
        SILENT_EVENT_COLORS.put("ERROR", COLOR_KEY_EVENT_RED);
        SILENT_EVENT_COLORS.put("FUNCTION", COLOR_KEY_EVENT_BLUE);
        SILENT_EVENT_COLORS.put("ACTION", COLOR_KEY_EVENT_YELLOW);
        SILENT_EVENT_COLORS.put("USER", COLOR_KEY_EVENT_GREEN);
        SILENT_EVENT_COLORS.put("WARNING", COLOR_KEY_EVENT_ORANGE);
        SILENT_EVENT_COLORS.put("UNKNOWN", COLOR_KEY_EVENT_LIME);
        SILENT_EVENT_COLORS.put("EXECUTOR", COLOR_KEY_EVENT_DARK_BLUE);
        SILENT_EVENT_COLORS.put("TIMEROP", COLOR_KEY_EVENT_LIGHT_YELLOW);
        SILENT_EVENT_COLORS.put("VERDICTOP", COLOR_KEY_EVENT_LIGHT_ORANGE);
        SILENT_EVENT_COLORS.put("DEFAULTOP", COLOR_KEY_EVENT_CORAL);
        SILENT_EVENT_COLORS.put("PORTEVENT", COLOR_KEY_EVENT_FUCHSIA);
        SILENT_EVENT_COLORS.put("TESTCASE", COLOR_KEY_EVENT_LIGHT_GREEN);
        SILENT_EVENT_COLORS.put("STATISTICS", COLOR_KEY_EVENT_PINK);
        SILENT_EVENT_COLORS.put("PARALLEL", COLOR_KEY_EVENT_LIGHT_BLUE);
        SILENT_EVENT_COLORS.put("MATCHING", COLOR_KEY_EVENT_DARK_PURPLE);
        SILENT_EVENT_COLORS.put("DEBUG", COLOR_KEY_EVENT_PALE_PURPLE);
        fontHeight = 10;
        defaultFontWidth = 5;
        boldFontWidth = 5;
        ROW_HEIGHT = fontHeight * 2 + 10;
        COLUMN_WIDTH = defaultFontWidth * 23 + 12;
    }

    private static enum Resources {
        COLOR_BLACK,
        COLOR_WHITE,
        COLOR_LIGHTER_GREY,
        COLOR_LIGHT_GREY,
        COLOR_GREY,
        COLOR_DARK_GREY,
        COLOR_SOFT_BLUE,
        COLOR_EVENT_RED,
        COLOR_EVENT_BLUE,
        COLOR_EVENT_YELLOW,
        COLOR_EVENT_GREEN,
        COLOR_EVENT_ORANGE,
        COLOR_EVENT_LIME,
        COLOR_EVENT_DARK_BLUE,
        COLOR_EVENT_LIGHT_YELLOW,
        COLOR_EVENT_LIGHT_ORANGE,
        COLOR_EVENT_CORAL,
        COLOR_EVENT_FUCHSIA,
        COLOR_EVENT_LIGHT_GREEN,
        COLOR_EVENT_PINK,
        COLOR_EVENT_LIGHT_BLUE,
        COLOR_EVENT_DARK_PURPLE,
        COLOR_EVENT_PALE_PURPLE,
        COLOR_VERDICT_FAIL_ERROR,
        COLOR_VERDICT_INCONC,
        COLOR_VERDICT_PASS,
        COLOR_VERDICT_NONE,
        FONT_DEFAULT,
        FONT_BOLD;


        public static Resources getResourceValue(String str) {
            try {
                return Resources.valueOf(str);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

