/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.CycleBaseHandler;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.model.PerspectiveLabelProvider;

public class CyclePerspectiveHandler
extends CycleBaseHandler {
    private PerspectiveLabelProvider labelProvider = new PerspectiveLabelProvider(false);

    @Override
    protected void addItems(Table table, WorkbenchPage page) {
        IPerspectiveDescriptor[] perspectives = page.getSortedPerspectives();
        int i = perspectives.length - 1;
        while (i >= 0) {
            TableItem item = new TableItem(table, 0);
            IPerspectiveDescriptor desc = perspectives[i];
            String text = this.labelProvider.getText(desc);
            if (text == null) {
                text = "";
            }
            item.setText(text);
            item.setImage(this.labelProvider.getImage(desc));
            item.setData((Object)desc);
            --i;
        }
    }

    @Override
    protected ParameterizedCommand getBackwardCommand() {
        ICommandService commandService = (ICommandService)this.window.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.eclipse.ui.window.previousPerspective");
        ParameterizedCommand commandBack = new ParameterizedCommand(command, null);
        return commandBack;
    }

    @Override
    protected ParameterizedCommand getForwardCommand() {
        ICommandService commandService = (ICommandService)this.window.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.eclipse.ui.window.nextPerspective");
        ParameterizedCommand commandF = new ParameterizedCommand(command, null);
        return commandF;
    }

    @Override
    protected String getTableHeader(IWorkbenchPart activePart) {
        return WorkbenchMessages.CyclePerspectiveAction_header;
    }

    public void dispose() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
            this.labelProvider = null;
        }
        super.dispose();
    }
}

