/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.AggregateWorkingSet;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.views.markers.CompatibilityFieldFilter;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerResourceUtil;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.internal.views.markers.MarkerTypeFieldFilter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.FiltersContributionParameters;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.internal.MarkerType;

class MarkerFieldFilterGroup {
    private static final String ATTRIBUTE_ON_ANY_IN_SAME_CONTAINER = "ON_ANY_IN_SAME_CONTAINER";
    private static final String ATTRIBUTE_ON_SELECTED_AND_CHILDREN = "ON_SELECTED_AND_CHILDREN";
    private static final String ATTRIBUTE_ON_SELECTED_ONLY = "ON_SELECTED_ONLY";
    private static final String ATTRIBUTE_SCOPE = "scope";
    private static final String ATTRIBUTE_VALUES = "values";
    static final int ON_ANY = 0;
    static final int ON_ANY_IN_SAME_CONTAINER = 3;
    static final int ON_SELECTED_AND_CHILDREN = 2;
    static final int ON_SELECTED_ONLY = 1;
    static final int ON_WORKING_SET = 4;
    static final String TAG_ENABLED = "enabled";
    private static final String TAG_SCOPE = "scope";
    private static final String TAG_FIELD_FILTER_ENTRY = "fieldFilter";
    private static final String TAG_WORKING_SET = "workingSet";
    private static final String TAG_LIMIT = "filterLimit";
    private static String USER = "USER";
    protected MarkerContentGenerator generator;
    private IConfigurationElement element;
    private Map<String, String> EMPTY_MAP = new HashMap<String, String>();
    private boolean enabled = true;
    protected MarkerFieldFilter[] fieldFilters;
    private int scope;
    private int limit;
    private String name;
    private String id;
    private MarkerEntry testEntry = new MarkerEntry(null);
    private IWorkingSet workingSet;
    private IResource[] wSetResources;

    public MarkerFieldFilterGroup(IConfigurationElement configurationElement, MarkerContentGenerator markerBuilder) {
        this.element = configurationElement;
        this.generator = markerBuilder;
        this.initializeWorkingSet();
        this.scope = this.processScope();
        if (configurationElement == null) {
            return;
        }
        String stringValue = configurationElement.getAttribute(TAG_ENABLED);
        if ("false".equals(stringValue)) {
            this.enabled = false;
        }
        if ((stringValue = configurationElement.getAttribute(TAG_LIMIT)) == null || stringValue.length() == 0) {
            this.limit = -1;
        }
    }

    Collection<MarkerType> getAllTypes() {
        return this.generator.getMarkerTypes();
    }

    private MarkerFieldFilter[] getFieldFilters() {
        if (this.fieldFilters == null) {
            this.calculateFilters();
        }
        return this.fieldFilters;
    }

    protected void calculateFilters() {
        Map<String, String> values = this.getValues();
        ArrayList<MarkerFieldFilter> filters = new ArrayList<MarkerFieldFilter>();
        MarkerField[] fields = this.generator.getVisibleFields();
        int i = 0;
        while (i < fields.length) {
            MarkerFieldFilter fieldFilter = MarkerSupportInternalUtilities.generateFilter(fields[i]);
            if (fieldFilter != null) {
                filters.add(fieldFilter);
                if (fieldFilter instanceof MarkerTypeFieldFilter) {
                    ((MarkerTypeFieldFilter)fieldFilter).setContentGenerator(this.generator);
                }
                if (values != null) {
                    fieldFilter.initialize(values);
                }
            }
            ++i;
        }
        MarkerFieldFilter[] newFilters = new MarkerFieldFilter[filters.size()];
        filters.toArray(newFilters);
        this.fieldFilters = newFilters;
    }

    public MarkerFieldFilter getFilter(MarkerField field) {
        MarkerFieldFilter[] filters = this.getFieldFilters();
        int i = 0;
        while (i < filters.length) {
            if (filters[i].getField().equals(field)) {
                return filters[i];
            }
            ++i;
        }
        return null;
    }

    public String getID() {
        if (this.id == null) {
            this.id = this.element == null ? String.valueOf(USER) + String.valueOf(System.currentTimeMillis()) : this.element.getAttribute("name");
        }
        return this.id;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.element == null ? "" : this.element.getAttribute("name");
        }
        return this.name;
    }

    IResource[] getResourcesInWorkingSet() {
        if (this.workingSet == null) {
            return new IResource[0];
        }
        if (this.workingSet.isAggregateWorkingSet() && this.workingSet.isEmpty() && ((AggregateWorkingSet)this.workingSet).getComponents().length == 0) {
            return new IResource[]{ResourcesPlugin.getWorkspace().getRoot()};
        }
        IAdaptable[] elements = this.workingSet.getElements();
        ArrayList<IResource> result = new ArrayList<IResource>(elements.length);
        int idx = 0;
        while (idx < elements.length) {
            IResource next = (IResource)Adapters.adapt((Object)elements[idx], IResource.class);
            if (next != null) {
                result.add(next);
            }
            ++idx;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public int getScope() {
        return this.scope;
    }

    private Map<String, String> getValues() {
        try {
            String className = null;
            if (this.element != null && (className = this.element.getAttribute(ATTRIBUTE_VALUES)) != null) {
                FiltersContributionParameters parameters = (FiltersContributionParameters)IDEWorkbenchPlugin.createExtension(this.element, ATTRIBUTE_VALUES);
                return parameters.getParameterValues();
            }
        }
        catch (CoreException e) {
            Policy.handle(e);
            return null;
        }
        return this.EMPTY_MAP;
    }

    IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    private void computeWorkingSetResources() {
        this.wSetResources = this.workingSet != null ? this.getResourcesInWorkingSet() : new IResource[]{ResourcesPlugin.getWorkspace().getRoot()};
    }

    private boolean isInWorkingSet(IResource resource) {
        if (this.wSetResources == null) {
            this.computeWorkingSetResources();
        }
        int i = 0;
        while (i < this.wSetResources.length) {
            if (this.wSetResources[i].getFullPath().isPrefixOf(resource.getFullPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void initializeWorkingSet() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            this.setWorkingSet(page.getAggregateWorkingSet());
            if (PlatformUI.getPreferenceStore().getBoolean("USE_WINDOW_WORKING_SET_BY_DEFAULT")) {
                this.setScope(4);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSystem() {
        return this.element != null;
    }

    void legacyLoadSettings(IMemento memento) {
        String workingSetName;
        Integer resourceSetting;
        String enabledString = memento.getString(TAG_ENABLED);
        if (enabledString != null && enabledString.length() > 0) {
            this.enabled = Boolean.valueOf(enabledString);
        }
        if ((resourceSetting = memento.getInteger("onResource")) != null) {
            this.scope = resourceSetting;
        }
        if ((workingSetName = memento.getString(TAG_WORKING_SET)) != null) {
            this.setWorkingSet(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(workingSetName));
        }
        if (this.element == null) {
            String idString;
            String nameString = memento.getID();
            if (nameString != null && nameString.length() > 0) {
                this.name = nameString;
            }
            if ((idString = memento.getString("IMemento.internal.id")) != null && idString.length() > 0) {
                this.id = idString;
            }
        }
        MarkerFieldFilter[] filters = this.getFieldFilters();
        int i = 0;
        while (i < filters.length) {
            if (filters[i] instanceof CompatibilityFieldFilter) {
                ((CompatibilityFieldFilter)filters[i]).loadLegacySettings(memento, this.generator);
            }
            ++i;
        }
    }

    void loadSettings(IMemento memento) {
        String stringValue = memento.getString(TAG_ENABLED);
        if (stringValue != null && stringValue.length() > 0) {
            this.enabled = Boolean.valueOf(stringValue);
        }
        this.scope = memento.getInteger("scope");
        String workingSetName = memento.getString(TAG_WORKING_SET);
        if (workingSetName != null) {
            this.setWorkingSet(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(workingSetName));
        }
        if ((stringValue = memento.getString(TAG_LIMIT)) != null && stringValue.length() > 0) {
            this.setLimit(Integer.parseInt(stringValue));
        }
        HashMap<String, MarkerFieldFilter> filterMap = new HashMap<String, MarkerFieldFilter>();
        MarkerFieldFilter[] filters = this.getFieldFilters();
        int i = 0;
        while (i < filters.length) {
            filterMap.put(MarkerSupportInternalUtilities.getId(filters[i].getField()), filters[i]);
            ++i;
        }
        IMemento[] children = memento.getChildren(TAG_FIELD_FILTER_ENTRY);
        int i2 = 0;
        while (i2 < children.length) {
            IMemento childMemento = children[i2];
            String filterId = childMemento.getID();
            if (filterMap.containsKey(filterId)) {
                MarkerFieldFilter filter = (MarkerFieldFilter)filterMap.get(filterId);
                if (filter instanceof MarkerTypeFieldFilter) {
                    ((MarkerTypeFieldFilter)filter).setContentGenerator(this.generator);
                }
                filter.loadSettings(childMemento);
            }
            ++i2;
        }
        if (this.element == null) {
            String idString;
            String nameString = memento.getString("name");
            if (nameString != null && nameString.length() > 0) {
                this.name = nameString;
            }
            if ((idString = memento.getString("IMemento.internal.id")) != null && idString.length() > 0) {
                this.id = idString;
            }
        }
    }

    MarkerFieldFilterGroup makeWorkingCopy() {
        MarkerFieldFilterGroup clone = new MarkerFieldFilterGroup(this.element, this.generator);
        if (this.populateClone(clone)) {
            return clone;
        }
        return null;
    }

    protected boolean populateClone(MarkerFieldFilterGroup clone) {
        clone.scope = this.scope;
        clone.limit = this.limit;
        clone.workingSet = this.workingSet;
        clone.enabled = this.enabled;
        clone.fieldFilters = new MarkerFieldFilter[this.getFieldFilters().length];
        clone.name = this.name;
        clone.id = this.id;
        int i = 0;
        while (i < this.fieldFilters.length) {
            try {
                clone.fieldFilters[i] = (MarkerFieldFilter)this.fieldFilters[i].getClass().newInstance();
                this.fieldFilters[i].populateWorkingCopy(clone.fieldFilters[i]);
            }
            catch (InstantiationException e) {
                StatusManager.getManager().handle(StatusUtil.newStatus(4, e.getLocalizedMessage(), (Throwable)e), 2);
                return false;
            }
            catch (IllegalAccessException e) {
                StatusManager.getManager().handle(StatusUtil.newStatus(4, e.getLocalizedMessage(), (Throwable)e), 2);
                return false;
            }
            ++i;
        }
        return true;
    }

    private int processScope() {
        if (this.element == null) {
            return 0;
        }
        String scopeValue = this.element.getAttribute("scope");
        if (ATTRIBUTE_ON_SELECTED_ONLY.equals(scopeValue)) {
            return 1;
        }
        if (ATTRIBUTE_ON_SELECTED_AND_CHILDREN.equals(scopeValue)) {
            return 2;
        }
        if (ATTRIBUTE_ON_ANY_IN_SAME_CONTAINER.equals(scopeValue)) {
            return 3;
        }
        return 0;
    }

    void saveFilterSettings(IMemento memento) {
        memento.putString(TAG_ENABLED, String.valueOf(this.enabled));
        memento.putString("scope", String.valueOf(this.scope));
        memento.putString(TAG_LIMIT, String.valueOf(this.limit));
        if (this.workingSet != null) {
            memento.putString(TAG_WORKING_SET, this.workingSet.getName());
        }
        if (this.element == null) {
            memento.putString("name", this.getName());
            memento.putString("IMemento.internal.id", this.getID());
        }
        MarkerFieldFilter[] filters = this.getFieldFilters();
        int i = 0;
        while (i < filters.length) {
            IMemento child = memento.createChild(TAG_FIELD_FILTER_ENTRY, MarkerSupportInternalUtilities.getId(filters[i].getField()));
            filters[i].saveSettings(child);
            ++i;
        }
    }

    public boolean select(IMarker marker) {
        this.testEntry.setMarker(marker);
        return this.select(this.testEntry);
    }

    public boolean select(MarkerEntry entry) {
        MarkerFieldFilter[] filters = this.getFieldFilters();
        if (this.scope == 4 && this.workingSet != null && (!this.workingSet.isAggregateWorkingSet() ? !this.isInWorkingSet(entry.getMarker().getResource()) : ((AggregateWorkingSet)this.workingSet).getComponents().length != 0 && !this.isInWorkingSet(entry.getMarker().getResource()))) {
            return false;
        }
        int i = 0;
        while (i < filters.length) {
            if (!filters[i].select(entry)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setScope(int newScope) {
        this.scope = newScope;
    }

    void setWorkingSet(IWorkingSet workingSet) {
        this.workingSet = workingSet;
    }

    int getLimit() {
        return this.limit;
    }

    void setLimit(int limit) {
        this.limit = limit;
    }

    void refresh() {
        if (this.getScope() == 4) {
            this.computeWorkingSetResources();
        }
    }

    public boolean selectByFilters(MarkerEntry entry) {
        return this.select(entry);
    }

    public boolean selectByScope(MarkerEntry entry, IResource[] resources) {
        int scopeVal = this.getScope();
        switch (scopeVal) {
            case 0: {
                return true;
            }
            case 1: {
                IPath markerPath = entry.getMarker().getResource().getFullPath();
                int i = 0;
                while (i < resources.length) {
                    if (markerPath.equals((Object)resources[i].getFullPath())) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case 2: {
                IPath markerPath = entry.getMarker().getResource().getFullPath();
                int i = 0;
                while (i < resources.length) {
                    if (resources[i].getFullPath().isPrefixOf(markerPath)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case 3: {
                IPath markerProjectPath = entry.getMarker().getResource().getFullPath();
                IProject[] projects = MarkerResourceUtil.getProjects(resources);
                int i = 0;
                while (i < projects.length) {
                    if (projects[i].getFullPath().isPrefixOf(markerProjectPath)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case 4: {
                return this.isInWorkingSet(entry.getMarker().getResource());
            }
        }
        return true;
    }
}

