/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.tests.stubs;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;

public class CreateTestFiles {
    private static final String DIRECTORY = "testfiles";
    private static final String[] FILE_NAMES = new String[]{"Test-10K"};
    private static final int[] FILE_SIZES = new int[]{10000};
    private static final int NB_SOURCES = 15;
    private static final int NB_TYPES = 7;

    public static void main(String[] args) {
        try {
            System.out.println("Creating test files in directory: " + new File(".").getCanonicalPath() + File.separator + DIRECTORY);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < FILE_SIZES.length) {
            try {
                CreateTestFiles.createTestFile(DIRECTORY + File.separator + "O-" + FILE_NAMES[i], FILE_SIZES[i], true, true);
                CreateTestFiles.createTestFile(DIRECTORY + File.separator + "E-" + FILE_NAMES[i], FILE_SIZES[i], true, false);
                CreateTestFiles.createTestFile(DIRECTORY + File.separator + "R-" + FILE_NAMES[i], FILE_SIZES[i], false, false);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
            ++i;
        }
        System.out.println("Done.");
    }

    private static void createTestFile(String file, int size, boolean monotonic, boolean odd) throws IOException {
        System.out.println("Creating " + file);
        Throwable throwable = null;
        Object var5_6 = null;
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            Random generator = new Random(19580427 + size);
            long ts = monotonic && odd ? -1 : 0;
            int i = 0;
            while (i < size) {
                int n = monotonic ? 2 : generator.nextInt(10);
                int sourceIndex = i % 15;
                int typeIndex = i % 7;
                out.writeLong(ts += (long)n);
                out.writeUTF("Source-" + sourceIndex);
                out.writeUTF("Type-" + typeIndex);
                out.writeInt(i + 1);
                int j = 0;
                while (j < typeIndex) {
                    out.writeUTF("Field-" + sourceIndex + "-" + j);
                    ++j;
                }
                ++i;
            }
            out.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

