/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.AbstractSegmentStoreAnalysisModule;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;

public class StubSegmentStoreProvider
extends AbstractSegmentStoreAnalysisModule {
    static final String STUB_COLUMN_NAME = "Stub Column";
    static final String STUB_COLUMN_CONTENT = "Stub Content";
    static final String NEXT_DIR_UNDER_TEST = "NEXT";
    static final String PREV_DIR_UNDER_TEST = "PREVIOUS";
    private static final int SIZE = 65535;
    private final List<@NonNull ISegment> fPreFixture;
    private static final @NonNull ISegmentAspect STUB_CUSTOM_ASPECT = new ISegmentAspect(){

        public @Nullable Object resolve(@NonNull ISegment segment) {
            return StubSegmentStoreProvider.STUB_COLUMN_CONTENT;
        }

        public @NonNull String getName() {
            return StubSegmentStoreProvider.STUB_COLUMN_NAME;
        }

        public @NonNull String getHelpText() {
            return "Stub segment column information";
        }

        public @Nullable Comparator<?> getComparator() {
            return null;
        }
    };

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public StubSegmentStoreProvider() {
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull ImmutableList.Builder builder = new ImmutableList.Builder();
        int previousStartTime = 0;
        int i = 0;
        while (i < 65535) {
            if (i % 7 == 0) {
                previousStartTime = i;
            }
            BasicSegment segment = new BasicSegment((long)previousStartTime, (long)i);
            builder.add((Object)segment);
            ++i;
        }
        this.fPreFixture = builder.build();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public StubSegmentStoreProvider(boolean nullSegments) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull ImmutableList.Builder builder = new ImmutableList.Builder();
        if (nullSegments) {
            this.fPreFixture = builder.build();
        } else {
            int previousStartTime = 0;
            int i = 0;
            while (i < 65535) {
                if (i % 7 == 0) {
                    previousStartTime = i;
                }
                BasicSegment segment = new BasicSegment((long)previousStartTime, (long)i);
                builder.add((Object)segment);
                ++i;
            }
            this.fPreFixture = builder.build();
        }
    }

    protected boolean buildAnalysisSegments(@NonNull ISegmentStore<@NonNull ISegment> segmentStore, @NonNull IProgressMonitor monitor) throws TmfAnalysisException {
        return segmentStore.addAll(this.fPreFixture);
    }

    protected void canceling() {
    }

    public boolean setTrace(@NonNull ITmfTrace trace) throws TmfAnalysisException {
        if (trace instanceof TmfXmlTraceStub) {
            TmfXmlTraceStub tmfXmlTraceStub = (TmfXmlTraceStub)trace;
            tmfXmlTraceStub.addAnalysisModule((IAnalysisModule)this);
        }
        return super.setTrace(trace);
    }

    public @NonNull Iterable<@NonNull ISegmentAspect> getSegmentAspects() {
        return ImmutableList.of((Object)STUB_CUSTOM_ASPECT);
    }

    public boolean executeAnalysis(@NonNull IProgressMonitor monitor) throws TmfAnalysisException {
        return super.executeAnalysis(monitor);
    }
}

