/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension7;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.texteditor.HippieCompletionEngine;
import org.eclipse.ui.texteditor.ITextEditor;

public final class HippieProposalProcessor
implements IContentAssistProcessor {
    private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];
    private static final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private final HippieCompletionEngine fEngine = new HippieCompletionEngine();

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            String prefix = this.getPrefix(viewer, offset);
            if (prefix == null || prefix.isEmpty()) {
                return NO_PROPOSALS;
            }
            ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
            for (String string : this.getSuggestions(viewer, offset, prefix)) {
                if (string.isEmpty()) continue;
                result.add(this.createProposal(string, prefix, offset));
            }
            return result.toArray(new ICompletionProposal[result.size()]);
        }
        catch (BadLocationException x) {
            return NO_PROPOSALS;
        }
    }

    private String getPrefix(ITextViewer viewer, int offset) throws BadLocationException {
        IDocument doc = viewer.getDocument();
        if (doc == null || offset > doc.getLength()) {
            return null;
        }
        int length = 0;
        while (--offset >= 0 && Character.isJavaIdentifierPart(doc.getChar(offset))) {
            ++length;
        }
        return doc.get(offset + 1, length);
    }

    private ICompletionProposal createProposal(String string, String prefix, int offset) {
        return new Proposal(string, prefix, offset);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private ArrayList<String> createSuggestionsFromOpenDocument(ITextViewer viewer, int offset, String prefix) throws BadLocationException {
        IDocument document = viewer.getDocument();
        ArrayList<String> completions = new ArrayList<String>();
        completions.addAll(this.fEngine.getCompletionsBackwards(document, prefix, offset));
        completions.addAll(this.fEngine.getCompletionsForward(document, prefix, offset - prefix.length(), true));
        return completions;
    }

    private List<String> getSuggestions(ITextViewer viewer, int offset, String prefix) throws BadLocationException {
        ArrayList<String> suggestions = this.createSuggestionsFromOpenDocument(viewer, offset, prefix);
        IDocument currentDocument = viewer.getDocument();
        for (ITextEditor editor : this.findTextEditors()) {
            IDocument doc = editor.getDocumentProvider().getDocument(editor.getEditorInput());
            if (doc == null || doc.equals(currentDocument)) continue;
            suggestions.addAll(this.fEngine.getCompletionsForward(doc, prefix, 0, false));
        }
        suggestions.add("");
        return this.fEngine.makeUnique(suggestions);
    }

    private Collection<ITextEditor> findTextEditors() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Stream<Object> windows = null;
        windows = window != null ? Collections.singleton(window).stream() : Arrays.stream(PlatformUI.getWorkbench().getWorkbenchWindows());
        return windows.flatMap(aWindow -> Arrays.stream(aWindow.getPages())).flatMap(workbenchPage -> Arrays.stream(workbenchPage.getEditorReferences())).map(editorRef -> editorRef.getEditor(false)).filter(Objects::nonNull).filter(ITextEditor.class::isInstance).map(ITextEditor.class::cast).collect(Collectors.toSet());
    }

    public String getErrorMessage() {
        return null;
    }

    private static final class Proposal
    implements ICompletionProposal,
    ICompletionProposalExtension,
    ICompletionProposalExtension2,
    ICompletionProposalExtension3,
    ICompletionProposalExtension4,
    ICompletionProposalExtension6,
    ICompletionProposalExtension7 {
        private final String fString;
        private final String fPrefix;
        private final int fOffset;
        private StyledString fDisplayString;

        public Proposal(String string, String prefix, int offset) {
            this.fString = string;
            this.fPrefix = prefix;
            this.fOffset = offset;
        }

        public void apply(IDocument document) {
            this.apply(null, '\u0000', 0, this.fOffset);
        }

        public Point getSelection(IDocument document) {
            return new Point(this.fOffset + this.fString.length(), 0);
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public String getDisplayString() {
            return this.fPrefix + this.fString;
        }

        public Image getImage() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public void apply(IDocument document, char trigger, int offset) {
            try {
                String replacement = this.fString.substring(offset - this.fOffset);
                document.replace(offset, 0, replacement);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public boolean isValidFor(IDocument document, int offset) {
            return this.validate(document, offset, null);
        }

        public char[] getTriggerCharacters() {
            return null;
        }

        public int getContextInformationPosition() {
            return 0;
        }

        public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
            this.apply(viewer.getDocument(), trigger, offset);
        }

        public void selected(ITextViewer viewer, boolean smartToggle) {
        }

        public void unselected(ITextViewer viewer) {
        }

        public boolean validate(IDocument document, int offset, DocumentEvent event) {
            try {
                int prefixStart = this.fOffset - this.fPrefix.length();
                return offset >= this.fOffset && offset < this.fOffset + this.fString.length() && document.get(prefixStart, offset - prefixStart).equals((this.fPrefix + this.fString).substring(0, offset - prefixStart));
            }
            catch (BadLocationException x) {
                return false;
            }
        }

        public IInformationControlCreator getInformationControlCreator() {
            return null;
        }

        public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
            return this.fPrefix + this.fString;
        }

        public int getPrefixCompletionStart(IDocument document, int completionOffset) {
            return this.fOffset - this.fPrefix.length();
        }

        public boolean isAutoInsertable() {
            return true;
        }

        public StyledString getStyledDisplayString() {
            if (this.fDisplayString == null) {
                this.fDisplayString = new StyledString(this.getDisplayString());
            }
            return this.fDisplayString;
        }

        public StyledString getStyledDisplayString(IDocument document, int offset, BoldStylerProvider boldStylerProvider) {
            StyledString styledDisplayString = new StyledString();
            styledDisplayString.append(this.getStyledDisplayString());
            int start = this.getPrefixCompletionStart(document, offset);
            int patternLength = offset - start;
            if (patternLength > 0) {
                styledDisplayString.setStyle(0, patternLength, boldStylerProvider.getBoldStyler());
            }
            return styledDisplayString;
        }
    }
}

