/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.providers;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.virgo.ide.runtime.core.IServerRuntimeProvider;
import org.eclipse.virgo.ide.runtime.internal.core.runtimes.RuntimeProviders;
import org.eclipse.virgo.ide.runtime.internal.ui.providers.ServerFile;
import org.eclipse.virgo.ide.runtime.internal.ui.providers.ServerFileContentProvider;
import org.eclipse.virgo.ide.runtime.internal.ui.providers.ServerFileSelection;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;

public class PropertiesFileContentProvider
extends ServerFileContentProvider {
    public static final String PROPERTIES_EXT = "properties";
    public static final String[] PROPERTIES_INCLUDE_EXTS = null;
    public static final String[] PROPERTIES_EXCLUDE_EXTS = new String[]{"jar", "plan", "libd"};

    public Object[] getElements(Object inputElement) {
        ServerFile serverFile;
        IFile file;
        if (inputElement instanceof ServerFile && !(inputElement instanceof ServerFileSelection) && (file = (serverFile = (ServerFile)inputElement).getFile()).getLocation().getFileExtension() != null && file.getLocation().getFileExtension().equals(PROPERTIES_EXT)) {
            try {
                String osString = file.getLocation().toOSString();
                BufferedReader bufferedReader = new BufferedReader(new FileReader(osString));
                ArrayList<ServerFileSelection> lines = new ArrayList<ServerFileSelection>();
                String readLine = bufferedReader.readLine();
                int offset = 0;
                while (readLine != null) {
                    int posEquals = readLine.indexOf("=") + 1;
                    if (readLine.endsWith("\\")) {
                        String nextLine = bufferedReader.readLine();
                        int lineCount = 1;
                        while (nextLine.endsWith("\\")) {
                            readLine = String.valueOf(readLine) + nextLine;
                            nextLine = bufferedReader.readLine();
                            ++lineCount;
                        }
                        readLine = String.valueOf(readLine) + nextLine;
                        String cleanLine = readLine.replaceAll("\\\\", "");
                        ServerFileSelection serverFileSelection = new ServerFileSelection(serverFile.getServer(), file, cleanLine, offset + posEquals, readLine.length() + lineCount - posEquals, lines.size() + 1);
                        lines.add(serverFileSelection);
                        offset += lineCount;
                    } else if (!(readLine.startsWith("#") || StringUtils.isBlank((String)readLine) || readLine.endsWith("\\"))) {
                        ServerFileSelection serverFileSelection = new ServerFileSelection(serverFile.getServer(), file, readLine, offset + posEquals, readLine.length() - posEquals, lines.size() + 1);
                        lines.add(serverFileSelection);
                    }
                    offset += readLine.length() + 1;
                    readLine = bufferedReader.readLine();
                }
                bufferedReader.close();
                return lines.toArray();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
        return super.getElements(inputElement);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ServerFile && !(element instanceof ServerFileSelection)) {
            IFile file = ((ServerFile)element).file;
            return file.getLocation().getFileExtension() != null && file.getLocation().getFileExtension().equals(PROPERTIES_EXT);
        }
        return super.hasChildren(element);
    }

    public String[] getServerDirectories(IServer server) {
        IServerRuntimeProvider provider = RuntimeProviders.getRuntimeProvider((IRuntime)server.getRuntime());
        return provider.getServerPropertiesDirectories();
    }

    public String getBaseDirectory() {
        return PROPERTIES_EXT;
    }

    public String[] getIncludeExtensions() {
        return PROPERTIES_INCLUDE_EXTS;
    }

    public String[] getExcludeExtensions() {
        return PROPERTIES_EXCLUDE_EXTS;
    }

    public boolean isIncludeNoExtension() {
        return false;
    }
}

