/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.equinox.internal.ds.SCRCommandProvider;
import org.eclipse.equinox.internal.ds.SCRManager;
import org.eclipse.equinox.internal.ds.ScrServiceImpl;
import org.eclipse.equinox.internal.ds.WorkThread;
import org.eclipse.equinox.internal.util.ref.Log;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator,
SynchronousBundleListener,
ServiceListener {
    public static BundleContext bc = null;
    public static ConfigurationAdmin configAdmin = null;
    public static boolean security = false;
    private ServiceRegistration configListenerReg;
    private SCRManager scrManager = null;
    public ScrServiceImpl scrService = null;
    private ServiceRegistration scrServiceReg;
    private ServiceRegistration scrCommandProviderReg;
    private static FrameworkLog fwLog;
    private boolean inited = false;
    public static Log log;
    public static boolean DEBUG;
    public static boolean PERF;
    public static boolean DBSTORE;
    public static boolean INSTANTIATE_ALL;
    public static boolean startup;
    static long[] time;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    static {
        time = null;
    }

    public static void timeLog(String message) {
        Activator.time[1] = time[0];
        Activator.time[0] = System.currentTimeMillis();
        log.debug(String.valueOf(message) + String.valueOf(Activator.time[0] - time[1]), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSCR() {
        Class<?> clazz;
        ServiceReference caRef;
        Class<?> clazz2;
        Activator activator = this;
        synchronized (activator) {
            if (this.inited) {
                return;
            }
            this.inited = true;
        }
        boolean lazyIniting = false;
        if (startup && time == null) {
            long tmp = System.currentTimeMillis();
            long[] lArray = new long[3];
            lArray[0] = tmp;
            lArray[2] = tmp;
            time = lArray;
            lazyIniting = true;
            if (startup) {
                Activator.timeLog("[BEGIN - lazy SCR init]");
            }
        }
        WorkThread.IDLE_TIMEOUT = Activator.getInteger("equinox.ds.idle_timeout", 1000);
        WorkThread.BLOCK_TIMEOUT = Activator.getInteger("equinox.ds.block_timeout", 30000);
        try {
            StringBuffer stringBuffer = new StringBuffer("(objectClass=");
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("org.osgi.service.cm.ConfigurationAdmin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            bc.addServiceListener((ServiceListener)this, stringBuffer.append(clazz3.getName()).append(')').toString());
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if ((clazz2 = class$0) == null) {
            try {
                clazz2 = class$0 = Class.forName("org.osgi.service.cm.ConfigurationAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((caRef = bc.getServiceReference(clazz2.getName())) != null) {
            configAdmin = (ConfigurationAdmin)bc.getService(caRef);
        }
        if (startup) {
            Activator.timeLog("ConfigurationAdmin service getting took ");
        }
        this.scrManager = new SCRManager();
        if (startup) {
            Activator.timeLog("SCRManager instantiation took ");
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.cm.ConfigurationListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.configListenerReg = bc.registerService(clazz.getName(), (Object)this.scrManager, null);
        if (startup) {
            Activator.timeLog("ConfigurationListener service registered for ");
        }
        bc.addServiceListener((ServiceListener)this.scrManager);
        this.scrManager.startIt();
        if (startup) {
            Activator.timeLog("startIt() method took ");
        }
        this.installCommandProvider();
        if (startup && lazyIniting) {
            log.debug("[END - lazy SCR init] Activator.initSCR() method executed for " + String.valueOf(time[0] - time[2]), null);
            time = null;
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        Class<?> clazz;
        ServiceReference fwRef;
        bc = bundleContext;
        startup = Activator.getBoolean("equinox.measurements.bundles", false);
        if (startup) {
            long tmp = System.currentTimeMillis();
            long[] lArray = new long[3];
            lArray[0] = tmp;
            lArray[2] = tmp;
            time = lArray;
        }
        log = new Log(bundleContext, false);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceTracker debugTracker = new ServiceTracker(bundleContext, clazz2.getName(), null);
        debugTracker.open();
        DebugOptions debugOptions = (DebugOptions)debugTracker.getService();
        DEBUG = this.getBooleanDebugOption(debugOptions, "org.eclipse.equinox.ds/debug", false) || Activator.getBoolean("equinox.ds.debug", false);
        PERF = this.getBooleanDebugOption(debugOptions, "org.eclipse.equinox.ds/performance", false) || Activator.getBoolean("equinox.ds.perf", false);
        INSTANTIATE_ALL = this.getBooleanDebugOption(debugOptions, "org.eclipse.equinox.ds/instantiate_all", false) || Activator.getBoolean("equinox.ds.instantiate_all", false);
        DBSTORE = this.getBooleanDebugOption(debugOptions, "org.eclipse.equinox.ds/cache_descriptions", true) || Activator.getBoolean("equinox.ds.dbstore", true);
        boolean print = this.getBooleanDebugOption(debugOptions, "org.eclipse.equinox.ds/print_on_console", false) || Activator.getBoolean("equinox.ds.print", false);
        log.setDebug(DEBUG);
        log.setPrintOnConsole(print);
        debugTracker.close();
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((fwRef = bc.getServiceReference(clazz3.getName())) != null) {
            fwLog = (FrameworkLog)bc.getService(fwRef);
        }
        if (startup) {
            Activator.timeLog("[BEGIN - start method] Creating Log instance and initializing log system took ");
        }
        security = Log.security();
        boolean hasHeaders = false;
        Bundle[] allBundles = bundleContext.getBundles();
        int i = 0;
        while (i < allBundles.length) {
            Dictionary allHeaders = allBundles[i].getHeaders("");
            if (allHeaders.get("Service-Component") != null) {
                hasHeaders = true;
                break;
            }
            ++i;
        }
        if (hasHeaders) {
            this.initSCR();
        } else {
            bundleContext.addBundleListener((BundleListener)this);
        }
        if ((clazz = class$4) == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference envInfoRef = bc.getServiceReference(clazz.getName());
        EnvironmentInfo envInfo = null;
        if (envInfoRef != null) {
            envInfo = (EnvironmentInfo)bc.getService(envInfoRef);
        }
        if (envInfo != null) {
            envInfo.setProperty("equinox.use.ds", "true");
            bc.ungetService(envInfoRef);
        } else {
            System.setProperty("equinox.use.ds", "true");
        }
        this.scrService = new ScrServiceImpl();
        Class<?> clazz4 = class$5;
        if (clazz4 == null) {
            try {
                clazz4 = class$5 = Class.forName("org.apache.felix.scr.ScrService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.scrServiceReg = bc.registerService(clazz4.getName(), (Object)this.scrService, null);
        if (startup) {
            log.debug("[END - start method] Activator.start() method executed for " + String.valueOf(time[0] - time[2]), null);
            time = null;
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        Class<?> clazz;
        if (this.scrManager != null) {
            this.scrManager.stopIt();
            bundleContext.removeServiceListener((ServiceListener)this.scrManager);
        }
        if (this.configListenerReg != null) {
            this.configListenerReg.unregister();
        }
        if (this.scrService != null) {
            this.scrService.dispose();
            this.scrServiceReg.unregister();
        }
        if (this.scrCommandProviderReg != null) {
            this.scrCommandProviderReg.unregister();
        }
        if (this.scrManager != null) {
            bundleContext.removeBundleListener((BundleListener)this.scrManager);
        } else {
            bundleContext.removeBundleListener((BundleListener)this);
        }
        if ((clazz = class$4) == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference envInfoRef = bc.getServiceReference(clazz.getName());
        EnvironmentInfo envInfo = null;
        if (envInfoRef != null) {
            envInfo = (EnvironmentInfo)bc.getService(envInfoRef);
        }
        if (envInfo != null) {
            envInfo.setProperty("equinox.use.ds", "false");
            bc.ungetService(envInfoRef);
        } else {
            System.setProperty("equinox.use.ds", "false");
        }
        log.close();
        log = null;
    }

    public static Filter createFilter(String filter) throws InvalidSyntaxException {
        return bc.createFilter(filter);
    }

    public void bundleChanged(BundleEvent event) {
        Dictionary allHeaders;
        if ((event.getType() == 2 || event.getType() == 512) && (allHeaders = event.getBundle().getHeaders("")).get("Service-Component") != null) {
            bc.removeBundleListener((BundleListener)this);
            this.initSCR();
        }
    }

    public static Configuration getConfiguration(String pid) throws IOException {
        if (configAdmin != null) {
            return configAdmin.getConfiguration(pid);
        }
        return null;
    }

    public static Configuration[] listConfigurations(String filter) throws IOException, InvalidSyntaxException {
        if (configAdmin != null) {
            return configAdmin.listConfigurations(filter);
        }
        return null;
    }

    public static boolean getBoolean(String property, boolean defaultValue) {
        String prop;
        String string = prop = bc != null ? bc.getProperty(property) : System.getProperty(property);
        if (prop != null) {
            return prop.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    public static boolean getBoolean(String property) {
        return Activator.getBoolean(property, false);
    }

    public static int getInteger(String property, int defaultValue) {
        String prop;
        String string = prop = bc != null ? bc.getProperty(property) : System.getProperty(property);
        if (prop != null) {
            try {
                return Integer.decode(prop);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    public boolean getBooleanDebugOption(DebugOptions optionsService, String option, boolean defaultValue) {
        String value;
        if (optionsService != null && (value = optionsService.getOption(option)) != null) {
            return value.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    private void installCommandProvider() {
        block6: {
            try {
                SCRCommandProvider scrCommandProvider = new SCRCommandProvider(this.scrManager);
                Hashtable<String, Integer> reg_props = new Hashtable<String, Integer>(1, 1.0f);
                reg_props.put("service.ranking", new Integer(Integer.MAX_VALUE));
                Class<?> clazz = class$6;
                if (clazz == null) {
                    try {
                        clazz = class$6 = Class.forName("org.eclipse.osgi.framework.console.CommandProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.scrCommandProviderReg = bc.registerService(clazz.getName(), (Object)scrCommandProvider, reg_props);
            }
            catch (NoClassDefFoundError e) {
                if (!DEBUG) break block6;
                log.debug("Cannot register SCR CommandProvider!", (Throwable)e);
            }
        }
    }

    public static void log(BundleContext bundleContext, int level, String message, Throwable t) {
        ServiceReference logRef;
        LogService logService;
        block26: {
            logService = null;
            logRef = null;
            if (bundleContext != null) {
                try {
                    Class<?> clazz = class$7;
                    if (clazz == null) {
                        try {
                            clazz = class$7 = Class.forName("org.osgi.service.log.LogService");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((logRef = bundleContext.getServiceReference(clazz.getName())) != null) {
                        logService = (LogService)bundleContext.getService(logRef);
                    }
                }
                catch (Exception e) {
                    if (!DEBUG) break block26;
                    log.debug("Cannot get LogService for bundle " + bundleContext.getBundle().getSymbolicName(), (Throwable)e);
                }
            }
        }
        if (logService != null) {
            logService.log(level, message, t);
            bundleContext.ungetService(logRef);
            if (log.getPrintOnConsole()) {
                String prefix = "";
                switch (level) {
                    case 1: {
                        prefix = "ERROR ";
                        break;
                    }
                    case 2: {
                        prefix = "WARNING ";
                        break;
                    }
                    case 3: {
                        prefix = "INFO ";
                    }
                }
                Activator.dumpOnConsole(prefix, bundleContext, message, t, level == 1);
            }
        } else {
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("org.osgi.service.log.LogService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((logRef = bc.getServiceReference(clazz.getName())) == null && !log.getPrintOnConsole() && !Activator.log.autoPrintOnConsole && fwLog == null && level == 1) {
                Activator.dumpOnConsole("ERROR ", bundleContext, message, t, true);
            }
            switch (level) {
                case 1: {
                    log.error(message, t);
                    break;
                }
                case 2: {
                    log.warning(message, t);
                    break;
                }
                case 3: {
                    log.info(message);
                    break;
                }
                default: {
                    log.debug(message, t);
                }
            }
        }
        if (fwLog != null) {
            Activator.logToFWLog(bundleContext != null ? bundleContext.getBundle().getSymbolicName() : bc.getBundle().getSymbolicName(), level, message, t);
        }
    }

    private static void dumpOnConsole(String prefix, BundleContext bundleContext, String msg, Throwable t, boolean printInErr) {
        String message = String.valueOf(prefix) + bundleContext.getBundle().getBundleId() + " " + msg;
        if (printInErr) {
            System.err.println(message);
        } else {
            System.out.println(message);
        }
        if (t != null) {
            t.printStackTrace();
        }
    }

    private static void logToFWLog(String bsn, int level, String message, Throwable t) {
        int severity = 1;
        switch (level) {
            case 1: {
                severity = 4;
                break;
            }
            case 2: {
                severity = 2;
                break;
            }
            case 3: {
                severity = 1;
                break;
            }
            case 4: {
                severity = 1;
            }
        }
        fwLog.log(new FrameworkLogEntry(bsn, severity, 0, message, 0, t, null));
    }

    public void serviceChanged(ServiceEvent event) {
        switch (event.getType()) {
            case 1: {
                Object caService = bc.getService(event.getServiceReference());
                configAdmin = (ConfigurationAdmin)caService;
                if (caService == null || this.scrManager == null) break;
                this.scrManager.configAdminRegistered((ConfigurationAdmin)caService, event.getServiceReference());
                break;
            }
            case 4: {
                ServiceReference caRef;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.osgi.service.cm.ConfigurationAdmin");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                configAdmin = (caRef = bc.getServiceReference(clazz.getName())) != null ? (ConfigurationAdmin)bc.getService(caRef) : null;
            }
        }
    }
}

