/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgi.region;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFrameworkLogEvents;
import org.eclipse.virgo.kernel.osgi.region.RegionManagerParserLogger;
import org.eclipse.virgo.kernel.serviceability.Assert;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.virgo.util.osgi.manifest.DynamicImportPackage;
import org.eclipse.virgo.util.osgi.manifest.DynamicallyImportedPackage;
import org.eclipse.virgo.util.osgi.manifest.parse.ParserLogger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PackageImportWildcardExpander {
    private static final String wildcard = "*";
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    PackageImportWildcardExpander() {
    }

    static String expandPackageImportsWildcards(String userRegionImportsProperty, BundleContext bundleContext) {
        try {
            PackageImportWildcardExpander.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
            ServiceReference eventLoggerServiceReference = bundleContext.getServiceReference(EventLogger.class.getName());
            EventLogger eventLogger = (EventLogger)bundleContext.getService(eventLoggerServiceReference);
            String[] exportedPackageNames = PackageImportWildcardExpander.getExportedPackageNames(bundleContext);
            String expandedUserRegionImportsProperty = PackageImportWildcardExpander.expandWildcards(userRegionImportsProperty, exportedPackageNames, eventLogger);
            bundleContext.ungetService(eventLoggerServiceReference);
            String string = expandedUserRegionImportsProperty;
            PackageImportWildcardExpander.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
            return string;
        }
        catch (Throwable throwable) {
            PackageImportWildcardExpander.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private static String[] getExportedPackageNames(BundleContext bundleContext) {
        HashSet<String> exportedPackageNames = new HashSet<String>();
        ExportedPackage[] exportedPackageArray = PackageImportWildcardExpander.getExportedPackages(bundleContext);
        int n = exportedPackageArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExportedPackage exportedPackage = exportedPackageArray[n2];
            exportedPackageNames.add(exportedPackage.getName());
            ++n2;
        }
        return exportedPackageNames.toArray(new String[0]);
    }

    private static ExportedPackage[] getExportedPackages(BundleContext bundleContext) {
        ServiceReference paServiceReference = bundleContext.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin pa = (PackageAdmin)bundleContext.getService(paServiceReference);
        ExportedPackage[] exportedPackages = pa.getExportedPackages(null);
        Assert.notNull((Object)exportedPackages, (String)"Expected at least one exported package", (Object[])new Object[0]);
        bundleContext.ungetService(paServiceReference);
        return exportedPackages;
    }

    private static String expandWildcards(String userRegionImportsProperty, String[] exportedPackageNamess, EventLogger eventLogger) {
        try {
            PackageImportWildcardExpander.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            DynamicImportPackage dynamicImportPackage = PackageImportWildcardExpander.representImportsAsDynamicImports(userRegionImportsProperty, eventLogger);
            String string = PackageImportWildcardExpander.expandWildcards(dynamicImportPackage, exportedPackageNamess, eventLogger);
            PackageImportWildcardExpander.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return string;
        }
        catch (Throwable throwable) {
            PackageImportWildcardExpander.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private static DynamicImportPackage representImportsAsDynamicImports(String userRegionImportsProperty, EventLogger eventLogger) {
        try {
            PackageImportWildcardExpander.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            Hashtable<String, String> headers = new Hashtable<String, String>();
            ((Dictionary)headers).put("DynamicImport-Package", userRegionImportsProperty);
            BundleManifest manifest = BundleManifestFactory.createBundleManifest(headers, (ParserLogger)new RegionManagerParserLogger(eventLogger));
            DynamicImportPackage dynamicImportPackage = manifest.getDynamicImportPackage();
            PackageImportWildcardExpander.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return dynamicImportPackage;
        }
        catch (Throwable throwable) {
            PackageImportWildcardExpander.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private static String expandWildcards(DynamicImportPackage dynamicImportPackage, String[] exportedPackageNames, EventLogger eventLogger) {
        try {
            PackageImportWildcardExpander.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            StringBuffer expandedPackages = new StringBuffer();
            boolean first = true;
            List dynamicallyImportedPackages = dynamicImportPackage.getDynamicallyImportedPackages();
            for (DynamicallyImportedPackage dynamicallyImportedPackage : dynamicallyImportedPackages) {
                String possiblyWildcardedPackageName = dynamicallyImportedPackage.getPackageName();
                if (possiblyWildcardedPackageName.endsWith(wildcard)) {
                    List<String> expansions = PackageImportWildcardExpander.expandWildcard(possiblyWildcardedPackageName, exportedPackageNames, eventLogger);
                    for (String expansion : expansions) {
                        dynamicallyImportedPackage.setPackageName(expansion);
                        if (first) {
                            first = false;
                        } else {
                            expandedPackages.append(",");
                        }
                        expandedPackages.append(dynamicallyImportedPackage.toParseString());
                    }
                    continue;
                }
                if (first) {
                    first = false;
                } else {
                    expandedPackages.append(",");
                }
                expandedPackages.append(dynamicallyImportedPackage.toParseString());
            }
            String string = expandedPackages.toString();
            PackageImportWildcardExpander.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return string;
        }
        catch (Throwable throwable) {
            PackageImportWildcardExpander.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private static List<String> expandWildcard(String wildcardedPackageName, String[] exportedPackageNames, EventLogger eventLogger) {
        try {
            PackageImportWildcardExpander.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            ArrayList<String> expansions = new ArrayList<String>();
            String prefix = wildcardedPackageName.substring(0, wildcardedPackageName.length() - 1);
            String[] stringArray = exportedPackageNames;
            int n = exportedPackageNames.length;
            int n2 = 0;
            while (n2 < n) {
                String exportedPackage = stringArray[n2];
                if (exportedPackage.startsWith(prefix)) {
                    expansions.add(exportedPackage);
                }
                ++n2;
            }
            if (expansions.isEmpty()) {
                eventLogger.log((LogEvent)OsgiFrameworkLogEvents.REGION_IMPORT_NO_MATCH, new Object[]{wildcardedPackageName});
            }
            ArrayList<String> arrayList = expansions;
            PackageImportWildcardExpander.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return arrayList;
        }
        catch (Throwable throwable) {
            PackageImportWildcardExpander.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("PackageImportWildcardExpander.java", Class.forName("org.eclipse.virgo.kernel.osgi.region.PackageImportWildcardExpander"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8", "expandPackageImportsWildcards", "org.eclipse.virgo.kernel.osgi.region.PackageImportWildcardExpander", "java.lang.String:org.osgi.framework.BundleContext:", "userRegionImportsProperty:bundleContext:", "", "java.lang.String"), 51);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "expandWildcards", "org.eclipse.virgo.kernel.osgi.region.PackageImportWildcardExpander", "java.lang.String:[Ljava.lang.String;:org.eclipse.virgo.medic.eventlog.EventLogger:", "userRegionImportsProperty:exportedPackageNamess:eventLogger:", "", "java.lang.String"), 84);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "representImportsAsDynamicImports", "org.eclipse.virgo.kernel.osgi.region.PackageImportWildcardExpander", "java.lang.String:org.eclipse.virgo.medic.eventlog.EventLogger:", "userRegionImportsProperty:eventLogger:", "", "org.eclipse.virgo.util.osgi.manifest.DynamicImportPackage"), 89);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "expandWildcards", "org.eclipse.virgo.kernel.osgi.region.PackageImportWildcardExpander", "org.eclipse.virgo.util.osgi.manifest.DynamicImportPackage:[Ljava.lang.String;:org.eclipse.virgo.medic.eventlog.EventLogger:", "dynamicImportPackage:exportedPackageNames:eventLogger:", "", "java.lang.String"), 97);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "expandWildcard", "org.eclipse.virgo.kernel.osgi.region.PackageImportWildcardExpander", "java.lang.String:[Ljava.lang.String;:org.eclipse.virgo.medic.eventlog.EventLogger:", "wildcardedPackageName:exportedPackageNames:eventLogger:", "", "java.util.List"), 127);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.osgi.region.PackageImportWildcardExpander");
    }
}

