/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtils {
    private static final Map<Class<?>, Set<Class<?>>> SUBTYPES_BY_PRIMITIVE;
    private static final int VALIDATOR_TYPE_INDEX = 1;

    private static void putPrimitiveSubtypes(Map<Class<?>, Set<Class<?>>> subtypesByPrimitive, Class<?> primitiveType, Class<?> ... directSubtypes) {
        HashSet subtypes = new HashSet();
        for (Class<?> directSubtype : directSubtypes) {
            subtypes.add(directSubtype);
            subtypes.addAll((Collection)subtypesByPrimitive.get(directSubtype));
        }
        subtypesByPrimitive.put(primitiveType, subtypes);
    }

    private static Type getArrayType(Type componentType) {
        if (componentType instanceof Class) {
            return TypeUtils.getClassArrayType((Class)componentType);
        }
        return TypeUtils.getGenericArrayType(componentType);
    }

    private static Type getGenericArrayType(final Type componentType) {
        return new GenericArrayType(){

            public Type getGenericComponentType() {
                return componentType;
            }

            public int hashCode() {
                return componentType.hashCode();
            }

            public boolean equals(Object object) {
                return object instanceof GenericArrayType && componentType.equals(((GenericArrayType)object).getGenericComponentType());
            }
        };
    }

    private static Class<?> getClassArrayType(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    private static Type getComponentType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.isArray() ? clazz.getComponentType() : null;
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        return null;
    }

    public static <A extends Annotation> Map<Type, Class<? extends ConstraintValidator<A, ?>>> getValidatorsTypes(Class<? extends ConstraintValidator<A, ?>>[] validators) {
        HashMap validatorsTypes = new HashMap();
        for (Class<? extends ConstraintValidator<A, ?>> validator : validators) {
            validatorsTypes.put(TypeUtils.getValidatorType(validator), validator);
        }
        return validatorsTypes;
    }

    private static Type getValidatorType(Class<? extends ConstraintValidator<?, ?>> validator) {
        HashMap<Type, Type> resolvedTypes = new HashMap<Type, Type>();
        Type constraintValidatorType = TypeUtils.resolveTypes(resolvedTypes, validator);
        Type validatorType = ((ParameterizedType)constraintValidatorType).getActualTypeArguments()[1];
        if (validatorType == null) {
            throw new ValidationException("null is an invalid type for a ConstraintValidator");
        }
        if (validatorType instanceof GenericArrayType) {
            validatorType = TypeUtils.getArrayType(TypeUtils.getComponentType(validatorType));
        }
        while (resolvedTypes.containsKey(validatorType)) {
            validatorType = (Type)resolvedTypes.get(validatorType);
        }
        return validatorType;
    }

    private static Type resolveTypes(Map<Type, Type> resolvedTypes, Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            Type returnedType = TypeUtils.resolveTypeForHierarchy(resolvedTypes, clazz);
            if (returnedType != null) {
                return returnedType;
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            if (!(paramType.getRawType() instanceof Class)) {
                return null;
            }
            Class rawType = (Class)paramType.getRawType();
            TypeVariable<Class<T>>[] originalTypes = rawType.getTypeParameters();
            Type[] partiallyResolvedTypes = paramType.getActualTypeArguments();
            int nbrOfParams = originalTypes.length;
            for (int i = 0; i < nbrOfParams; ++i) {
                resolvedTypes.put(originalTypes[i], partiallyResolvedTypes[i]);
            }
            if (rawType.equals(ConstraintValidator.class)) {
                return type;
            }
            Type returnedType = TypeUtils.resolveTypeForHierarchy(resolvedTypes, rawType);
            if (returnedType != null) {
                return returnedType;
            }
        }
        return null;
    }

    private static Type resolveTypeForHierarchy(Map<Type, Type> resolvedTypes, Class<?> clazz) {
        Type returnedType = TypeUtils.resolveTypes(resolvedTypes, clazz.getGenericSuperclass());
        if (returnedType != null) {
            return returnedType;
        }
        for (Type genericInterface : clazz.getGenericInterfaces()) {
            returnedType = TypeUtils.resolveTypes(resolvedTypes, genericInterface);
            if (returnedType == null) continue;
            return returnedType;
        }
        return null;
    }

    public static boolean isAssignable(Type supertype, Type type) {
        if (supertype.equals(type)) {
            return true;
        }
        if (supertype instanceof Class) {
            if (type instanceof Class) {
                return TypeUtils.isClassAssignable((Class)supertype, (Class)type);
            }
            if (type instanceof ParameterizedType) {
                return TypeUtils.isAssignable(supertype, ((ParameterizedType)type).getRawType());
            }
            if (type instanceof TypeVariable) {
                return TypeUtils.isTypeVariableAssignable(supertype, (TypeVariable)type);
            }
            if (type instanceof GenericArrayType) {
                if (((Class)supertype).isArray()) {
                    return TypeUtils.isAssignable(TypeUtils.getComponentType(supertype), TypeUtils.getComponentType(type));
                }
                return TypeUtils.isArraySupertype((Class)supertype);
            }
            return false;
        }
        if (supertype instanceof ParameterizedType) {
            if (type instanceof Class) {
                return TypeUtils.isSuperAssignable(supertype, type);
            }
            return type instanceof ParameterizedType && TypeUtils.isParameterizedTypeAssignable((ParameterizedType)supertype, (ParameterizedType)type);
        }
        if (type instanceof TypeVariable) {
            return TypeUtils.isTypeVariableAssignable(supertype, (TypeVariable)type);
        }
        if (supertype instanceof GenericArrayType) {
            return TypeUtils.isArray(type) && TypeUtils.isAssignable(TypeUtils.getComponentType(supertype), TypeUtils.getComponentType(type));
        }
        return supertype instanceof WildcardType && TypeUtils.isWildcardTypeAssignable((WildcardType)supertype, type);
    }

    private static boolean isClassAssignable(Class<?> supertype, Class<?> type) {
        if (supertype.isPrimitive() && type.isPrimitive()) {
            return SUBTYPES_BY_PRIMITIVE.get(supertype).contains(type);
        }
        return supertype.isAssignableFrom(type);
    }

    private static boolean isParameterizedTypeAssignable(ParameterizedType supertype, ParameterizedType type) {
        Type[] typeArgs;
        Type rawType;
        Type rawSupertype = supertype.getRawType();
        if (!rawSupertype.equals(rawType = type.getRawType())) {
            return (!(rawSupertype instanceof Class) || !(rawType instanceof Class) || ((Class)rawSupertype).isAssignableFrom((Class)rawType)) && TypeUtils.isSuperAssignable(supertype, type);
        }
        Type[] supertypeArgs = supertype.getActualTypeArguments();
        if (supertypeArgs.length != (typeArgs = type.getActualTypeArguments()).length) {
            return false;
        }
        for (int i = 0; i < supertypeArgs.length; ++i) {
            Type supertypeArg = supertypeArgs[i];
            Type typeArg = typeArgs[i];
            if (!(supertypeArg instanceof WildcardType ? !TypeUtils.isWildcardTypeAssignable((WildcardType)supertypeArg, typeArg) : !supertypeArg.equals(typeArg))) continue;
            return false;
        }
        return true;
    }

    private static boolean isTypeVariableAssignable(Type supertype, TypeVariable<?> type) {
        for (Type bound : type.getBounds()) {
            if (!TypeUtils.isAssignable(supertype, bound)) continue;
            return true;
        }
        return false;
    }

    private static boolean isWildcardTypeAssignable(WildcardType supertype, Type type) {
        for (Type upperBound : supertype.getUpperBounds()) {
            if (TypeUtils.isAssignable(upperBound, type)) continue;
            return false;
        }
        for (Type lowerBound : supertype.getLowerBounds()) {
            if (TypeUtils.isAssignable(type, lowerBound)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSuperAssignable(Type supertype, Type type) {
        Type superclass = TypeUtils.getResolvedSuperclass(type);
        if (superclass != null && TypeUtils.isAssignable(supertype, superclass)) {
            return true;
        }
        for (Type interphace : TypeUtils.getResolvedInterfaces(type)) {
            if (!TypeUtils.isAssignable(supertype, interphace)) continue;
            return true;
        }
        return false;
    }

    private static boolean isArraySupertype(Class<?> type) {
        return Object.class.equals(type) || Cloneable.class.equals(type) || Serializable.class.equals(type);
    }

    private static Type getResolvedSuperclass(Type type) {
        Class<?> rawType = TypeUtils.getErasedReferenceType(type);
        Type supertype = rawType.getGenericSuperclass();
        if (supertype == null) {
            return null;
        }
        return TypeUtils.resolveTypeVariables(supertype, type);
    }

    private static Class<?> getErasedReferenceType(Type type) {
        return (Class)TypeUtils.getErasedType(type);
    }

    private static Type getErasedType(Type type) {
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            return TypeUtils.getErasedType(rawType);
        }
        if (TypeUtils.isArray(type)) {
            Type componentType = TypeUtils.getComponentType(type);
            Type erasedComponentType = TypeUtils.getErasedType(componentType);
            return TypeUtils.getArrayType(erasedComponentType);
        }
        if (type instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)type).getBounds();
            return TypeUtils.getErasedType(bounds[0]);
        }
        return type;
    }

    private static boolean isArray(Type type) {
        return type instanceof Class && ((Class)type).isArray() || type instanceof GenericArrayType;
    }

    private static Type[] getResolvedInterfaces(Type type) {
        Class<?> rawType = TypeUtils.getErasedReferenceType(type);
        Type[] interfaces = rawType.getGenericInterfaces();
        Type[] resolvedInterfaces = new Type[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            resolvedInterfaces[i] = TypeUtils.resolveTypeVariables(interfaces[i], type);
        }
        return resolvedInterfaces;
    }

    private static Type resolveTypeVariables(Type type, Type subtype) {
        if (!(type instanceof ParameterizedType)) {
            return type;
        }
        Map<Type, Type> actualTypeArgumentsByParameter = TypeUtils.getActualTypeArgumentsByParameter(type, subtype);
        Class<?> rawType = TypeUtils.getErasedReferenceType(type);
        return TypeUtils.parameterizeClass(rawType, actualTypeArgumentsByParameter);
    }

    private static Map<Type, Type> getActualTypeArgumentsByParameter(Type ... types) {
        LinkedHashMap<Type, Type> actualTypeArgumentsByParameter = new LinkedHashMap<Type, Type>();
        for (Type type : types) {
            actualTypeArgumentsByParameter.putAll(TypeUtils.getActualTypeArgumentsByParameterInternal(type));
        }
        return TypeUtils.normalize(actualTypeArgumentsByParameter);
    }

    private static <K> Map<K, K> normalize(Map<K, K> map) {
        for (Map.Entry<K, K> entry : map.entrySet()) {
            K key = entry.getKey();
            K value = entry.getValue();
            while (map.containsKey(value)) {
                value = map.get(value);
            }
            map.put(key, value);
        }
        return map;
    }

    private static Map<Type, Type> getActualTypeArgumentsByParameterInternal(Type type) {
        Type[] typeArguments;
        if (!(type instanceof ParameterizedType)) {
            return Collections.emptyMap();
        }
        TypeVariable<Class<?>>[] typeParameters = TypeUtils.getErasedReferenceType(type).getTypeParameters();
        if (typeParameters.length != (typeArguments = ((ParameterizedType)type).getActualTypeArguments()).length) {
            throw new MalformedParameterizedTypeException();
        }
        LinkedHashMap<Type, Type> actualTypeArgumentsByParameter = new LinkedHashMap<Type, Type>();
        for (int i = 0; i < typeParameters.length; ++i) {
            actualTypeArgumentsByParameter.put(typeParameters[i], typeArguments[i]);
        }
        return actualTypeArgumentsByParameter;
    }

    private static ParameterizedType parameterizeClass(Class<?> type, Map<Type, Type> actualTypeArgumentsByParameter) {
        return TypeUtils.parameterizeClassCapture(type, actualTypeArgumentsByParameter);
    }

    private static <T> ParameterizedType parameterizeClassCapture(Class<T> type, Map<Type, Type> actualTypeArgumentsByParameter) {
        TypeVariable<Class<T>>[] typeParameters = type.getTypeParameters();
        Type[] actualTypeArguments = new Type[typeParameters.length];
        for (int i = 0; i < typeParameters.length; ++i) {
            TypeVariable<Class<T>> typeParameter = typeParameters[i];
            Type actualTypeArgument = actualTypeArgumentsByParameter.get(typeParameter);
            if (actualTypeArgument == null) {
                throw new IllegalArgumentException("Missing actual type argument for type parameter: " + typeParameter);
            }
            actualTypeArguments[i] = actualTypeArgument;
        }
        return TypeUtils.parameterizedType(TypeUtils.getErasedReferenceType(type), actualTypeArguments);
    }

    private static ParameterizedType parameterizedType(final Class<?> rawType, final Type ... actualTypeArguments) {
        return new ParameterizedType(){

            public Type getOwnerType() {
                return null;
            }

            public Type getRawType() {
                return rawType;
            }

            public Type[] getActualTypeArguments() {
                return (Type[])actualTypeArguments.clone();
            }
        };
    }

    static {
        HashMap subtypesByPrimitive = new HashMap();
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Void.TYPE, new Class[0]);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Boolean.TYPE, new Class[0]);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Byte.TYPE, new Class[0]);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Character.TYPE, new Class[0]);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Short.TYPE, Byte.TYPE);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Integer.TYPE, Character.TYPE, Short.TYPE);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Long.TYPE, Integer.TYPE);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Float.TYPE, Long.TYPE);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Double.TYPE, Float.TYPE);
        SUBTYPES_BY_PRIMITIVE = subtypesByPrimitive;
    }
}

