/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarFile;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.ClientInfo;
import org.apache.openejb.assembler.classic.ConnectorInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.InterceptorInfo;
import org.apache.openejb.assembler.classic.PersistenceUnitInfo;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.cli.SystemExitException;
import org.apache.openejb.config.AppValidator;
import org.apache.openejb.config.Undeploy;
import org.apache.openejb.config.ValidationFailedException;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.JarExtractor;
import org.apache.openejb.util.Messages;
import org.apache.openejb.util.OpenEjbVersion;

public class Deploy {
    private static Messages messages = new Messages(Deploy.class);
    private static final String defaultServerUrl = "ejbd://localhost:4201";
    private static final int BUF_SIZE = 8192;

    public static void main(String[] args) throws SystemExitException {
        File apps;
        CommandLine line;
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption(Deploy.option("v", "version", "cmd.deploy.opt.version"));
        options.addOption(Deploy.option("h", "help", "cmd.deploy.opt.help"));
        options.addOption(Deploy.option("o", "offline", "cmd.deploy.opt.offline"));
        options.addOption(Deploy.option("s", "server-url", "url", "cmd.deploy.opt.server"));
        options.addOption(Deploy.option("d", "debug", "cmd.deploy.opt.debug"));
        options.addOption(Deploy.option("q", "quiet", "cmd.deploy.opt.quiet"));
        options.addOption(Deploy.option("u", "undeploy", "cmd.deploy.opt.undeploy"));
        options.addOption(Deploy.option(null, "dir", "cmd.deploy.opt.dir"));
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException exp) {
            Deploy.help(options);
            throw new SystemExitException(-1);
        }
        if (line.hasOption("help")) {
            Deploy.help(options);
            return;
        }
        if (line.hasOption("version")) {
            OpenEjbVersion.get().print(System.out);
            return;
        }
        if (line.getArgList().size() == 0) {
            System.out.println("Must specify an archive to deploy.");
            Deploy.help(options);
            return;
        }
        List modules = line.getArgList();
        for (Object module : modules) {
            String path = (String)module;
            File file = new File(path);
            try {
                Deploy.checkSource(file);
            }
            catch (DeploymentTerminatedException e) {
                System.out.println(e.getMessage());
                throw new SystemExitException(-100);
            }
        }
        boolean offline = line.hasOption("offline");
        try {
            String dir = line.getOptionValue("dir", "apps");
            apps = SystemInstance.get().getBase().getDirectory(dir);
        }
        catch (IOException e) {
            throw new SystemExitException(-1);
        }
        if (!apps.exists()) {
            System.out.println("Directory does not exist: " + apps.getAbsolutePath());
        }
        Deployer deployer = null;
        if (!offline) {
            Properties p = new Properties();
            p.put("java.naming.factory.initial", "org.apache.openejb.client.RemoteInitialContextFactory");
            String serverUrl = line.getOptionValue("server-url", defaultServerUrl);
            p.put("java.naming.provider.url", serverUrl);
            try {
                InitialContext ctx = new InitialContext(p);
                deployer = (Deployer)ctx.lookup("openejb/DeployerBusinessRemote");
            }
            catch (ServiceUnavailableException e) {
                System.out.println(e.getCause().getMessage());
                System.out.println(messages.format("cmd.deploy.serverOffline"));
                throw new SystemExitException(-1);
            }
            catch (NamingException e) {
                System.out.println("openejb/DeployerBusinessRemote does not exist in server '" + serverUrl + "', check the server logs to ensure it exists and has not been removed.");
                throw new SystemExitException(-2);
            }
        }
        boolean undeploy = line.hasOption("undeploy");
        int exitCode = 0;
        for (Object obj : line.getArgList()) {
            String path = (String)obj;
            File file = new File(path);
            File destFile = new File(apps, file.getName());
            try {
                String location;
                if (Deploy.shouldUnpack(file)) {
                    File unpacked = Deploy.unpackedLocation(file, apps);
                    if (undeploy) {
                        Deploy.undeploy(offline, unpacked, path, deployer);
                    }
                    destFile = Deploy.unpack(file, unpacked);
                } else {
                    if (undeploy) {
                        Deploy.undeploy(offline, destFile, path, deployer);
                    }
                    Deploy.checkDest(destFile, file);
                    Deploy.copyFile(file, destFile);
                }
                if (offline) {
                    System.out.println(messages.format("cmd.deploy.offline", path, apps.getAbsolutePath()));
                    continue;
                }
                try {
                    location = destFile.getCanonicalPath();
                }
                catch (IOException e) {
                    throw new OpenEJBException(messages.format("cmd.deploy.fileNotFound", path));
                }
                AppInfo appInfo = deployer.deploy(location);
                System.out.println(messages.format("cmd.deploy.successful", path, appInfo.path));
                if (line.hasOption("quiet")) continue;
                Deploy.print(appInfo);
            }
            catch (UndeployException e) {
                System.out.println(messages.format("cmd.undeploy.failed", path));
                e.printStackTrace(System.out);
                ++exitCode;
            }
            catch (DeploymentTerminatedException e) {
                System.out.println(e.getMessage());
                ++exitCode;
            }
            catch (ValidationFailedException e) {
                System.out.println(messages.format("cmd.deploy.validationFailed", path));
                int level = 2;
                if (line.hasOption("debug")) {
                    level = 3;
                }
                AppValidator appValidator = new AppValidator(level, false, true, false);
                appValidator.printResults(e);
                ++exitCode;
                if (JarExtractor.delete(destFile)) continue;
                System.out.println(messages.format("cmd.deploy.cantDelete.deploy", destFile.getAbsolutePath()));
            }
            catch (Throwable e) {
                System.out.println(messages.format("cmd.deploy.failed", path));
                e.printStackTrace(System.out);
                ++exitCode;
                if (JarExtractor.delete(destFile)) continue;
                System.out.println(messages.format("cmd.deploy.cantDelete.deploy", destFile.getAbsolutePath()));
            }
        }
        if (exitCode != 0) {
            throw new SystemExitException(exitCode);
        }
    }

    private static void undeploy(boolean offline, File dest, String path, Deployer deployer) throws UndeployException, DeploymentTerminatedException {
        if (offline) {
            if (dest.exists() && !JarExtractor.delete(dest)) {
                throw new DeploymentTerminatedException(messages.format("cmd.deploy.cantDelete.undeploy", dest.getAbsolutePath()));
            }
        } else {
            try {
                Undeploy.undeploy(path, dest, deployer);
            }
            catch (NoSuchApplicationException nothingToUndeploy) {
                // empty catch block
            }
        }
    }

    private static void print(AppInfo appInfo) {
        System.out.println("App(id=" + appInfo.path + ")");
        for (EjbJarInfo info : appInfo.ejbJars) {
            System.out.println("    EjbJar(id=" + info.moduleName + ", path=" + info.path + ")");
            for (EnterpriseBeanInfo beanInfo : info.enterpriseBeans) {
                System.out.println("        Ejb(ejb-name=" + beanInfo.ejbName + ", id=" + beanInfo.ejbDeploymentId + ")");
                for (String name : beanInfo.jndiNames) {
                    System.out.println("            Jndi(name=" + name + ")");
                }
                System.out.println("");
            }
            for (InterceptorInfo interceptorInfo : info.interceptors) {
                System.out.println("        Interceptor(class=" + interceptorInfo.clazz + ")");
            }
            System.out.println("");
        }
        for (ClientInfo clientInfo : appInfo.clients) {
            System.out.println("    Client(main-class=" + clientInfo.mainClass + ", id=" + clientInfo.moduleId + ", path=" + clientInfo.path + ")");
            System.out.println("");
        }
        for (ConnectorInfo connectorInfo : appInfo.connectors) {
            System.out.println("    Connector(id=" + connectorInfo.moduleId + ", path=" + connectorInfo.path + ")");
            System.out.println("");
        }
        for (WebAppInfo webAppInfo : appInfo.webApps) {
            System.out.println("    WebApp(context-root=" + webAppInfo.contextRoot + ", id=" + webAppInfo.moduleId + ", path=" + webAppInfo.path + ")");
            System.out.println("");
        }
        for (PersistenceUnitInfo persistenceUnitInfo : appInfo.persistenceUnits) {
            System.out.println("    PersistenceUnit(name=" + persistenceUnitInfo.name + ", provider=" + persistenceUnitInfo.provider + ")");
            System.out.println("");
        }
    }

    private static void checkSource(File file) throws DeploymentTerminatedException {
        if (!file.exists()) {
            throw new DeploymentTerminatedException(messages.format("cmd.deploy.fileNotFound", file.getAbsolutePath()));
        }
    }

    private static void checkDest(File destFile, File file) throws DeploymentTerminatedException {
        if (destFile.exists()) {
            throw new DeploymentTerminatedException(messages.format("cmd.deploy.destExists", file.getAbsolutePath(), destFile.getAbsolutePath()));
        }
    }

    private static void copyFile(File file, File destFile) throws DeploymentTerminatedException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(file);
            out = new FileOutputStream(destFile);
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                ((OutputStream)out).write(buffer, 0, count);
            } while ((count = ((InputStream)in).read(buffer, 0, buffer.length)) != -1);
        }
        catch (Exception e) {
            try {
                throw new DeploymentTerminatedException(messages.format("cmd.deploy.cantCopy", file.getAbsolutePath(), destFile.getAbsolutePath()));
            }
            catch (Throwable throwable) {
                Deploy.close(in);
                Deploy.close(out);
                throw throwable;
            }
        }
        Deploy.close(in);
        Deploy.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean shouldUnpack(File file) {
        String name = file.getName();
        if (name.endsWith(".ear") || name.endsWith(".rar") || name.endsWith(".rar")) {
            return true;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            if (jarFile.getEntry("META-INF/application.xml") != null) {
                boolean bl = true;
                return bl;
            }
            if (jarFile.getEntry("META-INF/ra.xml") != null) {
                boolean bl = true;
                return bl;
            }
            if (jarFile.getEntry("WEB-INF/web.xml") != null) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ignored) {}
            }
        }
        return false;
    }

    private static File unpack(File jarFile, File destinationDir) throws OpenEJBException, DeploymentTerminatedException {
        try {
            Deploy.checkDest(destinationDir, jarFile);
            JarExtractor.extract(jarFile, destinationDir);
            return destinationDir;
        }
        catch (IOException e) {
            throw new OpenEJBException("Unable to extract jar. " + e.getMessage(), e);
        }
    }

    private static File unpackedLocation(File jarFile, File destDir) {
        if (jarFile.isDirectory()) {
            return jarFile;
        }
        String name = jarFile.getName();
        name = name.endsWith(".jar") || name.endsWith(".ear") || name.endsWith(".zip") || name.endsWith(".war") || name.endsWith(".rar") ? name.replaceFirst("....$", "") : name + ".unpacked";
        File destinationDir = new File(destDir, name);
        return destinationDir;
    }

    private static void close(Closeable in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("deploy [options] <file> [<file>...]", "\n" + Deploy.i18n("cmd.deploy.description"), options, "\n");
    }

    private static Option option(String shortOpt, String longOpt, String description) {
        OptionBuilder.withLongOpt((String)longOpt);
        OptionBuilder.withDescription((String)Deploy.i18n(description));
        return OptionBuilder.create((String)shortOpt);
    }

    private static Option option(String shortOpt, String longOpt, String argName, String description) {
        OptionBuilder.withLongOpt((String)longOpt);
        OptionBuilder.withArgName((String)argName);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)Deploy.i18n(description));
        return OptionBuilder.create((String)shortOpt);
    }

    private static String i18n(String key) {
        return messages.format(key);
    }

    public static class DeploymentTerminatedException
    extends Exception {
        public DeploymentTerminatedException(String message) {
            super(message);
        }

        public DeploymentTerminatedException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

