/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.Nonbinding;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.interceptor.InterceptorBinding;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.inject.DefinitionException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ArrayUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationManager {
    private final BeanManagerImpl beanManagerImpl;
    private final WebBeansContext webBeansContext;

    public AnnotationManager(WebBeansContext context) {
        this.webBeansContext = context;
        this.beanManagerImpl = context.getBeanManagerImpl();
    }

    public boolean isInterceptorBindingAnnotation(Class<? extends Annotation> clazz) {
        Asserts.nullCheckForClass(clazz);
        return clazz.isAnnotationPresent(InterceptorBinding.class) || this.beanManagerImpl.hasInterceptorBindingType(clazz);
    }

    public boolean hasInterceptorBindingMetaAnnotation(Annotation[] anns) {
        Asserts.assertNotNull(anns, "anns parameter can not be null");
        for (Annotation ann : anns) {
            if (!this.isInterceptorBindingAnnotation(ann.annotationType())) continue;
            return true;
        }
        return false;
    }

    public Annotation[] getInterceptorBindingMetaAnnotations(Annotation[] anns) {
        Asserts.assertNotNull(anns, "anns parameter can not be null");
        ArrayList<Annotation> interAnns = new ArrayList<Annotation>();
        for (Annotation ann : anns) {
            Annotation[] transitives;
            if (!this.isInterceptorBindingAnnotation(ann.annotationType())) continue;
            interAnns.add(ann);
            for (Annotation transitive : transitives = this.getTransitiveInterceptorBindings(ann.annotationType().getDeclaredAnnotations())) {
                interAnns.add(transitive);
            }
        }
        Annotation[] ret = new Annotation[interAnns.size()];
        ret = interAnns.toArray(ret);
        return ret;
    }

    private Annotation[] getTransitiveInterceptorBindings(Annotation[] anns) {
        return this.getInterceptorBindingMetaAnnotations(anns);
    }

    public boolean isQualifierAnnotation(Class<? extends Annotation> clazz) {
        Asserts.nullCheckForClass(clazz);
        if (clazz.isAnnotationPresent(Qualifier.class)) {
            return true;
        }
        return this.beanManagerImpl.getAdditionalQualifiers().contains(clazz);
    }

    public <X> Annotation[] getAnnotatedMethodFirstParameterQualifierWithGivenAnnotation(AnnotatedMethod<X> annotatedMethod, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod argument can not be null");
        Asserts.nullCheckForClass(clazz);
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        List parameters = annotatedMethod.getParameters();
        for (AnnotatedParameter parameter : parameters) {
            Annotation[] anns;
            if (!parameter.isAnnotationPresent(clazz)) continue;
            for (Annotation ann : anns = AnnotationUtil.getAnnotationsFromSet(parameter.getAnnotations())) {
                if (!this.isQualifierAnnotation(ann.annotationType())) continue;
                list.add(ann);
            }
        }
        Annotation[] finalAnns = new Annotation[list.size()];
        finalAnns = list.toArray(finalAnns);
        return finalAnns;
    }

    public Annotation[] getMethodFirstParameterQualifierWithGivenAnnotation(Method method, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(method, "Method argument can not be null");
        Asserts.nullCheckForClass(clazz);
        Annotation[][] parameterAnns = method.getParameterAnnotations();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        for (Annotation[] parameters : parameterAnns) {
            boolean found = false;
            for (Annotation param : parameters) {
                Class<? extends Annotation> btype = param.annotationType();
                if (btype.equals(clazz)) {
                    found = true;
                    continue;
                }
                if (!this.isQualifierAnnotation(btype)) continue;
                list.add(param);
            }
            if (!found) continue;
            Annotation[] result = new Annotation[list.size()];
            result = list.toArray(result);
            return result;
        }
        Annotation[] result = new Annotation[]{};
        return result;
    }

    public Annotation[] getQualifierAnnotations(Annotation ... annotations) {
        Asserts.assertNotNull(annotations, "Annotations argument can not be null");
        HashSet<Object> set = new HashSet<Object>();
        for (Annotation annot : annotations) {
            if (!this.isQualifierAnnotation(annot.annotationType())) continue;
            set.add(annot);
        }
        if (set.size() == 0) {
            set.add((Object)new DefaultLiteral());
        }
        Annotation[] a = new Annotation[set.size()];
        a = set.toArray(a);
        return a;
    }

    public Annotation[] getRealizesGenericAnnotations(Class<?> clazz, Annotation[] anns) {
        Annotation[] genericReliazesAnns;
        HashSet<Annotation> setAnnots = new HashSet<Annotation>();
        for (Annotation definedAnn : anns) {
            setAnnots.add(definedAnn);
        }
        for (Annotation generic : genericReliazesAnns = this.getQualifierAnnotations(clazz.getSuperclass().getDeclaredAnnotations())) {
            setAnnots.remove(generic);
        }
        for (Annotation generic : genericReliazesAnns = this.getQualifierAnnotations(clazz.getDeclaredAnnotations())) {
            setAnnots.add(generic);
        }
        Annotation[] annots = new Annotation[setAnnots.size()];
        annots = setAnnots.toArray(annots);
        return annots;
    }

    public void checkQualifierConditions(Annotation ... qualifierAnnots) {
        Set<Annotation> annSet = ArrayUtil.asSet(qualifierAnnots);
        if (qualifierAnnots.length != annSet.size()) {
            throw new IllegalArgumentException("Qualifier annotations can not contain duplicate qualifiers:" + Arrays.toString(qualifierAnnots));
        }
        this.checkQualifierConditions(annSet);
    }

    public void checkQualifierConditions(Set<Annotation> qualifierAnnots) {
        for (Annotation ann : qualifierAnnots) {
            this.checkQualifierConditions(ann);
        }
    }

    private void checkQualifierConditions(Annotation ann) {
        Method[] methods;
        for (Method method : methods = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethods(ann.annotationType())) {
            Class<?> clazz = method.getReturnType();
            if (!clazz.isArray() && !clazz.isAnnotation() || AnnotationUtil.hasAnnotation(method.getDeclaredAnnotations(), Nonbinding.class)) continue;
            throw new WebBeansConfigurationException("@Qualifier : " + ann.annotationType().getName() + " must have @NonBinding valued members for its array-valued and annotation valued members");
        }
        if (!this.isQualifierAnnotation(ann.annotationType())) {
            throw new IllegalArgumentException("Qualifier annotations must be annotated with @Qualifier");
        }
    }

    public boolean isStereoTypeAnnotation(Class<? extends Annotation> clazz) {
        Asserts.nullCheckForClass(clazz);
        return clazz.isAnnotationPresent(Stereotype.class);
    }

    public boolean hasStereoTypeMetaAnnotation(Annotation[] anns) {
        Asserts.assertNotNull(anns, "anns parameter can not be null");
        for (Annotation ann : anns) {
            if (!this.isStereoTypeAnnotation(ann.annotationType())) continue;
            return true;
        }
        return false;
    }

    public Annotation[] getStereotypeMetaAnnotations(Annotation[] anns) {
        Asserts.assertNotNull(anns, "anns parameter can not be null");
        ArrayList<Annotation> interAnns = new ArrayList<Annotation>();
        for (Annotation ann : anns) {
            Annotation[] transitives;
            if (!this.isStereoTypeAnnotation(ann.annotationType())) continue;
            interAnns.add(ann);
            for (Annotation transitive : transitives = this.getTransitiveStereoTypes(ann.annotationType().getDeclaredAnnotations())) {
                interAnns.add(transitive);
            }
        }
        Annotation[] ret = new Annotation[interAnns.size()];
        ret = interAnns.toArray(ret);
        return ret;
    }

    private Annotation[] getTransitiveStereoTypes(Annotation[] anns) {
        return this.getStereotypeMetaAnnotations(anns);
    }

    public boolean isComponentHasStereoType(OwbBean<?> component) {
        Asserts.assertNotNull(component, "component parameter can not be null");
        Set<Annotation> set = component.getOwbStereotypes();
        Annotation[] anns = new Annotation[set.size()];
        anns = set.toArray(anns);
        return this.hasStereoTypeMetaAnnotation(anns);
    }

    public Annotation[] getComponentStereoTypes(OwbBean<?> bean) {
        Asserts.assertNotNull(bean, "bean parameter can not be null");
        if (this.isComponentHasStereoType(bean)) {
            Set<Annotation> set = bean.getOwbStereotypes();
            Annotation[] anns = new Annotation[set.size()];
            anns = set.toArray(anns);
            return this.getStereotypeMetaAnnotations(anns);
        }
        return new Annotation[0];
    }

    public boolean hasNamedOnStereoTypes(OwbBean<?> bean) {
        Annotation[] types;
        for (Annotation ann : types = this.getComponentStereoTypes(bean)) {
            if (!AnnotationUtil.hasClassAnnotation(ann.annotationType(), Named.class)) continue;
            return true;
        }
        return false;
    }

    public void checkStereoTypeClass(Class<? extends Annotation> clazz) {
        this.checkStereoTypeClass(clazz, clazz.getDeclaredAnnotations());
    }

    public void checkStereoTypeClass(Class<? extends Annotation> clazz, Annotation ... annotations) {
        Asserts.nullCheckForClass(clazz);
        boolean scopeTypeFound = false;
        for (Annotation annotation : annotations) {
            Target target;
            ElementType[] type;
            Class<? extends Annotation> annotType = annotation.annotationType();
            if (annotType.isAnnotationPresent(NormalScope.class) || annotType.isAnnotationPresent(Scope.class)) {
                if (scopeTypeFound) {
                    throw new WebBeansConfigurationException("@StereoType annotation can not contain more than one @Scope/@NormalScope annotation");
                }
                scopeTypeFound = true;
                continue;
            }
            if (annotType.equals(Named.class)) {
                Named name = (Named)annotation;
                if (name.value().equals("")) continue;
                throw new WebBeansConfigurationException("@StereoType annotation can not define @Named annotation with value");
            }
            if (!this.isInterceptorBindingAnnotation(annotType) || (type = (target = clazz.getAnnotation(Target.class)).value()).length == 1 || type[0].equals((Object)ElementType.TYPE)) continue;
            throw new WebBeansConfigurationException("Stereotype with @InterceptorBinding must be defined as @Target{TYPE}");
        }
    }

    public void checkInterceptorResolverParams(Annotation ... interceptorBindings) {
        if (interceptorBindings == null || interceptorBindings.length == 0) {
            throw new IllegalArgumentException("Manager.resolveInterceptors() method parameter interceptor bindings array argument can not be empty");
        }
        Annotation old = null;
        for (Annotation interceptorBinding : interceptorBindings) {
            if (!this.isInterceptorBindingAnnotation(interceptorBinding.annotationType())) {
                throw new IllegalArgumentException("Manager.resolveInterceptors() method parameter interceptor bindings array can not contain other annotation that is not @InterceptorBinding");
            }
            if (old == null) {
                old = interceptorBinding;
                continue;
            }
            if (((Object)old).equals(interceptorBinding)) {
                throw new IllegalArgumentException("Manager.resolveInterceptors() method parameter interceptor bindings array argument can not define duplicate binding annotation with name : @" + old.getClass().getName());
            }
            old = interceptorBinding;
        }
    }

    public void checkDecoratorResolverParams(Set<Type> apiTypes, Annotation ... qualifiers) {
        if (apiTypes == null || apiTypes.size() == 0) {
            throw new IllegalArgumentException("Manager.resolveDecorators() method parameter api types argument can not be empty");
        }
        Annotation old = null;
        for (Annotation qualifier : qualifiers) {
            if (!this.isQualifierAnnotation(qualifier.annotationType())) {
                throw new IllegalArgumentException("Manager.resolveDecorators() method parameter qualifiers array can not contain other annotation that is not @Qualifier");
            }
            if (old == null) {
                old = qualifier;
                continue;
            }
            if (old.annotationType().equals(qualifier.annotationType())) {
                throw new IllegalArgumentException("Manager.resolveDecorators() method parameter qualifiers array argument can not define duplicate qualifier annotation with name : @" + old.annotationType().getName());
            }
            old = qualifier;
        }
    }

    public Annotation[] checkForNewQualifierForDeployment(Type type, Class<?> clazz, String name, Annotation[] annotations) {
        Asserts.assertNotNull(type, "Type argument can not be null");
        Asserts.nullCheckForClass(clazz);
        Asserts.assertNotNull(annotations, "Annotations argument can not be null");
        Annotation[] as = this.getQualifierAnnotations(annotations);
        for (Annotation a : annotations) {
            if (!a.annotationType().equals(New.class) || as.length <= 1) continue;
            throw new WebBeansConfigurationException("@New binding annotation can not have any binding annotation in class : " + clazz.getName() + " in field/method : " + name);
        }
        return as;
    }

    public boolean configuredProducerSpecializedName(AbstractOwbBean<?> component, Method method, Method superMethod) {
        Asserts.assertNotNull(component, "component parameter can not be null");
        Asserts.assertNotNull(method, "method parameter can not be null");
        Asserts.assertNotNull(superMethod, "superMethod parameter can not be null");
        String name = null;
        boolean hasName = false;
        if (AnnotationUtil.hasMethodAnnotation(superMethod, Named.class)) {
            Named named = superMethod.getAnnotation(Named.class);
            hasName = true;
            name = !named.value().equals("") ? named.value() : WebBeansUtil.getProducerDefaultName(superMethod.getName());
        } else {
            Annotation[] anns;
            for (Annotation ann : anns = this.getStereotypeMetaAnnotations(superMethod.getAnnotations())) {
                if (!ann.annotationType().isAnnotationPresent(Stereotype.class)) continue;
                hasName = true;
                name = WebBeansUtil.getProducerDefaultName(superMethod.getName());
                break;
            }
        }
        if (hasName) {
            if (AnnotationUtil.hasMethodAnnotation(method, Named.class)) {
                throw new DefinitionException("Specialized method : " + method.getName() + " in class : " + component.getReturnType().getName() + " may not define @Named annotation");
            }
            component.setName(name);
        }
        return hasName;
    }

    public <X> Method getDisposalWithGivenAnnotatedMethod(AnnotatedType<X> annotatedType, Type beanType, Annotation[] qualifiers) {
        Set annotatedMethods = annotatedType.getMethods();
        if (annotatedMethods != null) {
            for (AnnotatedMethod annotatedMethod : annotatedMethods) {
                AnnotatedMethod annt = annotatedMethod;
                List parameters = annt.getParameters();
                if (parameters == null) continue;
                boolean found = false;
                for (AnnotatedParameter parameter : parameters) {
                    if (!parameter.isAnnotationPresent(Disposes.class)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                Type type = AnnotationUtil.getAnnotatedMethodFirstParameterWithAnnotation(annotatedMethod, Disposes.class);
                Annotation[] annots = this.getAnnotatedMethodFirstParameterQualifierWithGivenAnnotation(annotatedMethod, Disposes.class);
                if (!type.equals(beanType)) continue;
                for (Annotation qualifier : qualifiers) {
                    Annotation ann;
                    Annotation[] arr$;
                    int len$;
                    int i$;
                    if (qualifier.annotationType() == Default.class || (i$ = 0) >= (len$ = (arr$ = annots).length) || AnnotationUtil.isQualifierEqual(qualifier, ann = arr$[i$])) continue;
                    return null;
                }
                return annotatedMethod.getJavaMember();
            }
        }
        return null;
    }

    public void checkInjectionPointForInjectInjectionPoint(Class<?> clazz) {
        Field[] fields;
        Asserts.nullCheckForClass(clazz);
        for (Field field : fields = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredFields(clazz)) {
            Annotation[] anns;
            if (field.getAnnotation(Inject.class) == null || field.getType() != InjectionPoint.class || !AnnotationUtil.hasAnnotation(anns = this.getQualifierAnnotations(field.getDeclaredAnnotations()), Default.class)) continue;
            throw new WebBeansConfigurationException("Java EE Component class :  " + clazz + " can not inject InjectionPoint");
        }
    }

    public boolean checkInjectionPointForInterceptorPassivation(Class<?> clazz) {
        Field[] fields;
        Asserts.nullCheckForClass(clazz);
        for (Field field : fields = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredFields(clazz)) {
            Class<?> type;
            if (field.getAnnotation(Inject.class) == null || Serializable.class.isAssignableFrom(type = field.getType())) continue;
            return false;
        }
        return true;
    }
}

