/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.framework.internal;

import java.util.HashMap;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.eclipse.gemini.management.framework.CustomBundleWiringStateMBean;
import org.eclipse.gemini.management.framework.internal.OSGiBundleCapability;
import org.eclipse.gemini.management.framework.internal.OSGiBundleRequirement;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

public final class OSGiBundleRevision {
    private final BundleRevision bundleRevision;

    public OSGiBundleRevision(BundleRevision bundleRevision) {
        this.bundleRevision = bundleRevision;
    }

    public CompositeData[] capabilitiesAsCompositeDataArray(String namespace) {
        return this.getBundleCapabilityItems(namespace);
    }

    public CompositeData[] requirementsAsCompositeDataArray(String namespace) {
        return this.getBundleRequirementItems(namespace);
    }

    public CompositeData capabilitiesAsCompositeData(String namespace, int revisionCounter) {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Capabilities", this.getBundleCapabilityItems(namespace));
        items.put("BundleRevisionId", revisionCounter);
        try {
            return new CompositeDataSupport(CustomBundleWiringStateMBean.BUNDLE_REVISION_CAPABILITIES_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form bundle revision capabilities open data", e);
        }
    }

    public CompositeData requirementsAsCompositeData(String namespace, int revisionCounter) {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Requirements", this.getBundleRequirementItems(namespace));
        items.put("BundleRevisionId", revisionCounter);
        try {
            return new CompositeDataSupport(CustomBundleWiringStateMBean.BUNDLE_REVISION_REQUIREMENTS_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form bundle revision requirements open data", e);
        }
    }

    private CompositeData[] getBundleCapabilityItems(String namespace) {
        List declaredCapabilities = this.bundleRevision.getDeclaredCapabilities(namespace);
        CompositeData[] requirementsCompositeDatas = new CompositeData[declaredCapabilities.size()];
        int i = 0;
        while (i < declaredCapabilities.size()) {
            requirementsCompositeDatas[i] = new OSGiBundleCapability((BundleCapability)declaredCapabilities.get(i)).asCompositeData();
            ++i;
        }
        return requirementsCompositeDatas;
    }

    private CompositeData[] getBundleRequirementItems(String namespace) {
        List declaredRequirements = this.bundleRevision.getDeclaredRequirements(namespace);
        CompositeData[] requirementsCompositeDatas = new CompositeData[declaredRequirements.size()];
        int i = 0;
        while (i < declaredRequirements.size()) {
            requirementsCompositeDatas[i] = new OSGiBundleRequirement((BundleRequirement)declaredRequirements.get(i)).asCompositeData();
            ++i;
        }
        return requirementsCompositeDatas;
    }
}

