/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.mdb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.ContainerType;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.ExceptionType;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.mdb.EndpointFactory;
import org.apache.openejb.core.mdb.InboundRecovery;
import org.apache.openejb.core.mdb.Instance;
import org.apache.openejb.core.mdb.MdbInstanceFactory;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.transaction.EjbTransactionUtil;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.ManagedMBean;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.monitoring.StatsInterceptor;
import org.apache.openejb.resource.XAResourceWrapper;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

public class MdbContainer
implements RpcContainer {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private static final Object[] NO_ARGS = new Object[0];
    private final Object containerID;
    private final SecurityService securityService;
    private final ResourceAdapter resourceAdapter;
    private final Class messageListenerInterface;
    private final Class activationSpecClass;
    private final int instanceLimit;
    private final ConcurrentMap<Object, BeanContext> deployments = new ConcurrentHashMap<Object, BeanContext>();
    private final XAResourceWrapper xaResourceWrapper;
    private final InboundRecovery inboundRecovery;

    public MdbContainer(Object containerID, SecurityService securityService, ResourceAdapter resourceAdapter, Class messageListenerInterface, Class activationSpecClass, int instanceLimit) {
        this.containerID = containerID;
        this.securityService = securityService;
        this.resourceAdapter = resourceAdapter;
        this.messageListenerInterface = messageListenerInterface;
        this.activationSpecClass = activationSpecClass;
        this.instanceLimit = instanceLimit;
        this.xaResourceWrapper = (XAResourceWrapper)SystemInstance.get().getComponent(XAResourceWrapper.class);
        this.inboundRecovery = (InboundRecovery)SystemInstance.get().getComponent(InboundRecovery.class);
    }

    @Override
    public BeanContext[] getBeanContexts() {
        return this.deployments.values().toArray(new BeanContext[this.deployments.size()]);
    }

    @Override
    public BeanContext getBeanContext(Object deploymentID) {
        return (BeanContext)this.deployments.get(deploymentID);
    }

    @Override
    public ContainerType getContainerType() {
        return ContainerType.MESSAGE_DRIVEN;
    }

    @Override
    public Object getContainerID() {
        return this.containerID;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public Class getMessageListenerInterface() {
        return this.messageListenerInterface;
    }

    public Class getActivationSpecClass() {
        return this.activationSpecClass;
    }

    @Override
    public void deploy(BeanContext beanContext) throws OpenEJBException {
        Object deploymentId = beanContext.getDeploymentID();
        if (!beanContext.getMdbInterface().equals(this.messageListenerInterface)) {
            throw new OpenEJBException("Deployment '" + deploymentId + "' has message listener interface " + beanContext.getMdbInterface().getName() + " but this MDB container only supports " + this.messageListenerInterface);
        }
        ActivationSpec activationSpec = this.createActivationSpec(beanContext);
        if (this.inboundRecovery != null) {
            this.inboundRecovery.recover(this.resourceAdapter, activationSpec, this.containerID.toString());
        }
        Options options = new Options(beanContext.getProperties());
        int instanceLimit = options.get("InstanceLimit", this.instanceLimit);
        MdbInstanceFactory instanceFactory = new MdbInstanceFactory(beanContext, this.securityService, instanceLimit);
        EndpointFactory endpointFactory = new EndpointFactory(activationSpec, this, beanContext, instanceFactory, this.xaResourceWrapper);
        beanContext.setContainer(this);
        beanContext.setContainerData(endpointFactory);
        this.deployments.put(deploymentId, beanContext);
        if (StatsInterceptor.isStatsActivated()) {
            StatsInterceptor stats = new StatsInterceptor(beanContext.getBeanClass());
            beanContext.addFirstSystemInterceptor(stats);
            MBeanServer server = LocalMBeanServer.get();
            ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb.management");
            jmxName.set("J2EEServer", "openejb");
            jmxName.set("J2EEApplication", null);
            jmxName.set("EJBModule", beanContext.getModuleID());
            jmxName.set("StatelessSessionBean", beanContext.getEjbName());
            jmxName.set("j2eeType", "");
            jmxName.set("name", beanContext.getEjbName());
            try {
                ObjectName objectName = jmxName.set("j2eeType", "Invocations").build();
                if (server.isRegistered(objectName)) {
                    server.unregisterMBean(objectName);
                }
                server.registerMBean(new ManagedMBean(stats), objectName);
                endpointFactory.jmxNames.add(objectName);
            }
            catch (Exception e) {
                logger.error("Unable to register MBean ", e);
            }
        }
        try {
            this.resourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, activationSpec);
        }
        catch (ResourceException e) {
            beanContext.setContainer(null);
            beanContext.setContainerData(null);
            this.deployments.remove(deploymentId);
            throw new OpenEJBException(e);
        }
        EjbTimerService timerService = beanContext.getEjbTimerService();
        if (timerService != null) {
            timerService.start();
        }
    }

    private ActivationSpec createActivationSpec(BeanContext beanContext) throws OpenEJBException {
        try {
            ObjectRecipe objectRecipe = new ObjectRecipe(this.activationSpecClass);
            objectRecipe.allow(Option.IGNORE_MISSING_PROPERTIES);
            objectRecipe.disallow(Option.FIELD_INJECTION);
            Map<String, String> activationProperties = beanContext.getActivationProperties();
            for (Map.Entry<String, String> entry : activationProperties.entrySet()) {
                objectRecipe.setMethodProperty(entry.getKey(), (Object)entry.getValue());
            }
            objectRecipe.setMethodProperty("beanClass", (Object)beanContext.getBeanClass());
            ActivationSpec activationSpec = (ActivationSpec)objectRecipe.create(this.activationSpecClass.getClassLoader());
            TreeSet unusedProperties = new TreeSet(objectRecipe.getUnsetProperties().keySet());
            unusedProperties.remove("destination");
            unusedProperties.remove("destinationType");
            unusedProperties.remove("beanClass");
            if (!unusedProperties.isEmpty()) {
                throw new IllegalArgumentException("No setter found for the activation spec properties: " + unusedProperties);
            }
            try {
                activationSpec.validate();
            }
            catch (UnsupportedOperationException uoe) {
                logger.info("ActivationSpec does not support validate. Implementation of validate is optional");
            }
            try {
                Validator validator = (Validator)beanContext.getJndiContext().lookup("comp/Validator");
                Set generalSet = validator.validate((Object)activationSpec, new Class[0]);
                if (!generalSet.isEmpty()) {
                    throw new ConstraintViolationException("Constraint violation for ActivationSpec " + this.activationSpecClass.getName(), generalSet);
                }
            }
            catch (NamingException e) {
                logger.debug("No Validator bound to JNDI context");
            }
            activationSpec.setResourceAdapter(this.resourceAdapter);
            return activationSpec;
        }
        catch (Exception e) {
            throw new OpenEJBException("Unable to create activation spec", e);
        }
    }

    @Override
    public void start(BeanContext info) throws OpenEJBException {
    }

    @Override
    public void stop(BeanContext info) throws OpenEJBException {
        info.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy(BeanContext beanContext) throws OpenEJBException {
        if (!(beanContext instanceof BeanContext)) {
            return;
        }
        try {
            EndpointFactory endpointFactory = (EndpointFactory)beanContext.getContainerData();
            if (endpointFactory != null) {
                this.resourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, endpointFactory.getActivationSpec());
                MBeanServer server = LocalMBeanServer.get();
                for (ObjectName objectName : endpointFactory.jmxNames) {
                    try {
                        server.unregisterMBean(objectName);
                    }
                    catch (Exception e) {
                        logger.error("Unable to unregister MBean " + objectName);
                    }
                }
            }
        }
        finally {
            beanContext.setContainer(null);
            beanContext.setContainerData(null);
            this.deployments.remove(beanContext.getDeploymentID());
        }
    }

    @Override
    public Object invoke(Object deployID, Method callMethod, Object[] args, Object primKey, Object securityIdentity) throws OpenEJBException {
        return this.invoke(deployID, null, callMethod.getDeclaringClass(), callMethod, args, primKey);
    }

    @Override
    public Object invoke(Object deployID, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        return this.invoke(deployID, null, callInterface, callMethod, args, primKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object deploymentId, InterfaceType type, Class callInterface, Method method, Object[] args, Object primKey) throws OpenEJBException {
        Instance instance;
        BeanContext beanContext = this.getBeanContext(deploymentId);
        EndpointFactory endpointFactory = (EndpointFactory)beanContext.getContainerData();
        MdbInstanceFactory instanceFactory = endpointFactory.getInstanceFactory();
        try {
            instance = (Instance)instanceFactory.createInstance(true);
        }
        catch (UnavailableException e) {
            throw new SystemException("Unable to create instance for invocation", e);
        }
        try {
            this.beforeDelivery(beanContext, instance, method, null);
            Object value = this.invoke((Object)instance, method, type, args);
            this.afterDelivery(instance);
            Object object = value;
            return object;
        }
        finally {
            instanceFactory.freeInstance(instance, true);
        }
    }

    public void beforeDelivery(BeanContext deployInfo, Object instance, Method method, XAResource xaResource) throws SystemException {
        ThreadContext callContext = new ThreadContext(deployInfo, null);
        ThreadContext oldContext = ThreadContext.enter(callContext);
        MdbCallContext mdbCallContext = new MdbCallContext();
        callContext.set(MdbCallContext.class, mdbCallContext);
        mdbCallContext.deliveryMethod = method;
        mdbCallContext.oldCallContext = oldContext;
        try {
            mdbCallContext.txPolicy = EjbTransactionUtil.createTransactionPolicy(deployInfo.getTransactionType(method), callContext);
            if (xaResource != null && mdbCallContext.txPolicy.isNewTransaction()) {
                mdbCallContext.txPolicy.enlistResource(xaResource);
            }
        }
        catch (ApplicationException e) {
            ThreadContext.exit(oldContext);
            throw new SystemException("Should never get an Application exception", e);
        }
        catch (SystemException e) {
            ThreadContext.exit(oldContext);
            throw e;
        }
        catch (Exception e) {
            ThreadContext.exit(oldContext);
            throw new SystemException("Unable to enlist xa resource in the transaction", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object instance, Method method, InterfaceType type, Object ... args) throws SystemException, ApplicationException {
        Object object;
        OpenEJBException openEjbException;
        block10: {
            if (args == null) {
                args = NO_ARGS;
            }
            ThreadContext callContext = ThreadContext.getThreadContext();
            BeanContext deployInfo = callContext.getBeanContext();
            MdbCallContext mdbCallContext = callContext.get(MdbCallContext.class);
            if (mdbCallContext == null) {
                throw new IllegalStateException("beforeDelivery was not called");
            }
            if (!mdbCallContext.deliveryMethod.getName().equals(method.getName())) throw new IllegalStateException("Delivery method specified in beforeDelivery is not the delivery method called");
            if (!Arrays.deepEquals(mdbCallContext.deliveryMethod.getParameterTypes(), method.getParameterTypes())) {
                throw new IllegalStateException("Delivery method specified in beforeDelivery is not the delivery method called");
            }
            Object returnValue = null;
            openEjbException = null;
            Operation oldOperation = callContext.getCurrentOperation();
            callContext.setCurrentOperation(type == InterfaceType.TIMEOUT ? Operation.TIMEOUT : Operation.BUSINESS);
            try {
                if (logger.isDebugEnabled()) {
                    logger.info("invoking method " + method.getName() + " on " + deployInfo.getDeploymentID());
                }
                Method targetMethod = deployInfo.getMatchingBeanMethod(method);
                callContext.set(Method.class, targetMethod);
                object = returnValue = this._invoke(instance, targetMethod, args, deployInfo, type, mdbCallContext);
                callContext.setCurrentOperation(oldOperation);
                if (!logger.isDebugEnabled()) return object;
                if (openEjbException != null) break block10;
                logger.debug("finished invoking method " + method.getName() + ". Return value:" + returnValue);
                return object;
            }
            catch (ApplicationException e) {
                try {
                    openEjbException = e;
                    throw e;
                    catch (SystemException e2) {
                        openEjbException = e2;
                        throw e2;
                    }
                }
                catch (Throwable throwable) {
                    callContext.setCurrentOperation(oldOperation);
                    if (!logger.isDebugEnabled()) throw throwable;
                    if (openEjbException == null) {
                        logger.debug("finished invoking method " + method.getName() + ". Return value:" + returnValue);
                        throw throwable;
                    }
                    Throwable exception = openEjbException.getRootCause() != null ? openEjbException.getRootCause() : openEjbException;
                    logger.debug("finished invoking method " + method.getName() + " with exception " + exception);
                    throw throwable;
                }
            }
        }
        Throwable exception = openEjbException.getRootCause() != null ? openEjbException.getRootCause() : openEjbException;
        logger.debug("finished invoking method " + method.getName() + " with exception " + exception);
        return object;
    }

    private Object _invoke(Object instance, Method runMethod, Object[] args, BeanContext beanContext, InterfaceType interfaceType, MdbCallContext mdbCallContext) throws SystemException, ApplicationException {
        try {
            List<InterceptorData> interceptors = beanContext.getMethodInterceptors(runMethod);
            InterceptorStack interceptorStack = new InterceptorStack(((Instance)instance).bean, runMethod, interfaceType == InterfaceType.TIMEOUT ? Operation.TIMEOUT : Operation.BUSINESS, interceptors, ((Instance)instance).interceptors);
            Object returnValue = interceptorStack.invoke(args);
            return returnValue;
        }
        catch (Throwable e) {
            ExceptionType type;
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if ((type = beanContext.getExceptionType(e)) == ExceptionType.SYSTEM) {
                EjbTransactionUtil.handleSystemException(mdbCallContext.txPolicy, e, ThreadContext.getThreadContext());
            } else {
                EjbTransactionUtil.handleApplicationException(mdbCallContext.txPolicy, e, false);
            }
            throw new AssertionError((Object)"Should not get here");
        }
    }

    public void afterDelivery(Object instance) throws SystemException {
        ThreadContext callContext = ThreadContext.getThreadContext();
        MdbCallContext mdbCallContext = callContext.get(MdbCallContext.class);
        try {
            EjbTransactionUtil.afterInvoke(mdbCallContext.txPolicy, callContext);
        }
        catch (ApplicationException e) {
            throw new SystemException("Should never get an Application exception", e);
        }
        finally {
            ThreadContext.exit(mdbCallContext.oldCallContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(BeanContext deployInfo, Object instance) {
        block10: {
            ThreadContext callContext = ThreadContext.getThreadContext();
            boolean contextExitRequired = false;
            if (callContext == null) {
                callContext = new ThreadContext(deployInfo, null);
                ThreadContext.enter(callContext);
                contextExitRequired = true;
            }
            try {
                MdbCallContext mdbCallContext = callContext.get(MdbCallContext.class);
                if (mdbCallContext == null) break block10;
                try {
                    EjbTransactionUtil.afterInvoke(mdbCallContext.txPolicy, callContext);
                }
                catch (Exception e) {
                    logger.error("error while releasing message endpoint", e);
                }
                finally {
                    EndpointFactory endpointFactory = (EndpointFactory)deployInfo.getContainerData();
                    endpointFactory.getInstanceFactory().freeInstance((Instance)instance, false);
                }
            }
            finally {
                if (contextExitRequired) {
                    ThreadContext.exit(callContext);
                }
            }
        }
    }

    private static class MdbCallContext {
        private Method deliveryMethod;
        private TransactionPolicy txPolicy;
        private ThreadContext oldCallContext;

        private MdbCallContext() {
        }
    }
}

