/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.timer.DefaultTimerThreadPoolAdapter;
import org.apache.openejb.core.timer.EJBCronTriggerPersistenceDelegate;
import org.apache.openejb.core.timer.EjbTimeoutJob;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.timer.MemoryTimerStore;
import org.apache.openejb.core.timer.TimerData;
import org.apache.openejb.core.timer.TimerStore;
import org.apache.openejb.core.timer.TimerStoreException;
import org.apache.openejb.core.timer.TimerType;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.SetAccessible;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.triggers.AbstractTrigger;
import org.quartz.simpl.RAMJobStore;

public class EjbTimerServiceImpl
implements EjbTimerService,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getInstance(LogCategory.TIMER, "org.apache.openejb.util.resources");
    public static final String QUARTZ_JMX = "org.quartz.scheduler.jmx.export";
    public static final String QUARTZ_MAKE_SCHEDULER_THREAD_DAEMON = "org.quartz.scheduler.makeSchedulerThreadDaemon";
    public static final String OPENEJB_TIMEOUT_JOB_NAME = "OPENEJB_TIMEOUT_JOB";
    public static final String OPENEJB_TIMEOUT_JOB_GROUP_NAME = "OPENEJB_TIMEOUT_GROUP";
    public static final String EJB_TIMER_RETRY_ATTEMPTS = "EjbTimer.RetryAttempts";
    public static final String OPENEJB_QUARTZ_USE_TCCL = "openejb.quartz.use-TCCL";
    private boolean transacted;
    private int retryAttempts;
    private transient TransactionManager transactionManager;
    private transient BeanContext deployment;
    private transient TimerStore timerStore;
    private transient Scheduler scheduler = null;

    public EjbTimerServiceImpl(BeanContext deployment) {
        this(deployment, EjbTimerServiceImpl.getDefaultTransactionManager(), new MemoryTimerStore(EjbTimerServiceImpl.getDefaultTransactionManager()), -1);
    }

    public static TransactionManager getDefaultTransactionManager() {
        return (TransactionManager)SystemInstance.get().getComponent(TransactionManager.class);
    }

    public EjbTimerServiceImpl(BeanContext deployment, TransactionManager transactionManager, TimerStore timerStore, int retryAttempts) {
        this.deployment = deployment;
        this.transactionManager = transactionManager;
        this.timerStore = timerStore;
        TransactionType transactionType = deployment.getTransactionType(deployment.getEjbTimeout());
        this.transacted = transactionType == TransactionType.Required || transactionType == TransactionType.RequiresNew;
        this.retryAttempts = retryAttempts;
        if (retryAttempts < 0) {
            this.retryAttempts = deployment.getOptions().get(EJB_TIMER_RETRY_ATTEMPTS, 1);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.deployment.getDeploymentID().toString());
        out.writeBoolean(this.transacted);
        out.writeInt(this.retryAttempts);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        String dId = in.readUTF();
        this.transacted = in.readBoolean();
        this.retryAttempts = in.readInt();
        this.deployment = ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getBeanContext(dId);
        this.transactionManager = EjbTimerServiceImpl.getDefaultTransactionManager();
        this.timerStore = new MemoryTimerStore(this.transactionManager);
        this.scheduler = (Scheduler)Proxy.newProxyInstance(this.deployment.getClassLoader(), new Class[]{Scheduler.class}, (InvocationHandler)new LazyScheduler(this.deployment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Scheduler getDefaultScheduler(BeanContext deployment) {
        Scheduler thisScheduler;
        Scheduler scheduler = deployment.get(Scheduler.class);
        if (scheduler != null) {
            boolean valid;
            try {
                valid = !scheduler.isShutdown();
            }
            catch (Exception ignored) {
                valid = false;
            }
            if (valid) {
                return scheduler;
            }
        }
        BeanContext beanContext = deployment;
        synchronized (beanContext) {
            scheduler = deployment.get(Scheduler.class);
            if (scheduler != null) {
                return scheduler;
            }
            Properties properties = new Properties();
            EjbTimerServiceImpl.putAll(properties, SystemInstance.get().getProperties());
            EjbTimerServiceImpl.putAll(properties, deployment.getModuleContext().getAppContext().getProperties());
            EjbTimerServiceImpl.putAll(properties, deployment.getModuleContext().getProperties());
            EjbTimerServiceImpl.putAll(properties, deployment.getProperties());
            boolean newInstance = false;
            for (String key : properties.stringPropertyNames()) {
                if (!key.startsWith("org.quartz.")) continue;
                newInstance = true;
                break;
            }
            SystemInstance systemInstance = SystemInstance.get();
            String defaultThreadPool = DefaultTimerThreadPoolAdapter.class.getName();
            if (!properties.containsKey("org.quartz.threadPool.class")) {
                properties.put("org.quartz.threadPool.class", defaultThreadPool);
            }
            if (!properties.containsKey("org.quartz.scheduler.instanceName")) {
                properties.put("org.quartz.scheduler.instanceName", "OpenEJB-TimerService-Scheduler");
            }
            if (!properties.containsKey(QUARTZ_MAKE_SCHEDULER_THREAD_DAEMON)) {
                properties.put(QUARTZ_MAKE_SCHEDULER_THREAD_DAEMON, "true");
            }
            if (!properties.containsKey(QUARTZ_JMX) && LocalMBeanServer.isJMXActive()) {
                properties.put(QUARTZ_JMX, "true");
            }
            if (!properties.containsKey("org.quartz.scheduler.instanceId")) {
                if (!newInstance) {
                    properties.setProperty("org.quartz.scheduler.instanceId", "OpenEJB");
                } else {
                    properties.setProperty("org.quartz.scheduler.instanceId", deployment.getDeploymentID().toString());
                }
            }
            if (properties.containsKey("org.quartz.jobStore.class") && !properties.containsKey("org.quartz.jobStore.driverDelegateInitString")) {
                properties.put("org.quartz.jobStore.driverDelegateInitString", "triggerPersistenceDelegateClasses=" + EJBCronTriggerPersistenceDelegate.class.getName());
            }
            if (defaultThreadPool.equals(properties.get("org.quartz.threadPool.class")) && properties.containsKey("org.quartz.threadPool.threadCount") && !properties.containsKey("openejb.timer.pool.size")) {
                log.info("Found property 'org.quartz.threadPool.threadCount' for default thread pool, please use 'openejb.timer.pool.size' instead");
            }
            if (!properties.getProperty("org.quartz.jobStore.class", RAMJobStore.class.getName()).equals(RAMJobStore.class.getName())) {
                properties.put("org.quartz.jobStore.makeThreadsDaemons", properties.getProperty("org.quartz.jobStore.makeThreadsDaemon", "true"));
            }
            if ((scheduler = (Scheduler)systemInstance.getComponent(Scheduler.class)) == null || newInstance) {
                try {
                    ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
                    if (!"true".equals(deployment.getProperties().getProperty(OPENEJB_QUARTZ_USE_TCCL, "false"))) {
                        Thread.currentThread().setContextClassLoader(EjbTimerServiceImpl.class.getClassLoader());
                    }
                    try {
                        thisScheduler = new StdSchedulerFactory(properties).getScheduler();
                        thisScheduler.start();
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldCl);
                    }
                    JobDetail job = JobBuilder.newJob(EjbTimeoutJob.class).withIdentity(OPENEJB_TIMEOUT_JOB_NAME, OPENEJB_TIMEOUT_JOB_GROUP_NAME).storeDurably(true).requestRecovery(false).build();
                    thisScheduler.addJob(job, true);
                }
                catch (SchedulerException e) {
                    throw new OpenEJBRuntimeException("Fail to initialize the default scheduler", e);
                }
                if (!newInstance) {
                    systemInstance.setComponent(Scheduler.class, (Object)thisScheduler);
                }
            } else {
                thisScheduler = scheduler;
            }
            deployment.set(Scheduler.class, thisScheduler);
        }
        return thisScheduler;
    }

    private static void putAll(Properties a, Properties b) {
        for (Map.Entry<Object, Object> entry : b.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("org.quartz.")) continue;
            a.put(entry.getKey(), entry.getValue());
        }
    }

    public void shutdownMe() {
        this.cleanTimerData();
        this.shutdownMyScheduler();
    }

    private void cleanTimerData() {
        if (this.timerStore == null || this.scheduler == null || this.deployment == null) {
            return;
        }
        Collection<TimerData> timerDatas = this.timerStore.getTimers(this.deployment.getDeploymentID().toString());
        if (timerDatas == null) {
            return;
        }
        for (TimerData data : timerDatas) {
            Trigger trigger = data.getTrigger();
            if (trigger == null) continue;
            TriggerKey key = trigger.getKey();
            try {
                this.scheduler.unscheduleJob(key);
            }
            catch (SchedulerException ignored) {
                log.warning("An error occured deleting trigger '" + key + "' on bean " + this.deployment.getDeploymentID());
            }
        }
    }

    private void shutdownMyScheduler() {
        if (this.scheduler == null) {
            return;
        }
        boolean defaultScheduler = false;
        Scheduler ds = (Scheduler)SystemInstance.get().getComponent(Scheduler.class);
        try {
            defaultScheduler = ds == this.scheduler || this.scheduler.getSchedulerName().equals(ds.getSchedulerName());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!defaultScheduler) {
            try {
                this.scheduler.shutdown();
            }
            catch (SchedulerException e) {
                throw new OpenEJBRuntimeException("Unable to shutdown scheduler", e);
            }
        }
    }

    public static void shutdown() {
        Scheduler scheduler = (Scheduler)SystemInstance.get().getComponent(Scheduler.class);
        if (scheduler != null) {
            try {
                scheduler.shutdown();
            }
            catch (SchedulerException e) {
                throw new OpenEJBRuntimeException("Unable to shutdown scheduler", e);
            }
        }
    }

    @Override
    public void start() throws TimerStoreException {
        this.scheduler = EjbTimerServiceImpl.getDefaultScheduler(this.deployment);
        Collection<TimerData> timerDatas = this.timerStore.loadTimers(this, (String)this.deployment.getDeploymentID());
        for (TimerData timerData : timerDatas) {
            this.initializeNewTimer(timerData);
        }
    }

    @Override
    public void stop() {
        for (TimerData timerData : this.timerStore.getTimers((String)this.deployment.getDeploymentID())) {
            try {
                timerData.stop();
            }
            catch (EJBException e) {
                log.error("fail to stop timer", e);
            }
        }
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void schedule(TimerData timerData) {
        if (this.scheduler == null) {
            throw new IllegalStateException("Scheduler is not configured properly");
        }
        timerData.setScheduler(this.scheduler);
        Trigger trigger = timerData.getTrigger();
        if (null == trigger) {
            try {
                if (!this.scheduler.isShutdown()) {
                    log.warning("Failed to schedule: " + timerData.getInfo());
                }
            }
            catch (SchedulerException e) {
                // empty catch block
            }
        }
        if (!(trigger instanceof AbstractTrigger)) {
            throw new OpenEJBRuntimeException("the trigger was not an AbstractTrigger - Should not be possible: " + trigger);
        }
        AbstractTrigger atrigger = (AbstractTrigger)trigger;
        atrigger.setJobName(OPENEJB_TIMEOUT_JOB_NAME);
        atrigger.setJobGroup(OPENEJB_TIMEOUT_JOB_GROUP_NAME);
        JobDataMap triggerDataMap = trigger.getJobDataMap();
        triggerDataMap.put("EJB_TIMERS_SERVICE", (Object)this);
        triggerDataMap.put("TIMER_DATA", (Object)timerData);
        try {
            if (!this.scheduler.checkExists(new TriggerKey(atrigger.getName(), atrigger.getGroup()))) {
                this.scheduler.scheduleJob(trigger);
            }
        }
        catch (Exception e) {
            log.warning("Could not schedule timer " + timerData, e);
        }
    }

    public void cancelled(TimerData timerData) {
        this.timerStore.removeTimer(timerData.getId());
    }

    public void addTimerData(TimerData timerData) {
        try {
            this.timerStore.addTimerData(timerData);
        }
        catch (Exception e) {
            log.warning("Could not add timer of type " + timerData.getType().name() + " due to " + e.getMessage());
        }
    }

    @Override
    public Timer getTimer(long timerId) {
        TimerData timerData = this.timerStore.getTimer((String)this.deployment.getDeploymentID(), timerId);
        if (timerData != null) {
            return timerData.getTimer();
        }
        return null;
    }

    @Override
    public Collection<Timer> getTimers(Object primaryKey) throws IllegalStateException {
        this.checkState();
        ArrayList<Timer> timers = new ArrayList<Timer>();
        for (TimerData timerData : this.timerStore.getTimers((String)this.deployment.getDeploymentID())) {
            timers.add(timerData.getTimer());
        }
        return timers;
    }

    @Override
    public Timer createTimer(Object primaryKey, Method timeoutMethod, long duration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration is negative: " + duration);
        }
        this.checkState();
        Date expiration = new Date(System.currentTimeMillis() + duration);
        try {
            TimerData timerData = this.timerStore.createSingleActionTimer(this, (String)this.deployment.getDeploymentID(), primaryKey, timeoutMethod, expiration, timerConfig);
            this.initializeNewTimer(timerData);
            return timerData.getTimer();
        }
        catch (TimerStoreException e) {
            throw new EJBException((Exception)e);
        }
    }

    @Override
    public Timer createTimer(Object primaryKey, Method timeoutMethod, long initialDuration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialDuration < 0L) {
            throw new IllegalArgumentException("initialDuration is negative: " + initialDuration);
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("intervalDuration is negative: " + intervalDuration);
        }
        this.checkState();
        Date initialExpiration = new Date(System.currentTimeMillis() + initialDuration);
        try {
            TimerData timerData = this.timerStore.createIntervalTimer(this, (String)this.deployment.getDeploymentID(), primaryKey, timeoutMethod, initialExpiration, intervalDuration, timerConfig);
            this.initializeNewTimer(timerData);
            return timerData.getTimer();
        }
        catch (TimerStoreException e) {
            throw new EJBException((Exception)e);
        }
    }

    @Override
    public Timer createTimer(Object primaryKey, Method timeoutMethod, Date expiration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (expiration == null) {
            throw new IllegalArgumentException("expiration is null");
        }
        if (expiration.getTime() < 0L) {
            throw new IllegalArgumentException("expiration is negative: " + expiration.getTime());
        }
        this.checkState();
        try {
            TimerData timerData = this.timerStore.createSingleActionTimer(this, (String)this.deployment.getDeploymentID(), primaryKey, timeoutMethod, expiration, timerConfig);
            this.initializeNewTimer(timerData);
            return timerData.getTimer();
        }
        catch (TimerStoreException e) {
            throw new EJBException((Exception)e);
        }
    }

    @Override
    public Timer createTimer(Object primaryKey, Method timeoutMethod, Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialExpiration == null) {
            throw new IllegalArgumentException("initialExpiration is null");
        }
        if (initialExpiration.getTime() < 0L) {
            throw new IllegalArgumentException("initialExpiration is negative: " + initialExpiration.getTime());
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("intervalDuration is negative: " + intervalDuration);
        }
        this.checkState();
        try {
            TimerData timerData = this.timerStore.createIntervalTimer(this, (String)this.deployment.getDeploymentID(), primaryKey, timeoutMethod, initialExpiration, intervalDuration, timerConfig);
            this.initializeNewTimer(timerData);
            return timerData.getTimer();
        }
        catch (TimerStoreException e) {
            throw new EJBException((Exception)e);
        }
    }

    @Override
    public Timer createTimer(Object primaryKey, Method timeoutMethod, ScheduleExpression scheduleExpression, TimerConfig timerConfig) {
        if (scheduleExpression == null) {
            throw new IllegalArgumentException("scheduleExpression is null");
        }
        this.checkState();
        try {
            TimerData timerData = this.timerStore.createCalendarTimer(this, (String)this.deployment.getDeploymentID(), primaryKey, timeoutMethod, scheduleExpression, timerConfig);
            this.initializeNewTimer(timerData);
            return timerData.getTimer();
        }
        catch (TimerStoreException e) {
            throw new EJBException((Exception)e);
        }
    }

    public TimerStore getTimerStore() {
        return this.timerStore;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    private void initializeNewTimer(TimerData timerData) {
        timerData.newTimer();
    }

    private void checkState() throws IllegalStateException {
        BaseContext context = (BaseContext)this.deployment.get(EJBContext.class);
        context.check(BaseContext.Call.timerMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void ejbTimeout(TimerData timerData) {
        try {
            Timer timer = this.getTimer(timerData.getId());
            if (timer == null && this.timerStore instanceof MemoryTimerStore && timerData.getTimer() != null) {
                try {
                    this.timerStore.addTimerData(timerData);
                    timer = timerData.getTimer();
                }
                catch (TimerStoreException e) {
                    // empty catch block
                }
            }
            for (int tries = 0; tries < 1 + this.retryAttempts; ++tries) {
                boolean retry;
                block60: {
                    retry = false;
                    if (this.transacted) {
                        try {
                            this.transactionManager.begin();
                        }
                        catch (Exception e) {
                            log.warning("Exception occured while starting container transaction", e);
                            if (timerData.getType() == TimerType.SingleAction) {
                                this.timerStore.removeTimer(timerData.getId());
                                timerData.setExpired(true);
                            } else if (timerData.getType() == TimerType.Calendar && timerData.getNextTimeout() == null) {
                                this.timerStore.removeTimer(timerData.getId());
                                timerData.setExpired(true);
                            } else {
                                this.timerStore.updateIntervalTimer(timerData);
                            }
                            return;
                        }
                    }
                    RpcContainer container = (RpcContainer)this.deployment.getContainer();
                    Method ejbTimeout = timerData.getTimeoutMethod();
                    SetAccessible.on(ejbTimeout);
                    container.invoke(this.deployment.getDeploymentID(), InterfaceType.TIMEOUT, ejbTimeout.getDeclaringClass(), ejbTimeout, new Object[]{timer}, timerData.getPrimaryKey());
                    if (this.transacted) break block60;
                    if (retry) continue;
                    return;
                }
                if (this.transactionManager.getStatus() == 0) {
                    this.transactionManager.commit();
                    return;
                }
                try {
                    this.transactionManager.rollback();
                }
                catch (Exception e) {
                    log.warning("Exception occured while completing container transaction", e);
                }
                continue;
                catch (RuntimeException e) {
                    block61: {
                        retry = true;
                        log.warning("RuntimeException from ejbTimeout on " + this.deployment.getDeploymentID(), e);
                        try {
                            this.transactionManager.setRollbackOnly();
                        }
                        catch (SystemException e1) {
                            log.warning("Exception occured while setting RollbackOnly for container transaction", e1);
                        }
                        if (this.transacted) break block61;
                        if (retry) continue;
                        return;
                    }
                    if (this.transactionManager.getStatus() == 0) {
                        this.transactionManager.commit();
                        return;
                    }
                    try {
                        this.transactionManager.rollback();
                    }
                    catch (Exception e2) {
                        log.warning("Exception occured while completing container transaction", e2);
                    }
                    continue;
                }
                catch (OpenEJBException e2) {
                    block63: {
                        block62: {
                            retry = true;
                            log.warning("Exception from ejbTimeout on " + this.deployment.getDeploymentID(), e2);
                            if (!this.transacted) break block62;
                            try {
                                this.transactionManager.setRollbackOnly();
                            }
                            catch (SystemException e1) {
                                log.warning("Exception occured while setting RollbackOnly for container transaction", e1);
                            }
                            {
                                catch (Throwable throwable) {
                                    block64: {
                                        try {
                                            if (this.transacted) break block64;
                                            if (retry) continue;
                                            if (timerData.getType() == TimerType.SingleAction) {
                                                this.timerStore.removeTimer(timerData.getId());
                                                timerData.setExpired(true);
                                            } else if (timerData.getType() == TimerType.Calendar && timerData.getNextTimeout() == null) {
                                                this.timerStore.removeTimer(timerData.getId());
                                                timerData.setExpired(true);
                                            } else {
                                                this.timerStore.updateIntervalTimer(timerData);
                                            }
                                            return;
                                        }
                                        catch (Exception e3) {
                                            log.warning("Exception occured while completing container transaction", e3);
                                            throw throwable;
                                        }
                                    }
                                    if (this.transactionManager.getStatus() == 0) {
                                        this.transactionManager.commit();
                                        return;
                                    }
                                    this.transactionManager.rollback();
                                    continue;
                                }
                            }
                        }
                        if (this.transacted) break block63;
                        if (retry) continue;
                        return;
                    }
                    if (this.transactionManager.getStatus() == 0) {
                        this.transactionManager.commit();
                        return;
                    }
                    try {
                        this.transactionManager.rollback();
                    }
                    catch (Exception e4) {
                        log.warning("Exception occured while completing container transaction", e4);
                    }
                    continue;
                }
            }
            log.warning("Failed to execute ejbTimeout on " + timerData.getDeploymentId() + " successfully within " + this.retryAttempts + " attempts");
        }
        catch (RuntimeException e) {
            log.warning("RuntimeException occured while calling ejbTimeout", e);
            throw e;
        }
        catch (Error e) {
            log.warning("Error occured while calling ejbTimeout", e);
            throw e;
        }
        finally {
            if (timerData.getType() == TimerType.SingleAction) {
                this.timerStore.removeTimer(timerData.getId());
                timerData.setExpired(true);
            } else if (timerData.getType() == TimerType.Calendar && timerData.getNextTimeout() == null) {
                this.timerStore.removeTimer(timerData.getId());
                timerData.setExpired(true);
            } else {
                this.timerStore.updateIntervalTimer(timerData);
            }
        }
    }

    private static class LazyScheduler
    implements InvocationHandler {
        private final BeanContext ejb;

        public LazyScheduler(BeanContext deployment) {
            this.ejb = deployment;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke((Object)EjbTimerServiceImpl.getDefaultScheduler(this.ejb), args);
        }
    }
}

