/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaBuilderImpl;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.FromImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalExpression;
import org.eclipse.persistence.internal.jpa.querydef.InternalSelection;
import org.eclipse.persistence.internal.jpa.querydef.RootImpl;
import org.eclipse.persistence.internal.jpa.querydef.SubQueryImpl;

public abstract class AbstractQueryImpl<T>
implements AbstractQuery<T>,
Serializable {
    protected Metamodel metamodel;
    protected Set<Root<?>> roots = new HashSet();
    protected Expression<Boolean> where;
    protected ResultType queryResult;
    protected CriteriaBuilderImpl queryBuilder;
    protected boolean distinct;
    protected Class queryType;
    protected Predicate havingClause;
    protected List<Expression<?>> groupBy;

    public AbstractQueryImpl(Metamodel metamodel, ResultType queryResult, CriteriaBuilderImpl queryBuilder, Class<T> resultType) {
        this.metamodel = metamodel;
        this.queryResult = queryResult;
        this.queryBuilder = queryBuilder;
        this.queryType = resultType;
    }

    public <X> Root<X> from(EntityType<X> entity) {
        RootImpl root = new RootImpl((ManagedType)entity, this.metamodel, entity.getBindableJavaType(), (org.eclipse.persistence.expressions.Expression)new ExpressionBuilder(entity.getBindableJavaType()), (Bindable)entity);
        this.integrateRoot(root);
        return root;
    }

    public <X> Root<X> from(Class<X> entityClass) {
        EntityType entity = this.metamodel.entity(entityClass);
        return this.from(entity);
    }

    public Class<T> getResultType() {
        return this.queryType;
    }

    public Set<Root<?>> getRoots() {
        return this.roots;
    }

    public AbstractQuery<T> where(Expression<Boolean> restriction) {
        this.findRootAndParameters(restriction);
        this.where = restriction;
        return this;
    }

    public AbstractQuery<T> where(Predicate ... restrictions) {
        if (restrictions == null || restrictions.length == 0) {
            this.where = null;
        }
        Predicate predicate = this.queryBuilder.and(restrictions);
        this.findRootAndParameters((Expression<?>)predicate);
        this.where = predicate;
        return this;
    }

    public AbstractQuery<T> groupBy(List<Expression<?>> grouping) {
        this.groupBy = grouping;
        return this;
    }

    public AbstractQuery<T> groupBy(Expression<?> ... grouping) {
        this.groupBy = new ArrayList();
        Expression<?>[] expressionArray = grouping;
        int n = grouping.length;
        int n2 = 0;
        while (n2 < n) {
            Expression<?> exp = expressionArray[n2];
            this.groupBy.add(exp);
            ++n2;
        }
        return this;
    }

    public AbstractQuery<T> having(Expression<Boolean> restriction) {
        this.havingClause = ((InternalExpression)restriction).isCompoundExpression() || ((InternalExpression)restriction).isPredicate() ? (Predicate)restriction : this.queryBuilder.isTrue(restriction);
        return this;
    }

    public AbstractQuery<T> having(Predicate ... restrictions) {
        if (restrictions != null && restrictions.length > 0) {
            Predicate conjunction = this.queryBuilder.conjunction();
            Predicate[] predicateArray = restrictions;
            int n = restrictions.length;
            int n2 = 0;
            while (n2 < n) {
                Predicate predicate = predicateArray[n2];
                conjunction = this.queryBuilder.and((Expression<Boolean>)conjunction, (Expression<Boolean>)predicate);
                ++n2;
            }
            this.havingClause = conjunction;
        }
        return this;
    }

    public abstract void addParameter(ParameterExpression<?> var1);

    public abstract void addJoin(FromImpl var1);

    public AbstractQuery<T> distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public List<Expression<?>> getGroupList() {
        return this.groupBy;
    }

    public Predicate getRestriction() {
        if (this.where == null) {
            return null;
        }
        if (((ExpressionImpl)this.where).isPredicate()) {
            return (Predicate)this.where;
        }
        return this.queryBuilder.isTrue(this.where);
    }

    public Predicate getGroupRestriction() {
        return this.havingClause;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public <U> Subquery<U> subquery(Class<U> type) {
        return new SubQueryImpl(this.metamodel, type, this.queryBuilder, this);
    }

    protected abstract void integrateRoot(RootImpl var1);

    protected void findRootAndParameters(Expression<?> predicate) {
        ((InternalSelection)predicate).findRootAndParameters(this);
    }

    protected void findRootAndParameters(Selection<?> selection) {
        if (selection.isCompoundSelection()) {
            for (Selection subSelection : selection.getCompoundSelectionItems()) {
                this.findRootAndParameters(subSelection);
            }
        }
    }

    protected void findJoins(FromImpl root) {
        root.findJoins(this);
    }

    protected org.eclipse.persistence.expressions.Expression getBaseExpression() {
        if (this.roots.isEmpty()) {
            return new ExpressionBuilder();
        }
        return ((RootImpl)this.roots.iterator().next()).getCurrentNode();
    }

    protected static enum ResultType {
        UNKNOWN,
        OBJECT_ARRAY,
        PARTIAL,
        TUPLE,
        ENTITY,
        CONSTRUCTOR,
        OTHER;

    }
}

