/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.artifact.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFSEntry;
import org.eclipse.virgo.kernel.artifact.fs.internal.JarFileArtifactFS;
import org.eclipse.virgo.util.io.FileCopyUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;

public final class BundleManifestUtils {
    public static BundleManifest readBundleManifest(File file, String ... archiveSuffixes) throws IOException, SecurityException {
        String fileName = file.getName();
        Reader reader = null;
        if (file.isDirectory()) {
            File manifestFile = new File(file, "META-INF/MANIFEST.MF");
            if (manifestFile.exists()) {
                reader = BundleManifestUtils.manifestReaderFromFile(manifestFile);
            }
        } else {
            String[] stringArray = archiveSuffixes;
            int n = archiveSuffixes.length;
            int n2 = 0;
            while (n2 < n) {
                String suffix = stringArray[n2];
                if (fileName.endsWith(suffix)) {
                    reader = BundleManifestUtils.manifestReaderFromJar(file);
                }
                ++n2;
            }
        }
        if (reader != null) {
            return BundleManifestFactory.createBundleManifest((Reader)reader);
        }
        return null;
    }

    private static Reader manifestReaderFromJar(File file) throws IOException, SecurityException {
        if (!file.exists()) {
            throw new IOException("File '" + file + "' not found");
        }
        JarFileArtifactFS fs = new JarFileArtifactFS(file);
        ArtifactFSEntry fsEntry = fs.getEntry("META-INF/MANIFEST.MF");
        if (fsEntry == null || !fsEntry.exists()) {
            return null;
        }
        StringWriter writer = new StringWriter();
        InputStream inputStream = fsEntry.getInputStream();
        FileCopyUtils.copy((Reader)new InputStreamReader(inputStream), (Writer)writer);
        inputStream.close();
        return new StringReader(writer.toString());
    }

    private static Reader manifestReaderFromFile(File file) throws IOException {
        try {
            StringWriter writer = new StringWriter();
            FileCopyUtils.copy((Reader)new InputStreamReader(new FileInputStream(file)), (Writer)writer);
            return new StringReader(writer.toString());
        }
        catch (IOException ioe) {
            throw new IOException("Failed to create reader for manifest file.", ioe);
        }
    }
}

