/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.request;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.management.MalformedObjectNameException;
import org.jolokia.request.JmxExecRequest;
import org.jolokia.request.JmxListRequest;
import org.jolokia.request.JmxReadRequest;
import org.jolokia.request.JmxRequest;
import org.jolokia.request.JmxSearchRequest;
import org.jolokia.request.JmxVersionRequest;
import org.jolokia.request.JmxWriteRequest;
import org.jolokia.request.RequestCreator;
import org.jolokia.util.EscapeUtil;
import org.jolokia.util.RequestType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JmxRequestFactory {
    private static final Map<RequestType, RequestCreator> CREATOR_MAP = new HashMap<RequestType, RequestCreator>();

    private JmxRequestFactory() {
    }

    public static <R extends JmxRequest> R createGetRequest(String pPathInfo, Map<String, String[]> pParameterMap) {
        RequestType type = null;
        try {
            String pathInfo = JmxRequestFactory.extractPathInfo(pPathInfo, pParameterMap);
            Stack<String> elements = EscapeUtil.extractElementsFromPath(pathInfo);
            type = elements.size() != 0 ? RequestType.getTypeByName(elements.pop()) : RequestType.VERSION;
            return JmxRequestFactory.getCreator(type).create(elements, JmxRequestFactory.extractParameters(pParameterMap));
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name. " + e.getMessage(), e);
        }
        catch (EmptyStackException exp) {
            throw new IllegalArgumentException("Invalid arguments in pathinfo " + pPathInfo + (type != null ? " for command " + (Object)((Object)type) : ""), exp);
        }
    }

    public static <R extends JmxRequest> R createPostRequest(Map<String, ?> pRequestMap, Map<String, String[]> pParameterMap) {
        try {
            Map<String, String> params = JmxRequestFactory.mergeMaps((Map)pRequestMap.get("config"), JmxRequestFactory.extractParameters(pParameterMap));
            RequestType type = RequestType.getTypeByName((String)pRequestMap.get("type"));
            return JmxRequestFactory.getCreator(type).create(pRequestMap, params);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name. " + e.getMessage(), e);
        }
    }

    public static List<JmxRequest> createPostRequests(List pJsonRequests, Map<String, String[]> pParameterMap) {
        ArrayList<JmxRequest> ret = new ArrayList<JmxRequest>();
        for (Object o : pJsonRequests) {
            if (!(o instanceof Map)) {
                throw new IllegalArgumentException("Not a request within the list of requests " + pJsonRequests + ". Expected map, but found: " + o);
            }
            ret.add((JmxRequest)JmxRequestFactory.createPostRequest((Map)o, pParameterMap));
        }
        return ret;
    }

    private static String extractPathInfo(String pPathInfo, Map<String, String[]> pParameterMap) {
        String[] vals;
        String pathInfo = pPathInfo;
        if (pParameterMap != null && (pPathInfo == null || pPathInfo.length() == 0 || pathInfo.matches("^/+$")) && (vals = pParameterMap.get("p")) != null && vals.length > 0) {
            pathInfo = vals[0];
        }
        return JmxRequestFactory.normalizePathInfo(pathInfo);
    }

    private static Map<String, String> extractParameters(Map<String, String[]> pParameterMap) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (pParameterMap != null) {
            for (Map.Entry<String, String[]> entry : pParameterMap.entrySet()) {
                String[] values = entry.getValue();
                if (values == null || values.length <= 0) continue;
                ret.put(entry.getKey(), values[0]);
            }
        }
        return ret;
    }

    private static Map<String, String> mergeMaps(Map<String, String> ... pMaps) {
        if (pMaps.length == 0) {
            return null;
        }
        if (pMaps.length == 1) {
            return pMaps[0];
        }
        if (pMaps.length == 2) {
            if (pMaps[0] == null) {
                return pMaps[1];
            }
            if (pMaps[1] == null) {
                return pMaps[0];
            }
        }
        return JmxRequestFactory.plainMergeMaps(pMaps);
    }

    private static Map<String, String> plainMergeMaps(Map<String, String>[] pMaps) {
        HashMap<String, String> pRet = new HashMap<String, String>();
        for (int i = pMaps.length - 1; i >= 0; --i) {
            if (pMaps[i] == null) continue;
            pRet.putAll(pMaps[i]);
        }
        return pRet;
    }

    private static String normalizePathInfo(String pPathInfo) {
        if (pPathInfo != null && pPathInfo.length() > 0) {
            return pPathInfo.startsWith("/") ? pPathInfo.substring(1) : pPathInfo;
        }
        return "";
    }

    private static RequestCreator getCreator(RequestType pType) {
        RequestCreator creator = CREATOR_MAP.get((Object)pType);
        if (creator == null) {
            throw new UnsupportedOperationException("Type " + (Object)((Object)pType) + " is not supported (yet)");
        }
        return creator;
    }

    static {
        CREATOR_MAP.put(RequestType.READ, JmxReadRequest.newCreator());
        CREATOR_MAP.put(RequestType.WRITE, JmxWriteRequest.newCreator());
        CREATOR_MAP.put(RequestType.EXEC, JmxExecRequest.newCreator());
        CREATOR_MAP.put(RequestType.LIST, JmxListRequest.newCreator());
        CREATOR_MAP.put(RequestType.VERSION, JmxVersionRequest.newCreator());
        CREATOR_MAP.put(RequestType.SEARCH, JmxSearchRequest.newCreator());
    }
}

