/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.util;

import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceObjectFactory {
    private ServiceObjectFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> createServiceObjects(String ... pDescriptorPaths) {
        try {
            ServiceEntry.initDefaultOrder();
            TreeMap extractorMap = new TreeMap();
            for (String descriptor : pDescriptorPaths) {
                ServiceObjectFactory.readServiceDefinitions(extractorMap, descriptor);
            }
            ArrayList ret = new ArrayList();
            for (Object service : extractorMap.values()) {
                ret.add(service);
            }
            ArrayList arrayList = ret;
            return arrayList;
        }
        finally {
            ServiceEntry.removeDefaultOrder();
        }
    }

    private static <T> void readServiceDefinitions(Map<ServiceEntry, T> pExtractorMap, String pDefPath) {
        try {
            Enumeration<URL> resUrls = ServiceObjectFactory.class.getClassLoader().getResources(pDefPath);
            while (resUrls.hasMoreElements()) {
                ServiceObjectFactory.readServiceDefinitionFromUrl(pExtractorMap, resUrls.nextElement());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load extractor from " + pDefPath + ": " + e, e);
        }
    }

    /*
     * Exception decompiling
     */
    private static <T> void readServiceDefinitionFromUrl(Map<ServiceEntry, T> pExtractorMap, URL pUrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static <T> void createOrRemoveService(Map<ServiceEntry, T> pExtractorMap, String pLine) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (pLine.length() > 0) {
            ServiceEntry entry = new ServiceEntry(pLine);
            if (entry.isRemove()) {
                HashSet<ServiceEntry> toRemove = new HashSet<ServiceEntry>();
                for (ServiceEntry key : pExtractorMap.keySet()) {
                    if (!key.getClassName().equals(entry.getClassName())) continue;
                    toRemove.add(key);
                }
                for (ServiceEntry key : toRemove) {
                    pExtractorMap.remove(key);
                }
            } else {
                Class<?> clazz = ServiceObjectFactory.class.getClassLoader().loadClass(entry.getClassName());
                Object ext = clazz.newInstance();
                pExtractorMap.put(entry, ext);
            }
        }
    }

    private static void closeReader(LineNumberReader pReader) {
        if (pReader != null) {
            try {
                pReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ServiceEntry
    implements Comparable<ServiceEntry> {
        private String className;
        private boolean remove;
        private Integer order;
        private static ThreadLocal<Integer> defaultOrderHolder = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 100;
            }
        };

        public ServiceEntry(String pLine) {
            String[] parts = pLine.split(",");
            if (parts[0].startsWith("!")) {
                this.remove = true;
                this.className = parts[0].substring(1);
            } else {
                this.remove = false;
                this.className = parts[0];
            }
            if (parts.length > 1) {
                try {
                    this.order = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException exp) {
                    this.order = this.nextDefaultOrder();
                }
            } else {
                this.order = this.nextDefaultOrder();
            }
        }

        private Integer nextDefaultOrder() {
            Integer defaultOrder = defaultOrderHolder.get();
            defaultOrderHolder.set(defaultOrder + 1);
            return defaultOrder;
        }

        private static void initDefaultOrder() {
            defaultOrderHolder.set(100);
        }

        private static void removeDefaultOrder() {
            defaultOrderHolder.remove();
        }

        private String getClassName() {
            return this.className;
        }

        private boolean isRemove() {
            return this.remove;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceEntry that = (ServiceEntry)o;
            return this.className.equals(that.className);
        }

        public int hashCode() {
            return this.className.hashCode();
        }

        @Override
        public int compareTo(ServiceEntry o) {
            return this.order - o.order;
        }
    }
}

