/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.spi.ConfigurationState;
import org.apache.bval.jsr303.ApacheFactoryContext;
import org.apache.bval.jsr303.ApacheValidationProvider;
import org.apache.bval.jsr303.ApacheValidatorConfiguration;
import org.apache.bval.jsr303.ConstraintCached;
import org.apache.bval.jsr303.ConstraintDefaults;
import org.apache.bval.jsr303.xml.AnnotationIgnores;
import org.apache.bval.jsr303.xml.MetaConstraint;
import org.apache.bval.jsr303.xml.ValidationMappingParser;
import org.apache.bval.util.AccessStrategy;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheValidatorFactory
implements ValidatorFactory,
Cloneable {
    private static volatile ApacheValidatorFactory DEFAULT_FACTORY;
    private static final ConstraintDefaults defaultConstraints;
    private MessageInterpolator messageResolver;
    private TraversableResolver traversableResolver;
    private ConstraintValidatorFactory constraintValidatorFactory;
    private final Map<String, String> properties;
    private final AnnotationIgnores annotationIgnores = new AnnotationIgnores();
    private final ConstraintCached constraintsCache = new ConstraintCached();
    private final Map<Class<?>, Class<?>[]> defaultSequences;
    private final Map<Class<?>, List<AccessStrategy>> validAccesses;
    private final Map<Class<?>, List<MetaConstraint<?, ? extends Annotation>>> constraintMap;

    public static synchronized ApacheValidatorFactory getDefault() {
        if (DEFAULT_FACTORY == null) {
            DEFAULT_FACTORY = (ApacheValidatorFactory)((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).buildValidatorFactory().unwrap(ApacheValidatorFactory.class);
        }
        return DEFAULT_FACTORY;
    }

    public static void setDefault(ApacheValidatorFactory aDefaultFactory) {
        DEFAULT_FACTORY = aDefaultFactory;
    }

    public ApacheValidatorFactory(ConfigurationState configurationState) {
        this.properties = new HashMap<String, String>();
        this.defaultSequences = new HashMap();
        this.validAccesses = new HashMap();
        this.constraintMap = new HashMap();
        this.configure(configurationState);
    }

    protected void configure(ConfigurationState configuration) {
        this.getProperties().putAll(configuration.getProperties());
        this.setMessageInterpolator(configuration.getMessageInterpolator());
        this.setTraversableResolver(configuration.getTraversableResolver());
        this.setConstraintValidatorFactory(configuration.getConstraintValidatorFactory());
        ValidationMappingParser parser = new ValidationMappingParser(this);
        parser.processMappingConfig(configuration.getMappingStreams());
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Validator getValidator() {
        return this.usingContext().getValidator();
    }

    public ApacheFactoryContext usingContext() {
        return new ApacheFactoryContext(this);
    }

    public synchronized ApacheValidatorFactory clone() {
        try {
            return (ApacheValidatorFactory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public final void setMessageInterpolator(MessageInterpolator messageResolver) {
        this.messageResolver = messageResolver;
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageResolver;
    }

    public final void setTraversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public final void setConstraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.constraintValidatorFactory = constraintValidatorFactory;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isInstance(this)) {
            ApacheValidatorFactory result = this;
            return (T)result;
        }
        if (!type.isInterface() && !Modifier.isAbstract(type.getModifiers())) {
            return this.newInstance(type);
        }
        try {
            Class cls = ClassUtils.getClass((String)(type.getName() + "Impl"));
            if (type.isAssignableFrom(cls)) {
                T result = this.newInstance(cls);
                return result;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new ValidationException("Type " + type + " not supported");
    }

    private <T> T newInstance(final Class<T> cls) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                try {
                    return cls.newInstance();
                }
                catch (Exception ex) {
                    throw new ValidationException("Cannot instantiate : " + cls, (Throwable)ex);
                }
            }
        });
    }

    public ConstraintDefaults getDefaultConstraints() {
        return defaultConstraints;
    }

    public AnnotationIgnores getAnnotationIgnores() {
        return this.annotationIgnores;
    }

    public ConstraintCached getConstraintsCache() {
        return this.constraintsCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetaConstraint(Class<?> beanClass, MetaConstraint<?, ?> metaConstraint) {
        List<MetaConstraint<?, Annotation>> slot;
        Map<Class<?>, List<MetaConstraint<?, ? extends Annotation>>> map = this.constraintMap;
        synchronized (map) {
            slot = this.constraintMap.get(beanClass);
            if (slot == null) {
                slot = new ArrayList();
                this.constraintMap.put(beanClass, slot);
            }
        }
        slot.add(metaConstraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValid(Class<?> beanClass, AccessStrategy accessStrategy) {
        List<AccessStrategy> slot;
        Map<Class<?>, List<AccessStrategy>> map = this.validAccesses;
        synchronized (map) {
            slot = this.validAccesses.get(beanClass);
            if (slot == null) {
                slot = new ArrayList<AccessStrategy>();
                this.validAccesses.put(beanClass, slot);
            }
        }
        slot.add(accessStrategy);
    }

    public void addDefaultSequence(Class<?> beanClass, Class<?> ... groupSequence) {
        this.defaultSequences.put(beanClass, ApacheValidatorFactory.safeArray(groupSequence));
    }

    public <T> List<MetaConstraint<T, ? extends Annotation>> getMetaConstraints(Class<T> beanClass) {
        List<MetaConstraint<?, ? extends Annotation>> slot = this.constraintMap.get(beanClass);
        if (slot == null) {
            return Collections.emptyList();
        }
        List<MetaConstraint<?, ? extends Annotation>> result = slot;
        return Collections.unmodifiableList(result);
    }

    public List<AccessStrategy> getValidAccesses(Class<?> beanClass) {
        List<AccessStrategy> slot = this.validAccesses.get(beanClass);
        return slot == null ? Collections.emptyList() : Collections.unmodifiableList(slot);
    }

    public Class<?>[] getDefaultSequence(Class<?> beanClass) {
        return ApacheValidatorFactory.safeArray(this.defaultSequences.get(beanClass));
    }

    private static Class<?>[] safeArray(Class<?> ... array) {
        return ArrayUtils.isEmpty((Object[])array) ? ArrayUtils.EMPTY_CLASS_ARRAY : (Class[])ArrayUtils.clone((Object[])array);
    }

    static {
        defaultConstraints = new ConstraintDefaults();
    }
}

