/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.bval;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import javax.ejb.SessionContext;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.naming.InitialContext;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import javax.validation.Validator;
import org.apache.openejb.core.ivm.naming.NamingException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class BeanValidationAppendixInterceptor {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, BeanValidationAppendixInterceptor.class);
    private static final Class<?> APACHE_BVAL_METHOD_CLASS = BeanValidationAppendixInterceptor.initApache();
    private static final Class<?> HIBERNATE_METHOD_CLASS = BeanValidationAppendixInterceptor.initHibernate();
    private SessionContext sessionContext;

    @AroundInvoke
    public Object aroundInvoke(InvocationContext ejbContext) throws Exception {
        Object validatorObject = null;
        Validator validator = null;
        try {
            validator = (Validator)new InitialContext().lookup("java:comp/Validator");
            this.sessionContext = (SessionContext)new InitialContext().lookup("java:comp/EJBContext");
        }
        catch (NamingException ne) {
            // empty catch block
        }
        Class bvalClazzToValidate = ejbContext.getTarget().getClass();
        if (this.sessionContext != null && ejbContext.getTarget().getClass().getInterfaces().length > 0) {
            bvalClazzToValidate = this.sessionContext.getInvokedBusinessInterface();
        }
        Method method = ejbContext.getMethod();
        if (!bvalClazzToValidate.equals(ejbContext.getTarget().getClass())) {
            method = bvalClazzToValidate.getMethod(method.getName(), method.getParameterTypes());
        }
        Set<Object> violations = Collections.emptySet();
        if (APACHE_BVAL_METHOD_CLASS != null && validator != null) {
            validatorObject = validator.unwrap(APACHE_BVAL_METHOD_CLASS);
            violations = BeanValidationAppendixInterceptor.call(Set.class, validatorObject, "validateParameters", new Object[]{bvalClazzToValidate, method, ejbContext.getParameters(), new Class[0]}, new Class[]{Class.class, Method.class, Object[].class, Class[].class});
        } else if (HIBERNATE_METHOD_CLASS != null && validator != null) {
            validatorObject = validator.unwrap(HIBERNATE_METHOD_CLASS);
            violations = BeanValidationAppendixInterceptor.call(Set.class, validatorObject, "validateAllParameters", new Object[]{ejbContext.getTarget(), ejbContext.getMethod(), ejbContext.getParameters(), new Class[0]}, new Class[]{Object.class, Method.class, Object[].class, Class[].class});
        } else if (validator == null) {
            logger.error("can't find validator");
        } else {
            logger.warning("Apache Bean Validation is not present, " + BeanValidationAppendixInterceptor.class.getName() + " will not work. " + "Please put it if you want to validate your parameters and returned values " + "with bean validation JSR.");
        }
        if (violations.size() > 0) {
            throw this.buildValidationException(violations);
        }
        Object returnedValue = ejbContext.proceed();
        violations = Collections.emptySet();
        if (validatorObject != null && APACHE_BVAL_METHOD_CLASS != null) {
            violations = BeanValidationAppendixInterceptor.call(Set.class, validatorObject, "validateReturnedValue", new Object[]{bvalClazzToValidate, method, returnedValue, new Class[0]}, new Class[]{Class.class, Method.class, Object.class, Class[].class});
        } else if (validatorObject != null && HIBERNATE_METHOD_CLASS != null) {
            violations = BeanValidationAppendixInterceptor.call(Set.class, validatorObject, "validateReturnValue", new Object[]{ejbContext.getTarget(), ejbContext.getMethod(), returnedValue, new Class[0]}, new Class[]{Object.class, Method.class, Object.class, Class[].class});
        }
        if (violations.size() > 0) {
            throw this.buildValidationException(violations);
        }
        return returnedValue;
    }

    private RuntimeException buildValidationException(Set<ConstraintViolation<?>> violations) {
        return new ConstraintViolationException(violations);
    }

    private static <T> T call(Class<T> returnedType, Object o, String methodName, Object[] params, Class<?>[] types) {
        Method method = null;
        boolean accessible = true;
        try {
            method = o.getClass().getMethod(methodName, types);
            accessible = method.isAccessible();
            if (!accessible) {
                accessible = false;
                method.setAccessible(true);
            }
            T t = returnedType.cast(method.invoke(o, params));
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ValidationException("can't call method " + methodName + " on " + o, (Throwable)e);
        }
        finally {
            if (method != null) {
                method.setAccessible(accessible);
            }
        }
    }

    private static ClassLoader getClassLaoder() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = BeanValidationAppendixInterceptor.class.getClassLoader();
        }
        return classLoader;
    }

    private static Class<?> initApache() {
        try {
            return BeanValidationAppendixInterceptor.getClassLaoder().loadClass("org.apache.bval.jsr303.extensions.MethodValidator");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class<?> initHibernate() {
        try {
            return BeanValidationAppendixInterceptor.getClassLaoder().loadClass("org.hibernate.validator.method.MethodValidator");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

