/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.artifact.par;

import java.io.File;
import java.io.IOException;
import org.eclipse.virgo.kernel.artifact.internal.BundleManifestUtils;
import org.eclipse.virgo.repository.ArtifactBridge;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.ArtifactGenerationException;
import org.eclipse.virgo.repository.HashGenerator;
import org.eclipse.virgo.repository.builder.ArtifactDescriptorBuilder;
import org.eclipse.virgo.repository.builder.AttributeBuilder;
import org.eclipse.virgo.util.common.StringUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.osgi.framework.Version;

public final class ParBridge
implements ArtifactBridge {
    private static final String SYMBOLIC_NAME_REGEX = "[-_0-9a-zA-Z]+(\\.[-_0-9a-zA-Z]+)*";
    private static final String HEADER_APPLICATION_SYMBOLIC_NAME = "Application-SymbolicName";
    private static final String HEADER_APPLICATION_NAME = "Application-Name";
    private static final String HEADER_APPLICATION_DESCRIPTION = "Application-Description";
    private static final String HEADER_APPLICATION_VERSION = "Application-Version";
    public static final String BRIDGE_TYPE = "par";
    public static final String PAR_SUFFIX = ".par";
    private final HashGenerator hashGenerator;

    public ParBridge(HashGenerator hashGenerator) {
        this.hashGenerator = hashGenerator;
    }

    public ArtifactDescriptor generateArtifactDescriptor(File artifactFile) throws ArtifactGenerationException {
        BundleManifest manifest;
        try {
            manifest = BundleManifestUtils.readBundleManifest(artifactFile, PAR_SUFFIX);
        }
        catch (IOException ioe) {
            throw new ArtifactGenerationException("Failed to read manifest from " + artifactFile, (Throwable)ioe);
        }
        if (manifest != null) {
            return this.createDescriptorFromManifest(manifest, artifactFile);
        }
        return this.createDescriptorFromFile(artifactFile);
    }

    private ArtifactDescriptor createDescriptorFromFile(File artifactFile) throws ArtifactGenerationException {
        String fileName = artifactFile.getName();
        if (fileName.endsWith(PAR_SUFFIX)) {
            String symbolicName = fileName.substring(0, fileName.length() - PAR_SUFFIX.length());
            ArtifactDescriptorBuilder builder = new ArtifactDescriptorBuilder();
            builder.setType(BRIDGE_TYPE).setName(symbolicName).setVersion(Version.emptyVersion).setUri(artifactFile.toURI());
            this.hashGenerator.generateHash(builder, artifactFile);
            return builder.build();
        }
        return null;
    }

    private ArtifactDescriptor createDescriptorFromManifest(BundleManifest manifest, File artifactFile) throws ArtifactGenerationException {
        String symbolicName = this.getApplicationSymbolicName(manifest);
        if (symbolicName == null) {
            return null;
        }
        Version version = this.getApplicationVersion(manifest);
        ArtifactDescriptorBuilder builder = new ArtifactDescriptorBuilder();
        builder.setType(BRIDGE_TYPE).setName(symbolicName).setVersion(version).setUri(artifactFile.toURI());
        this.applyAttributeIfPresent(HEADER_APPLICATION_NAME, manifest, builder);
        this.applyAttributeIfPresent(HEADER_APPLICATION_DESCRIPTION, manifest, builder);
        this.hashGenerator.generateHash(builder, artifactFile);
        return builder.build();
    }

    private void applyAttributeIfPresent(String headerName, BundleManifest manifest, ArtifactDescriptorBuilder builder) {
        String headerValue = manifest.getHeader(headerName);
        if (headerValue != null) {
            AttributeBuilder attributeBuilder = new AttributeBuilder();
            builder.addAttribute(attributeBuilder.setName(headerName).setValue(headerValue).build());
        }
    }

    private Version getApplicationVersion(BundleManifest manifest) {
        Version version;
        String versionString = manifest.getHeader(HEADER_APPLICATION_VERSION);
        if (!StringUtils.hasText((String)versionString)) {
            version = Version.emptyVersion;
        } else {
            try {
                version = new Version(versionString);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Version '" + versionString + "' is ill-formed", iae);
            }
        }
        return version;
    }

    private String getApplicationSymbolicName(BundleManifest manifest) throws ArtifactGenerationException {
        String symbolicName = manifest.getHeader(HEADER_APPLICATION_SYMBOLIC_NAME);
        if (!StringUtils.hasText((String)symbolicName)) {
            return null;
        }
        if (!symbolicName.matches(SYMBOLIC_NAME_REGEX)) {
            throw new ArtifactGenerationException("Application-SymbolicName '" + symbolicName + "' contains illegal characters");
        }
        return symbolicName;
    }
}

