/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.util.common.GraphNode;

final class PlanMemberCollector {
    PlanMemberCollector() {
    }

    List<InstallArtifact> collectPlanMembers(PlanInstallArtifact plan) {
        ArtifactCollectingGraphVisitor visitor = new ArtifactCollectingGraphVisitor(plan);
        plan.getGraph().visit((GraphNode.DirectedAcyclicGraphVisitor)visitor);
        return visitor.getMembers();
    }

    private static final class ArtifactCollectingGraphVisitor
    implements GraphNode.DirectedAcyclicGraphVisitor<InstallArtifact> {
        private final InstallArtifact root;
        private final List<InstallArtifact> members = new ArrayList<InstallArtifact>();
        private final Object monitor = new Object();

        public ArtifactCollectingGraphVisitor(InstallArtifact root) {
            this.root = root;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean visit(GraphNode<InstallArtifact> node) {
            InstallArtifact artifact = (InstallArtifact)node.getValue();
            if (!this.root.equals(artifact)) {
                Object object = this.monitor;
                synchronized (object) {
                    this.members.add(artifact);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<InstallArtifact> getMembers() {
            Object object = this.monitor;
            synchronized (object) {
                return new ArrayList<InstallArtifact>(this.members);
            }
        }
    }
}

