/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.virgo.shell.internal.CommandDescriptor;
import org.eclipse.virgo.shell.internal.CommandResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public final class CommandRegistry {
    private final CommandResolver commandResolver;
    private final BundleContext bundleContext;
    private final List<CommandDescriptor> commandDescriptors = new ArrayList<CommandDescriptor>();
    private final Map<ServiceReference<?>, List<CommandDescriptor>> commandDescriptorsByService = new HashMap();
    private final Object monitor = new Object();
    private final CommandRegistryServiceListener commandRegistryServiceListener = new CommandRegistryServiceListener();

    public CommandRegistry(CommandResolver commandResolver, BundleContext bundleContext) {
        this.commandResolver = commandResolver;
        this.bundleContext = bundleContext;
    }

    void initialize() {
        this.bundleContext.addServiceListener((ServiceListener)this.commandRegistryServiceListener);
        try {
            ServiceReference[] serviceReferences = this.bundleContext.getServiceReferences(null, null);
            if (serviceReferences != null) {
                ServiceReference[] serviceReferenceArray = serviceReferences;
                int n = serviceReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference serviceReference = serviceReferenceArray[n2];
                    this.serviceRegistered(serviceReference);
                    ++n2;
                }
            }
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("Unexpected InvalidSyntaxException", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CommandDescriptor> getCommandDescriptors() {
        Object object = this.monitor;
        synchronized (object) {
            return new ArrayList<CommandDescriptor>(this.commandDescriptors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceRegistered(ServiceReference<?> serviceReference) {
        List<CommandDescriptor> commands;
        Object service = this.bundleContext.getService(serviceReference);
        if (service != null && !(commands = this.commandResolver.resolveCommands(serviceReference, service)).isEmpty()) {
            Object object = this.monitor;
            synchronized (object) {
                this.commandDescriptors.addAll(commands);
                this.commandDescriptorsByService.put(serviceReference, commands);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceUnregistering(ServiceReference<?> serviceReference) {
        Object object = this.monitor;
        synchronized (object) {
            List<CommandDescriptor> commandDescriptorsForService = this.commandDescriptorsByService.remove(serviceReference);
            if (commandDescriptorsForService != null) {
                this.commandDescriptors.removeAll(commandDescriptorsForService);
            }
        }
    }

    private final class CommandRegistryServiceListener
    implements ServiceListener {
        private CommandRegistryServiceListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            if (1 == event.getType()) {
                CommandRegistry.this.serviceRegistered(event.getServiceReference());
            } else if (4 == event.getType()) {
                CommandRegistry.this.serviceUnregistering(event.getServiceReference());
            }
        }
    }
}

