/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.converters;

import org.eclipse.virgo.shell.Converter;

public final class LongConverter
implements Converter {
    private static final String[] TYPES = new String[]{Long.class.getName(), Long.TYPE.getName()};

    public static String[] getTypes() {
        return (String[])TYPES.clone();
    }

    @Override
    public Object convert(Class<?> desiredType, Object in) throws Exception {
        if (this.canConvert(desiredType)) {
            try {
                return Long.valueOf(in.toString());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    @Override
    public CharSequence format(Object target, int level, Converter escape) throws Exception {
        if (this.canFormat(target)) {
            return String.valueOf(target);
        }
        return null;
    }

    private boolean canConvert(Class<?> desiredType) {
        return Long.class.equals(desiredType) || Long.TYPE.equals(desiredType);
    }

    private boolean canFormat(Object target) {
        return target instanceof Long;
    }
}

