/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.eclipse.virgo.util.common.Assert;
import org.eclipse.virgo.util.io.FileSystemEvent;
import org.eclipse.virgo.util.io.FileSystemListener;
import org.eclipse.virgo.util.io.FileSystemUtils;
import org.eclipse.virgo.util.math.Sets;
import org.slf4j.Logger;

public final class FileSystemChecker {
    private final File checkDir;
    private final Logger logger;
    private final Object checkLock = new Object();
    private static final String INITIAL_EVENT_HANDLING_MODE = "org.eclipse.virgo.fschecker.initialEventMode";
    private static final String BULK_MODE_VALUE = "bulk";
    private final AtomicBoolean isInitialEventsHandlingInitiatedOnce = new AtomicBoolean(false);
    private final Map<String, Long> fileState = new HashMap<String, Long>(32);
    private final Map<String, MonitorRecord> monitorRecords = new HashMap<String, MonitorRecord>(16);
    private final List<FileSystemListener> listeners = new CopyOnWriteArrayList<FileSystemListener>();
    private final FilenameFilter includeFilter;
    private static boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");

    public FileSystemChecker(File checkDir) {
        this(checkDir, null, null);
    }

    public FileSystemChecker(File checkDir, String excludePattern) {
        this(checkDir, excludePattern, null);
    }

    public FileSystemChecker(File checkDir, Logger logger) {
        this(checkDir, null, logger);
    }

    public FileSystemChecker(File checkDir, String excludePattern, Logger logger) {
        Assert.isTrue((boolean)checkDir.isDirectory(), (String)"Check directory '%s' must exist and must be a directory.", (Object[])new Object[]{checkDir.getAbsolutePath()});
        this.checkDir = checkDir;
        this.logger = logger;
        final Pattern compiledExcludePattern = excludePattern == null ? null : Pattern.compile(excludePattern);
        this.includeFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return compiledExcludePattern == null || !compiledExcludePattern.matcher(name).matches();
            }
        };
        this.populateInitialState();
    }

    public void addListener(FileSystemListener listener) {
        this.listeners.add(listener);
    }

    private List<File> getInitialFiles(File[] files) {
        ArrayList<File> resultFiles = new ArrayList<File>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            MonitorRecord monitorRecord;
            File file = fileArray[n2];
            String keyFilePath = this.key(file);
            if (this.monitorRecords.containsKey(keyFilePath) && FileSystemEvent.INITIAL.equals((Object)(monitorRecord = this.monitorRecords.get(keyFilePath)).getEvent())) {
                resultFiles.add(file);
            }
            ++n2;
        }
        return resultFiles;
    }

    private void handleInitialFiles(List<File> initialFiles) {
        HashMap<File, Long> initialLastModified = new HashMap<File, Long>();
        for (File file : initialFiles) {
            initialLastModified.put(file, file.lastModified());
        }
        this.notifyListenersOnInitialEvent(initialFiles);
        for (File file : initialFiles) {
            this.monitorRecords.remove(this.key(file));
            this.setKnownFileState(file, (Long)initialLastModified.get(file));
        }
    }

    private List<String> getPaths(List<File> files) {
        ArrayList<String> filePaths = new ArrayList<String>();
        for (File file : files) {
            filePaths.add(this.key(file));
        }
        return filePaths;
    }

    private void notifyListenersOnInitialEvent(List<File> initialFiles) {
        List<String> initialFilesPaths = this.getPaths(initialFiles);
        for (FileSystemListener listener : this.listeners) {
            try {
                listener.onInitialEvent(initialFilesPaths);
            }
            catch (Throwable e) {
                if (this.logger == null) continue;
                this.logger.warn("Listener threw exception for event " + (Object)((Object)FileSystemEvent.INITIAL), e);
            }
        }
    }

    private File[] removeFilesFromArray(File[] inputArray, List<File> filesToRemove) {
        ArrayList<File> reducedFiles = new ArrayList<File>(Arrays.asList(inputArray));
        reducedFiles.removeAll(filesToRemove);
        return reducedFiles.toArray(new File[reducedFiles.size()]);
    }

    private void addToCurrentFileKeys(Set<String> currentFileKeys, List<File> files) {
        for (File file : files) {
            currentFileKeys.add(this.key(file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() {
        Object object = this.checkLock;
        synchronized (object) {
            block25: {
                try {
                    try {
                        List<File> initialFiles;
                        File[] currentFiles;
                        try {
                            currentFiles = this.listCurrentDirFiles();
                        }
                        catch (Exception e) {
                            if (this.logger != null) {
                                this.logger.warn("FileSystemChecker caught exception from listFiles()", (Throwable)e);
                            }
                            throw e;
                        }
                        this.debugState("before check:", currentFiles);
                        HashSet<String> currentFileKeys = new HashSet<String>(currentFiles.length);
                        if (this.isInitialEventsBulkHandlingEnabled() && this.isInitialEventsHandlingInitiatedOnce.compareAndSet(false, true) && !(initialFiles = this.getInitialFiles(currentFiles)).isEmpty()) {
                            this.handleInitialFiles(initialFiles);
                            this.addToCurrentFileKeys(currentFileKeys, initialFiles);
                            currentFiles = this.removeFilesFromArray(currentFiles, initialFiles);
                        }
                        File[] fileArray = currentFiles;
                        int n = currentFiles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            String keyFile = this.key(file);
                            currentFileKeys.add(keyFile);
                            if (!this.isKnown(file)) {
                                this.monitorRecords.put(keyFile, new MonitorRecord(file.length(), FileSystemEvent.CREATED));
                                this.setKnownFileState(file);
                            } else if (this.monitorRecords.containsKey(keyFile)) {
                                MonitorRecord monitorRecord = this.monitorRecords.get(keyFile);
                                long size = file.length();
                                long lastModified = file.lastModified();
                                if (size > monitorRecord.getSize()) {
                                    monitorRecord.setSize(size);
                                } else if (this.isUnlocked(file)) {
                                    this.notifyListeners(this.key(file), monitorRecord.getEvent());
                                    this.monitorRecords.remove(keyFile);
                                }
                                this.setKnownFileState(file, lastModified);
                            } else if (file.lastModified() > this.knownLastModified(file)) {
                                this.monitorRecords.put(keyFile, new MonitorRecord(file.length(), FileSystemEvent.MODIFIED));
                                this.setKnownFileState(file);
                            }
                            ++n2;
                        }
                        Set deletedFiles = Sets.difference(this.fileState.keySet(), currentFileKeys);
                        for (String deletedFile : deletedFiles) {
                            if (this.monitorRecords.containsKey(deletedFile)) {
                                MonitorRecord monitorRecord = this.monitorRecords.get(deletedFile);
                                if (monitorRecord.getEvent().equals((Object)FileSystemEvent.MODIFIED)) {
                                    this.notifyListeners(deletedFile, FileSystemEvent.DELETED);
                                }
                            } else {
                                this.notifyListeners(deletedFile, FileSystemEvent.DELETED);
                            }
                            this.fileState.remove(deletedFile);
                            this.monitorRecords.remove(deletedFile);
                        }
                    }
                    catch (Exception exception) {
                        this.debugState("after check:", null);
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    this.debugState("after check:", null);
                    throw throwable;
                }
                this.debugState("after check:", null);
            }
        }
    }

    public boolean isUnlocked(File file) {
        return !WINDOWS || file.renameTo(file);
    }

    private void debugState(String heading, File[] files) {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            boolean first;
            StringBuilder sb = new StringBuilder().append(this.checkDir).append(" - ").append(heading);
            if (files != null) {
                sb.append("\n\tFileList():  [");
                first = true;
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(f.getName());
                    first = false;
                    ++n2;
                }
                sb.append("]");
            }
            if (this.fileState != null) {
                sb.append("\n\tKnown files: [");
                first = true;
                for (String s : this.fileState.keySet()) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(s);
                    first = false;
                }
                sb.append("]");
            }
            if (this.monitorRecords != null) {
                sb.append("\n\tMonitored:   [");
                first = true;
                for (String s : this.monitorRecords.keySet()) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(s);
                    first = false;
                }
                sb.append("]");
            }
            this.logger.debug(sb.toString());
        }
    }

    private void notifyListeners(String file, FileSystemEvent event) {
        for (FileSystemListener listener : this.listeners) {
            try {
                listener.onChange(file, event);
            }
            catch (Throwable e) {
                if (this.logger == null) continue;
                this.logger.warn("Listener threw exception for event " + (Object)((Object)event), e);
            }
        }
    }

    private void populateInitialState() throws RuntimeException {
        File[] initialList;
        try {
            initialList = this.listCurrentDirFiles();
        }
        catch (RuntimeException e) {
            if (this.logger != null) {
                this.logger.warn("FileSystemChecker caught exception from listFiles()", (Throwable)e);
            }
            throw e;
        }
        File[] fileArray = initialList;
        int n = initialList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String keyFile = this.key(file);
            this.monitorRecords.put(keyFile, new MonitorRecord(file.length(), FileSystemEvent.INITIAL));
            this.setKnownFileState(file);
            ++n2;
        }
        this.debugState("initial state:", initialList);
    }

    private File[] listCurrentDirFiles() {
        return FileSystemUtils.listFiles(this.checkDir, this.includeFilter, this.logger);
    }

    private void setKnownFileState(File file) {
        String key = this.key(file);
        long lastModified = file.lastModified();
        this.fileState.put(key, lastModified);
    }

    private void setKnownFileState(File file, long lastModified) {
        String key = this.key(file);
        this.fileState.put(key, lastModified);
    }

    private Long knownLastModified(File file) {
        return this.fileState.get(this.key(file));
    }

    private boolean isKnown(File file) {
        return this.fileState.containsKey(this.key(file));
    }

    private String key(File file) {
        String key = file.getAbsolutePath();
        if (file.isDirectory()) {
            key = String.valueOf(key) + File.separator;
        }
        return key;
    }

    private boolean isInitialEventsBulkHandlingEnabled() {
        return BULK_MODE_VALUE.equalsIgnoreCase(System.getProperty(INITIAL_EVENT_HANDLING_MODE));
    }

    private static class MonitorRecord {
        private final FileSystemEvent event;
        private long size;

        public MonitorRecord(long size, FileSystemEvent event) {
            this.size = size;
            this.event = event;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public FileSystemEvent getEvent() {
            return this.event;
        }
    }
}

