/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Context;
import org.apache.openejb.BeanContext;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ThreadContextListener;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ContextsService;

public class RequestScopedThreadContextListener
implements ThreadContextListener {
    @Override
    public void contextEntered(ThreadContext oldContext, ThreadContext newContext) {
        BeanContext beanContext = newContext.getBeanContext();
        WebBeansContext webBeansContext = beanContext.getModuleContext().getAppContext().getWebBeansContext();
        ContextsService contextsService = webBeansContext.getContextsService();
        Context requestContext = contextsService.getCurrentContext(RequestScoped.class);
        if (requestContext == null) {
            contextsService.startContext(RequestScoped.class, null);
            newContext.set(DestroyContext.class, new DestroyContext(contextsService, newContext));
        }
    }

    @Override
    public void contextExited(ThreadContext exitedContext, ThreadContext reenteredContext) {
        if (exitedContext == null) {
            return;
        }
        DestroyContext destroyContext = exitedContext.get(DestroyContext.class);
        if (destroyContext == null || destroyContext.threadContext != exitedContext) {
            return;
        }
        destroyContext.contextsService.endContext(RequestScoped.class, null);
    }

    private static class DestroyContext {
        private final ContextsService contextsService;
        private final ThreadContext threadContext;

        private DestroyContext(ContextsService contextsService, ThreadContext threadContext) {
            this.contextsService = contextsService;
            this.threadContext = threadContext;
        }
    }
}

