/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.rules;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.rules.ValidationBase;
import org.apache.openejb.util.CollectionsUtil;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.finder.ResourceFinder;

public class CheckDescriptorLocation
extends ValidationBase {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_VALIDATION, "org.apache.openejb.config.rules");

    @Override
    public void validate(AppModule appModule) {
        ArrayList<String> validated = new ArrayList<String>();
        for (WebModule webModule : CollectionsUtil.safe(appModule.getWebModules())) {
            validated.add(webModule.getModuleId());
            this.validateWebModule(webModule);
        }
        for (EjbModule ejbModule : CollectionsUtil.safe(appModule.getEjbModules())) {
            if (validated.contains(ejbModule.getModuleId())) continue;
            this.validateEjbModule(ejbModule);
        }
    }

    private void validateWebModule(DeploymentModule webModule) {
        Object baseUrl = null;
        this.module = webModule;
        List<String> descriptorsToSearch = Arrays.asList("beans.xml", "ejb-jar.xml", "faces-config.xml");
        File file = webModule.getFile();
        if (file != null) {
            try {
                URL rootOfArchive = file.toURI().toURL();
                URL metaInf = new URL(rootOfArchive.toExternalForm() + "META-INF/");
                Map<String, URL> incorrectlyLocatedDescriptors = CheckDescriptorLocation.retrieveDescriptors(file, descriptorsToSearch, rootOfArchive, metaInf);
                this.warnIncorrectLocationOfDescriptors(incorrectlyLocatedDescriptors, "WEB-INF");
            }
            catch (MalformedURLException ignored) {
                // empty catch block
            }
        }
    }

    public void validateEjbModule(DeploymentModule deploymentModule) {
        Object baseUrl = null;
        this.module = deploymentModule;
        List<String> descriptorsToSearch = Arrays.asList("beans.xml", "ejb-jar.xml", "openejb-jar.xml", "env-entries.properties");
        File file = deploymentModule.getFile();
        if (file != null) {
            try {
                URL rootOfArchive = file.toURI().toURL();
                Map<String, URL> incorrectlyLocatedDescriptors = CheckDescriptorLocation.retrieveDescriptors(file, descriptorsToSearch, rootOfArchive);
                this.warnIncorrectLocationOfDescriptors(incorrectlyLocatedDescriptors, "META-INF");
            }
            catch (MalformedURLException ignored) {
                // empty catch block
            }
        }
    }

    private static Map<String, URL> retrieveDescriptors(File file, List<String> descriptorsToSearch, URL ... locationsToSearch) {
        HashMap<String, URL> descriptorAndWrongLocation = new HashMap<String, URL>();
        ResourceFinder finder = new ResourceFinder(locationsToSearch);
        for (String descriptor : descriptorsToSearch) {
            URL resource = finder.getResource(descriptor);
            if (resource == null) continue;
            descriptorAndWrongLocation.put(descriptor, resource);
        }
        return descriptorAndWrongLocation;
    }

    private void warnIncorrectLocationOfDescriptors(Map<String, URL> descriptorsPlacedInWrongLocation, String expectedLocation) {
        for (Map.Entry<String, URL> map : descriptorsPlacedInWrongLocation.entrySet()) {
            this.warn(this.module.toString(), "descriptor.incorrectLocation", map.getValue().toExternalForm(), expectedLocation);
        }
    }
}

