/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.transaction;

import javax.transaction.TransactionManager;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.core.transaction.TransactionPolicyFactory;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.core.transaction.TxBeanManaged;
import org.apache.openejb.core.transaction.TxMandatory;
import org.apache.openejb.core.transaction.TxNever;
import org.apache.openejb.core.transaction.TxNotSupported;
import org.apache.openejb.core.transaction.TxRequired;
import org.apache.openejb.core.transaction.TxRequiresNew;
import org.apache.openejb.core.transaction.TxSupports;

public class JtaTransactionPolicyFactory
implements TransactionPolicyFactory {
    private final TransactionManager transactionManager;

    public JtaTransactionPolicyFactory(TransactionManager transactionManager) {
        if (transactionManager == null) {
            throw new NullPointerException("transactionManager is null");
        }
        this.transactionManager = transactionManager;
    }

    @Override
    public TransactionPolicy createTransactionPolicy(TransactionType type) throws SystemException, ApplicationException {
        switch (type) {
            case Required: {
                return new TxRequired(this.transactionManager);
            }
            case RequiresNew: {
                return new TxRequiresNew(this.transactionManager);
            }
            case Supports: {
                return new TxSupports(this.transactionManager);
            }
            case NotSupported: {
                return new TxNotSupported(this.transactionManager);
            }
            case Mandatory: {
                return new TxMandatory(this.transactionManager);
            }
            case Never: {
                return new TxNever(this.transactionManager);
            }
            case BeanManaged: {
                return new TxBeanManaged(this.transactionManager);
            }
        }
        throw new SystemException(new IllegalArgumentException("Unknown transaction type " + (Object)((Object)type)));
    }
}

