/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Collection;

public final class NetworkUtil {
    private NetworkUtil() {
    }

    public static int getNextAvailablePort() {
        return NetworkUtil.getNextAvailablePort(new int[]{0});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNextAvailablePort(int[] portList) {
        int port;
        ServerSocket s = null;
        try {
            s = NetworkUtil.create(portList);
            port = s.getLocalPort();
        }
        catch (IOException ioe) {
            port = -1;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNextAvailablePort(int min, int max, Collection<Integer> excepted) {
        int port = -1;
        ServerSocket s = null;
        for (int i = min; i <= max; ++i) {
            try {
                s = NetworkUtil.create(new int[]{i});
                port = s.getLocalPort();
                if (excepted != null && excepted.contains(port)) continue;
                break;
            }
            catch (IOException ioe) {
                port = -1;
                continue;
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable e) {}
                }
            }
        }
        return port;
    }

    private static ServerSocket create(int[] ports) throws IOException {
        for (int port : ports) {
            try {
                return new ServerSocket(port);
            }
            catch (IOException ex) {
            }
        }
        throw new IOException("No free port found");
    }

    public static String getLocalAddress(String start, String end) {
        return start + "localhost:" + NetworkUtil.getNextAvailablePort() + end;
    }
}

