/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ByteArrayBuffer;

public class SimpleBuffers
implements Buffers {
    final Buffer _header;
    final Buffer _buffer;
    boolean _headerOut;
    boolean _bufferOut;

    public SimpleBuffers(Buffer header, Buffer buffer) {
        this._header = header;
        this._buffer = buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer getBuffer() {
        SimpleBuffers simpleBuffers = this;
        synchronized (simpleBuffers) {
            if (this._buffer != null && !this._bufferOut) {
                this._bufferOut = true;
                return this._buffer;
            }
            if (this._buffer != null && this._header != null && this._header.capacity() == this._buffer.capacity() && !this._headerOut) {
                this._headerOut = true;
                return this._header;
            }
            if (this._buffer != null) {
                return new ByteArrayBuffer(this._buffer.capacity());
            }
            return new ByteArrayBuffer(4096);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer getHeader() {
        SimpleBuffers simpleBuffers = this;
        synchronized (simpleBuffers) {
            if (this._header != null && !this._headerOut) {
                this._headerOut = true;
                return this._header;
            }
            if (this._buffer != null && this._header != null && this._header.capacity() == this._buffer.capacity() && !this._bufferOut) {
                this._bufferOut = true;
                return this._buffer;
            }
            if (this._header != null) {
                return new ByteArrayBuffer(this._header.capacity());
            }
            return new ByteArrayBuffer(4096);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer getBuffer(int size) {
        SimpleBuffers simpleBuffers = this;
        synchronized (simpleBuffers) {
            if (this._header != null && this._header.capacity() == size) {
                return this.getHeader();
            }
            if (this._buffer != null && this._buffer.capacity() == size) {
                return this.getBuffer();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnBuffer(Buffer buffer) {
        SimpleBuffers simpleBuffers = this;
        synchronized (simpleBuffers) {
            buffer.clear();
            if (buffer == this._header) {
                this._headerOut = false;
            }
            if (buffer == this._buffer) {
                this._bufferOut = false;
            }
        }
    }
}

