/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactLifecycleListenerSupport;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.util.common.GraphNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AtomicInstallArtifactLifecycleListener
extends InstallArtifactLifecycleListenerSupport {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    AtomicInstallArtifactLifecycleListener() {
    }

    @Override
    public void onStarting(InstallArtifact installArtifact) throws DeploymentException {
        this.logger.debug("Processing atomic starting event for {}", (Object)installArtifact);
        for (InstallArtifact atomicParent : this.getAtomicParents(installArtifact)) {
            if (AtomicInstallArtifactLifecycleListener.aChildIsRefreshing(atomicParent)) {
                this.logger.info("Atomic starting event not propagated from {} as a child of {} is refreshing.", (Object)installArtifact, (Object)atomicParent);
                continue;
            }
            this.logger.info("Propagating atomic starting event from {} to {}", (Object)installArtifact, (Object)atomicParent);
            atomicParent.start();
        }
    }

    @Override
    public void onStartFailed(InstallArtifact installArtifact, Throwable cause) throws DeploymentException {
        this.logger.debug("Processing atomic start failed (stop) event for {}", (Object)installArtifact);
        for (InstallArtifact atomicParent : this.getAtomicParents(installArtifact)) {
            if (AtomicInstallArtifactLifecycleListener.aChildIsRefreshing(atomicParent)) {
                this.logger.info("Atomic start failed event not propagated from {} as a child of {} is refreshing.", (Object)installArtifact, (Object)atomicParent);
                continue;
            }
            this.logger.info("Propagating atomic start failed (stop) event from {} to {}", (Object)installArtifact, (Object)atomicParent);
            atomicParent.stop();
        }
    }

    @Override
    public void onStopped(InstallArtifact installArtifact) {
        this.logger.debug("Processing atomic stopped event for {}", (Object)installArtifact);
        for (InstallArtifact atomicParent : this.getAtomicParents(installArtifact)) {
            if (AtomicInstallArtifactLifecycleListener.aChildIsRefreshing(atomicParent)) {
                this.logger.info("Atomic stopped event not propagated from {} as a child of {} is refreshing.", (Object)installArtifact, (Object)atomicParent);
                continue;
            }
            this.logger.info("Propagating atomic stopped event from {} to {}", (Object)installArtifact, (Object)atomicParent);
            try {
                atomicParent.stop();
            }
            catch (DeploymentException e) {
                this.logger.warn("Unable to propagate stopped event to an atomic root due to an exception", (Throwable)e);
            }
        }
    }

    @Override
    public void onUninstalled(InstallArtifact installArtifact) throws DeploymentException {
        this.logger.debug("Processing atomic uninstalled event for {}", (Object)installArtifact);
        for (InstallArtifact atomicParent : this.getAtomicParents(installArtifact)) {
            if (AtomicInstallArtifactLifecycleListener.aChildIsRefreshing(atomicParent)) {
                this.logger.info("Atomic uninstalled event not propagated from {} as a child of {} is refreshing.", (Object)installArtifact, (Object)atomicParent);
                continue;
            }
            this.logger.info("Propagating atomic uninstalled event from {} to {}", (Object)installArtifact, (Object)atomicParent);
            atomicParent.uninstall();
        }
    }

    private Set<InstallArtifact> getAtomicParents(InstallArtifact installArtifact) {
        HashSet<InstallArtifact> atomicParents = new HashSet<InstallArtifact>();
        for (InstallArtifact parent : AtomicInstallArtifactLifecycleListener.getParentInstallArtifacts(installArtifact)) {
            if (!AtomicInstallArtifactLifecycleListener.isAtomicInstallArtifact(parent)) continue;
            atomicParents.add(parent);
        }
        return atomicParents;
    }

    private static final boolean isAtomicInstallArtifact(InstallArtifact installArtifact) {
        if (installArtifact instanceof PlanInstallArtifact) {
            return ((PlanInstallArtifact)installArtifact).isAtomic();
        }
        return false;
    }

    private static final Set<InstallArtifact> getParentInstallArtifacts(InstallArtifact installArtifact) {
        HashSet<InstallArtifact> parentInstallArtifacts = new HashSet<InstallArtifact>();
        GraphNode<InstallArtifact> iaGraph = installArtifact.getGraph();
        if (iaGraph != null) {
            List parents = iaGraph.getParents();
            for (GraphNode parent : parents) {
                parentInstallArtifacts.add((InstallArtifact)parent.getValue());
            }
        }
        return parentInstallArtifacts;
    }

    private static boolean aChildIsRefreshing(InstallArtifact atomicParent) {
        InstallArtifact[] installArtifactArray = AtomicInstallArtifactLifecycleListener.childrenOf(atomicParent);
        int n = installArtifactArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractInstallArtifact aChild;
            InstallArtifact child = installArtifactArray[n2];
            if (child instanceof AbstractInstallArtifact && (aChild = (AbstractInstallArtifact)child).isRefreshing()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static InstallArtifact[] childrenOf(InstallArtifact parent) {
        GraphNode<InstallArtifact> graph;
        ArrayList<InstallArtifact> children = new ArrayList<InstallArtifact>();
        if (parent != null && (graph = parent.getGraph()) != null) {
            for (GraphNode childBranch : graph.getChildren()) {
                InstallArtifact child = (InstallArtifact)childBranch.getValue();
                if (child == null) continue;
                children.add(child);
            }
        }
        return children.toArray(new InstallArtifact[children.size()]);
    }
}

