/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.commands;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IEvaluationService;

public class PersistentTypeMapAsHandler
extends AbstractHandler
implements IElementUpdater {
    public static final String COMMAND_ID = "org.eclipse.jpt.ui.persistentTypeMapAs";
    public static final String COMMAND_PARAMETER_ID = "persistentTypeMappingKey";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        String mappingKey = event.getParameter(COMMAND_PARAMETER_ID);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            PersistentType type = (PersistentType)item;
            type.setMappingKey(mappingKey);
            ++n2;
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IEvaluationService es = (IEvaluationService)element.getServiceLocator().getService(IEvaluationService.class);
        IViewPart part = (IViewPart)es.getCurrentState().getVariable("activePart");
        IStructuredSelection selection = (IStructuredSelection)part.getSite().getSelectionProvider().getSelection();
        String commonMappingKey = this.commonMappingKey(selection);
        String handlerMappingKey = (String)parameters.get(COMMAND_PARAMETER_ID);
        if (handlerMappingKey != null) {
            element.setChecked(handlerMappingKey.equals(commonMappingKey));
        }
    }

    protected String commonMappingKey(IStructuredSelection selection) {
        String commonKey = null;
        for (Object obj : selection) {
            if (!(obj instanceof PersistentType)) {
                return null;
            }
            PersistentType persistentType = (PersistentType)obj;
            if (commonKey == null) {
                commonKey = persistentType.getMappingKey();
                continue;
            }
            if (commonKey.equals(persistentType.getMappingKey())) continue;
            return null;
        }
        return commonKey;
    }
}

