/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.validation.internal.ConfigurationConstants;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.ValidationConfiguration;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public final class ConfigurationManager
implements ConfigurationConstants {
    private static ConfigurationManager _instance = null;

    private ConfigurationManager() {
    }

    public static ConfigurationManager getManager() {
        if (_instance == null) {
            _instance = new ConfigurationManager();
        }
        return _instance;
    }

    public String getValidator(IMarker marker) {
        Object attrib;
        block6: {
            block5: {
                if (marker == null) {
                    return null;
                }
                try {
                    if (marker.getType().equals("org.eclipse.wst.validation.problemmarker")) break block5;
                    return null;
                }
                catch (CoreException e) {
                    ValidationPlugin.getPlugin().handleException(e);
                    return null;
                }
            }
            attrib = marker.getAttribute("owner");
            if (attrib != null) break block6;
            return null;
        }
        return attrib.toString();
    }

    public boolean isValidationMarker(IMarker marker) {
        if (marker == null) {
            return false;
        }
        try {
            return marker.getType().equals("org.eclipse.wst.validation.problemmarker");
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
            return false;
        }
    }

    public void removeAllValidationMarkers(IProject project) {
        if (project == null || !project.isOpen()) {
            return;
        }
        try {
            project.deleteMarkers("org.eclipse.wst.validation.problemmarker", false, 2);
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    public GlobalConfiguration getGlobalConfiguration() throws InvocationTargetException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        GlobalConfiguration gp = null;
        try {
            gp = (GlobalConfiguration)root.getSessionProperty(USER_PREFERENCE);
            if (gp == null) {
                gp = this.getGlobalConfiguration(root);
            }
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_RETRIEVE", new String[]{root.getName()}));
        }
        return gp;
    }

    private synchronized GlobalConfiguration getGlobalConfiguration(IWorkspaceRoot root) throws InvocationTargetException {
        GlobalConfiguration gp = null;
        try {
            gp = (GlobalConfiguration)root.getSessionProperty(USER_PREFERENCE);
            if (gp == null) {
                gp = new GlobalConfiguration(root);
                Preferences prefs = ValidationPlugin.getPlugin().getPluginPreferences();
                if (prefs != null) {
                    prefs.addPropertyChangeListener((Preferences.IPropertyChangeListener)gp);
                }
                gp.getVersion();
                gp.load();
                gp.passivate();
            }
            return gp;
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_RETRIEVE", new String[]{root.getName()}));
        }
    }

    public ProjectConfiguration getProjectConfiguration(IProject project) throws InvocationTargetException {
        ProjectConfiguration prjp = null;
        try {
            prjp = (ProjectConfiguration)project.getSessionProperty(USER_PREFERENCE);
            if (prjp == null || !prjp.getResource().exists()) {
                prjp = new ProjectConfiguration(project);
                prjp.getVersion();
                prjp.load();
                prjp.passivate();
            }
            return prjp;
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_RETRIEVE", new String[]{project.getName()}));
        }
    }

    public ProjectConfiguration getProjectConfigurationWithoutMigrate(IProject project) throws InvocationTargetException {
        ProjectConfiguration prjp = null;
        try {
            prjp = (ProjectConfiguration)project.getSessionProperty(USER_PREFERENCE);
            if (prjp == null || !prjp.getResource().exists()) {
                prjp = new ProjectConfiguration(project);
                prjp.getVersion();
                prjp.load();
                prjp.passivate();
            }
            return prjp;
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_RETRIEVE", new String[]{project.getName()}));
        }
    }

    public void resetProjectNature(IProject project) throws InvocationTargetException {
    }

    public void closing(IProject project) {
        block3: {
            try {
                ProjectConfiguration prjp;
                if (this.isMigrated(project) && !(prjp = ConfigurationManager.getManager().getProjectConfiguration(project)).useGlobalPreference()) {
                    prjp.store();
                }
            }
            catch (InvocationTargetException e) {
                ValidationPlugin.getPlugin().handleException(e);
                if (e.getTargetException() == null) break block3;
                ValidationPlugin.getPlugin().handleException(e.getTargetException());
            }
        }
    }

    public void deleting(IProject project) {
    }

    public void opening(IProject project) {
    }

    public boolean isGlobalMigrated() throws InvocationTargetException {
        IWorkspaceRoot root = ValidationConfiguration.getRoot();
        if (root == null) {
            return false;
        }
        try {
            GlobalConfiguration gp = (GlobalConfiguration)root.getSessionProperty(USER_PREFERENCE);
            if (gp != null) {
                return gp.isVersionCurrent();
            }
            String serializedPrjp = root.getPersistentProperty(USER_PREFERENCE);
            if (serializedPrjp != null) {
                gp = new GlobalConfiguration(root);
                gp.getVersion();
                return gp.isVersionCurrent();
            }
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_RETRIEVE", new String[]{root.getName()}));
        }
        return false;
    }

    public boolean isMigrated(IProject project) throws InvocationTargetException {
        if (project == null) {
            return false;
        }
        try {
            if (project.isAccessible()) {
                ProjectConfiguration prjp = (ProjectConfiguration)project.getSessionProperty(USER_PREFERENCE);
                if (prjp != null) {
                    return prjp.isVersionCurrent();
                }
                String serializedPrjp = project.getPersistentProperty(USER_PREFERENCE);
                if (serializedPrjp != null) {
                    prjp = new ProjectConfiguration(project);
                    prjp.getVersion();
                    return prjp.isVersionCurrent();
                }
            }
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_RETRIEVE", new String[]{project.getName()}));
        }
        return false;
    }

    public ValidationConfiguration getConfiguration(IProject project) throws InvocationTargetException {
        if (project == null) {
            return this.getGlobalConfiguration();
        }
        ProjectConfiguration pc = this.getProjectConfiguration(project);
        if (pc != null && !pc.useGlobalPreference()) {
            return pc;
        }
        return this.getGlobalConfiguration();
    }
}

