/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.common.internal.provider.CompatibilityDescriptionGroupItemProvider;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.internal.ejb.provider.EJBProviderLibrariesResourceHandler;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;

public class EJBJarItemProvider
extends CompatibilityDescriptionGroupItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public EJBJarItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addEjbClientJarPropertyDescriptor(object);
            this.addVersionPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addEjbClientJarPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), EJBProviderLibrariesResourceHandler.getString("_UI_EJBJar_ejbClientJar_feature"), EJBProviderLibrariesResourceHandler.getString("_UI_EJBJar_ejbClientJar_feature_desc"), (EStructuralFeature)EjbPackage.eINSTANCE.getEJBJar_EjbClientJar(), false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
    }

    protected void addVersionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), EJBProviderLibrariesResourceHandler.getString("_UI_EJBJar_version_feature"), EJBProviderLibrariesResourceHandler.getString("_UI_EJBJar_version_feature_desc"), (EStructuralFeature)EjbPackage.eINSTANCE.getEJBJar_Version(), false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
    }

    public Collection getChildrenReferences(Object object) {
        if (this.childrenReferences == null) {
            super.getChildrenReferences(object);
            this.childrenReferences.add(EjbPackage.eINSTANCE.getEJBJar_AssemblyDescriptor());
            this.childrenReferences.add(EjbPackage.eINSTANCE.getEJBJar_EnterpriseBeans());
            this.childrenReferences.add(EjbPackage.eINSTANCE.getEJBJar_RelationshipList());
        }
        return this.childrenReferences;
    }

    protected EReference getChildReference(Object object, Object child) {
        return super.getChildReference(object, child);
    }

    public void notifyChanged(Notification notification) {
        switch (notification.getFeatureID(EJBJar.class)) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.fireNotifyChanged(notification);
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(EjbPackage.eINSTANCE.getEJBJar_AssemblyDescriptor(), EjbFactory.eINSTANCE.createAssemblyDescriptor()));
        newChildDescriptors.add(this.createChildParameter(EjbPackage.eINSTANCE.getEJBJar_EnterpriseBeans(), EjbFactory.eINSTANCE.createEntity()));
        newChildDescriptors.add(this.createChildParameter(EjbPackage.eINSTANCE.getEJBJar_EnterpriseBeans(), EjbFactory.eINSTANCE.createContainerManagedEntity()));
        newChildDescriptors.add(this.createChildParameter(EjbPackage.eINSTANCE.getEJBJar_EnterpriseBeans(), EjbFactory.eINSTANCE.createSession()));
        newChildDescriptors.add(this.createChildParameter(EjbPackage.eINSTANCE.getEJBJar_EnterpriseBeans(), EjbFactory.eINSTANCE.createMessageDriven()));
        newChildDescriptors.add(this.createChildParameter(EjbPackage.eINSTANCE.getEJBJar_RelationshipList(), EjbFactory.eINSTANCE.createRelationships()));
    }

    public ResourceLocator getResourceLocator() {
        return J2EEPlugin.getDefault();
    }

    public Object getImage(Object object) {
        String key = null;
        if (((EJBJar)object).eResource() == null) {
            return J2EEPlugin.getPlugin().getImage("ejbJar_obj");
        }
        switch (((EJBJar)object).getVersionID()) {
            case 10: {
                key = "10_ejbjar_obj";
                break;
            }
            case 11: {
                key = "11_ejbjar_obj";
                break;
            }
            case 20: {
                key = "20_ejbjar_obj";
                break;
            }
            default: {
                key = "21_ejb_obj";
            }
        }
        return J2EEPlugin.getPlugin().getImage(key);
    }

    public String getText(Object object) {
        EJBJar ejbJar = (EJBJar)object;
        if (ejbJar.getDisplayName() == null) {
            try {
                IProject project = ProjectUtilities.getProject((EObject)ejbJar);
                return project.getDescription().getName();
            }
            catch (Exception exception) {
                Resource resource = ejbJar.eResource();
                if (resource != null) {
                    return new Path(resource.getURI().toString()).removeFileExtension().lastSegment();
                }
                return EJBProviderLibrariesResourceHandler.getString("EJBJar_UI_");
            }
        }
        return ejbJar.getDisplayName();
    }

    public boolean hasChildren(Object parent) {
        if (parent == null) {
            return false;
        }
        return !((EJBJar)parent).getEnterpriseBeans().isEmpty() || ((EJBJar)parent).getAssemblyDescriptor() != null;
    }

    public Collection getChildren(Object object) {
        ArrayList<AssemblyDescriptor> children = new ArrayList<AssemblyDescriptor>();
        EJBJar aJar = (EJBJar)object;
        if (aJar.getAssemblyDescriptor() != null) {
            children.add(aJar.getAssemblyDescriptor());
        }
        if (aJar.getEnterpriseBeans() != null) {
            children.addAll((Collection<AssemblyDescriptor>)aJar.getEnterpriseBeans());
        }
        if (aJar.getRelationshipList() != null && aJar.getRelationshipList().getEjbRelations() != null) {
            children.addAll((Collection<AssemblyDescriptor>)aJar.getRelationshipList().getEjbRelations());
        }
        return children;
    }
}

