/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.contentoutline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeAdapterFactory;
import org.eclipse.wst.xml.ui.internal.contentoutline.RefreshStructureJob;
import org.eclipse.wst.xml.ui.internal.editor.CMImageUtil;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.w3c.dom.Node;

public class JFaceNodeAdapter
implements IJFaceNodeAdapter {
    static final Class ADAPTER_KEY;
    private static final boolean DEBUG;
    JFaceNodeAdapterFactory fAdapterFactory;
    private RefreshStructureJob fRefreshJob = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ADAPTER_KEY = clazz;
        DEBUG = JFaceNodeAdapter.getDebugValue();
    }

    private static boolean getDebugValue() {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/outline");
        boolean result = value != null && value.equalsIgnoreCase("true");
        return result;
    }

    public JFaceNodeAdapter(JFaceNodeAdapterFactory adapterFactory) {
        this.fAdapterFactory = adapterFactory;
    }

    protected Image createImage(Object object) {
        Image image = null;
        Node node = (Node)object;
        switch (node.getNodeType()) {
            case 1: {
                image = this.createXMLImageDescriptor("icons/full/obj16/element_obj.gif");
                break;
            }
            case 2: {
                image = this.createXMLImageDescriptor("icons/full/obj16/attribute_obj.gif");
                break;
            }
            case 3: {
                image = this.createXMLImageDescriptor("icons/full/obj16/text.gif");
                break;
            }
            case 4: {
                image = this.createXMLImageDescriptor("icons/full/obj16/cdatasection.gif");
                break;
            }
            case 5: 
            case 6: {
                image = this.createXMLImageDescriptor("icons/full/obj16/entity.gif");
                break;
            }
            case 7: {
                image = this.createXMLImageDescriptor("icons/full/obj16/proinst_obj.gif");
                break;
            }
            case 8: {
                image = this.createXMLImageDescriptor("icons/full/obj16/comment_obj.gif");
                break;
            }
            case 10: {
                image = this.createXMLImageDescriptor("icons/full/obj16/doctype.gif");
                break;
            }
            case 12: {
                image = this.createXMLImageDescriptor("icons/full/obj16/notation.gif");
                break;
            }
            default: {
                image = this.createXMLImageDescriptor("icons/full/obj16/element_obj.gif");
            }
        }
        return image;
    }

    protected Image createXMLImageDescriptor(String imageResourceName) {
        return XMLEditorPluginImageHelper.getInstance().getImage(imageResourceName);
    }

    public Object[] getChildren(Object object) {
        ArrayList<Node> v = new ArrayList<Node>();
        if (object instanceof Node) {
            Node node = (Node)object;
            Node child = node.getFirstChild();
            while (child != null) {
                Node n = child;
                if (n.getNodeType() != 3) {
                    v.add(n);
                }
                child = child.getNextSibling();
            }
        }
        return v.toArray();
    }

    public Object[] getElements(Object node) {
        return this.getChildren(node);
    }

    public Image getLabelImage(Object node) {
        String nodeName;
        ImageRegistry imageRegistry;
        Image image = null;
        if (node instanceof Node && (image = CMImageUtil.getImage(CMImageUtil.getDeclaration((Node)node))) == null && JFaceResources.getImageRegistry() != null && (image = (imageRegistry = JFaceResources.getImageRegistry()).get(nodeName = this.getNodeName(node))) == null && (image = this.createImage(node)) != null) {
            imageRegistry.put(nodeName, image);
        }
        return image;
    }

    public String getLabelText(Object node) {
        return this.getNodeName(node);
    }

    private String getNodeName(Object object) {
        StringBuffer nodeName = new StringBuffer();
        if (object instanceof Node) {
            Node node = (Node)object;
            nodeName.append(node.getNodeName());
            if (node.getNodeType() == 10) {
                nodeName.insert(0, "DOCTYPE:");
            }
        }
        return nodeName.toString();
    }

    public Object getParent(Object object) {
        if (object instanceof Node) {
            Node node = (Node)object;
            return node.getParentNode();
        }
        return null;
    }

    private synchronized RefreshStructureJob getRefreshJob() {
        if (this.fRefreshJob == null) {
            this.fRefreshJob = new RefreshStructureJob();
        }
        return this.fRefreshJob;
    }

    public boolean hasChildren(Object object) {
        Node node = (Node)object;
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() != 3) {
                return true;
            }
            child = child.getNextSibling();
        }
        return false;
    }

    public boolean isAdapterForType(Object type) {
        if (type == null) {
            return false;
        }
        return type.equals(ADAPTER_KEY);
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (notifier instanceof Node) {
            Collection listeners = this.fAdapterFactory.getListeners();
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                StructuredViewer structuredViewer;
                Object listener = iterator.next();
                if (!(listener instanceof StructuredViewer) || eventType != 4 && eventType != 5 && eventType != 1) continue;
                if (DEBUG) {
                    System.out.println("JFaceNodeAdapter notified on event type > " + eventType);
                }
                if ((structuredViewer = (StructuredViewer)listener).getControl() == null) continue;
                this.getRefreshJob().refresh(structuredViewer, (Node)notifier);
            }
        }
    }
}

