/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.ejb.tests;

import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.javaee.ejb.ActivationConfigProperty;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.InitMethodType;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.RemoveMethodType;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.model.internal.EJBAnnotationReader;
import org.eclipse.jst.jee.model.internal.common.AbstractAnnotationModelProvider;
import org.eclipse.jst.jee.model.tests.AbstractAnnotationModelTest;
import org.eclipse.jst.jee.model.tests.AbstractTest;
import org.eclipse.jst.jee.model.tests.SynchronousModelChangedListener;
import org.eclipse.jst.jee.model.tests.TestUtils;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class EjbAnnotationReaderTest
extends AbstractAnnotationModelTest {
    private static String BEAN_WITH_NAME = "package com.sap;import javax.ejb.Stateless;@Stateless(name=\"%s\") public class BeanWithName implements SessionBeanLocal {}";

    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite(EjbAnnotationReaderTest.class);
        EjbAnnotationReaderTest.setUpProject();
        return suite;
    }

    public static void setUpProject() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(EjbAnnotationReaderTest.class.getSimpleName());
        if (!project.exists()) {
            project = ProjectUtil.createEJBProject(EjbAnnotationReaderTest.class.getSimpleName(), null, 30, true);
            EjbAnnotationReaderTest.createProjectContent(project);
        }
    }

    public static void tearDownAfterClass() throws InterruptedException {
        AbstractTest.deleteProject(EjbAnnotationReaderTest.class.getSimpleName());
    }

    private static void createProjectContent(IProject project) throws Exception {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IFolder comFolder = javaProject.getProject().getFolder("ejbModule/com");
        comFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)comFolder);
        IPackageFragment fragment = root.createPackageFragment("sap", true, (IProgressMonitor)new NullProgressMonitor());
        EjbAnnotationReaderTest.createSessionBean(fragment);
        EjbAnnotationReaderTest.createSessionBeanLocal(fragment);
        EjbAnnotationReaderTest.createBeanWithName(fragment);
        EjbAnnotationReaderTest.createMessageDrivenBean(fragment);
        EjbAnnotationReaderTest.createInvalidCompilationUnit(fragment);
    }

    private static void createBeanWithName(IPackageFragment fragment) throws JavaModelException {
        String content = String.format(BEAN_WITH_NAME, "beanWithName");
        fragment.createCompilationUnit("BeanWithName.java", content, true, null);
    }

    private static void createInvalidCompilationUnit(IPackageFragment fragment) throws Exception {
        IFile file = ((IContainer)fragment.getResource()).getFile((IPath)new Path("InvalidCompilationUnit.java"));
        AbstractTest.saveFile(file, "package com.sap;@Stateless public InvalidCompilationUnit implements SessionBeanLocal {}");
    }

    private static void createMessageDrivenBean(IPackageFragment fragment) throws Exception {
        IFile file = ((IContainer)fragment.getResource()).getFile((IPath)new Path("MessageDrivenBean.java"));
        AbstractTest.saveFile(file, "package com.sap;import javax.ejb.MessageDriven;@MessageDriven public class MessageDrivenBean {}");
    }

    protected void setUp() throws Exception {
        EjbAnnotationReaderTest.setUpProject();
        super.setUp();
        this.fixture = new EJBAnnotationReader(this.facetedProject, this.clientProject);
    }

    protected void tearDown() throws Exception {
        ((AbstractAnnotationModelProvider)this.fixture).dispose();
    }

    public void testCerateReaderWithNullProject() {
        try {
            new EJBAnnotationReader(null, null);
            EjbAnnotationReaderTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testLoadForEmptyProject() throws Exception {
        String projectName = String.valueOf(EjbAnnotationReaderTest.class.getSimpleName()) + "testLoadForEmptyProject";
        IProject emptyProject = ProjectUtil.createEJBProject(projectName, null, 30, true);
        EJBAnnotationReader provider = new EJBAnnotationReader(ProjectFacetsManager.create((IProject)emptyProject), null);
        EJBJar ejbJar = (EJBJar)provider.getModelObject();
        EjbAnnotationReaderTest.assertNull((Object)ejbJar.getEnterpriseBeans());
        AbstractTest.deleteProject(projectName);
    }

    public void testNullEnterpriseBeanAfterDelete() throws Exception {
        String projectName = String.valueOf(EjbAnnotationReaderTest.class.getSimpleName()) + "testNullEnterpriseBeanAfterDelete";
        IProject oneBeanProject = ProjectUtil.createEJBProject(projectName, null, 30, true);
        this.facetedProject = ProjectFacetsManager.create((IProject)oneBeanProject);
        this.fixture = new EJBAnnotationReader(this.facetedProject, this.clientProject);
        IFile beanFile = oneBeanProject.getFile("ejbModule/testNullEnterpriseBeanAfterDelete.java");
        EjbAnnotationReaderTest.assertFalse((boolean)beanFile.exists());
        this.saveFileAndUpdate(beanFile, "import javax.ejb.Stateless;@Stateless public class testNullEnterpriseBeanAfterDelete implements SessionBeanLocal {}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testNullEnterpriseBeanAfterDelete");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        this.deleteFileAndUpdate(beanFile);
        EjbAnnotationReaderTest.assertNull((Object)this.getEJBJar().getEnterpriseBeans());
        AbstractTest.deleteProject(projectName);
    }

    public void testGetSessionBeans() {
        EnterpriseBeans beans = this.getEJBJar().getEnterpriseBeans();
        EjbAnnotationReaderTest.assertNotNull((Object)beans);
        EjbAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(beans.getSessionBeans().size()));
        EjbAnnotationReaderTest.assertEquals((Object)new Integer(1), (Object)new Integer(this.getEJBJar().getEnterpriseBeans().getMessageDrivenBeans().size()));
    }

    public void testSessionBeanName() {
        this.getEJBJar().getEnterpriseBeans().getSessionBeans();
        SessionBean bean = TestUtils.getSessionBean(this.getEJBJar(), "SessionBean");
        EjbAnnotationReaderTest.assertEquals((String)"com.sap.SessionBean", (String)bean.getEjbClass());
        EjbAnnotationReaderTest.assertEquals((String)"SessionBean", (String)bean.getEjbName());
    }

    public void testMessageDrivenBean() {
        MessageDrivenBean bean = TestUtils.getMessageDrivenBean(this.getEJBJar(), "MessageDrivenBean");
        EjbAnnotationReaderTest.assertNotNull((Object)bean);
        EjbAnnotationReaderTest.assertEquals((String)"com.sap.MessageDrivenBean", (String)bean.getEjbClass());
        EjbAnnotationReaderTest.assertEquals((String)"MessageDrivenBean", (String)bean.getEjbName());
    }

    public void testBeanWithName() {
        SessionBean bean = TestUtils.getSessionBean(this.getEJBJar(), "beanWithName");
        EjbAnnotationReaderTest.assertNotNull((Object)bean);
        EjbAnnotationReaderTest.assertEquals((String)"com.sap.BeanWithName", (String)bean.getEjbClass());
        EjbAnnotationReaderTest.assertEquals((String)"beanWithName", (String)bean.getEjbName());
    }

    public void testChange() throws Exception {
        IFile file = this.facetedProject.getProject().getFile("ejbModule/com/sap/BeanWithName.java");
        String newContent = String.format(BEAN_WITH_NAME, "newBeanName");
        this.saveFileAndUpdate(file, newContent);
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "newBeanName");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        String oldContent = String.format(BEAN_WITH_NAME, "beanWithName");
        this.saveFileAndUpdate(file, oldContent);
        EjbAnnotationReaderTest.assertNotNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "beanWithName"));
    }

    public void testDeleteBean() throws Exception {
        IFile file = this.facetedProject.getProject().getFile("ejbModule/com/sap/BeanWithName.java");
        this.deleteFileAndUpdate(file);
        EjbAnnotationReaderTest.assertEquals((Object)new Integer(1), (Object)new Integer(this.getEJBJar().getEnterpriseBeans().getSessionBeans().size()));
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "beanWithName"));
        String content = String.format(BEAN_WITH_NAME, "beanWithName");
        this.saveFileAndUpdate(file, content);
        EjbAnnotationReaderTest.assertNotNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "beanWithName"));
    }

    public void testAddDeleteSessionBean() throws Exception {
        int oldSize = this.getEJBJar().getEnterpriseBeans().getSessionBeans().size();
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testAddDeleteSessionBean.java");
        EjbAnnotationReaderTest.assertFalse((boolean)beanFile.exists());
        this.saveFileAndUpdate(beanFile, "package com.sap;import javax.ejb.Stateless;@Stateless public class testAddDeleteSessionBean implements SessionBeanLocal {}");
        EjbAnnotationReaderTest.assertEquals((Object)new Integer(oldSize + 1), (Object)new Integer(this.getEJBJar().getEnterpriseBeans().getSessionBeans().size()));
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteSessionBean");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        this.deleteFileAndUpdate(beanFile);
        EjbAnnotationReaderTest.assertEquals((Object)new Integer(oldSize), (Object)new Integer(this.getEJBJar().getEnterpriseBeans().getSessionBeans().size()));
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteSessionBean"));
    }

    public void testEventsNumber1() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testEventsNumber1.java");
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        this.getFixture().addListener((IModelProviderListener)listener);
        this.saveFileAndUpdate(beanFile, "package com.sap;import javax.ejb.Stateless;@Stateless public class testEventsNumber1 implements SessionBeanLocal {}");
        EjbAnnotationReaderTest.assertTrue((boolean)listener.waitForEvents());
        this.getFixture().removeListener((IModelProviderListener)listener);
        EjbAnnotationReaderTest.assertEquals((Object)new Integer(1), (Object)new Integer(listener.getReceivedEvents().size()));
    }

    public void testEventsNumber2() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testEventsNumber2.java");
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(2);
        this.getFixture().addListener((IModelProviderListener)listener);
        this.saveFileAndUpdate(beanFile, "package com.sap;import javax.ejb.Stateless;@Stateless public class testEventsNumber2 implements SessionBeanLocal {}");
        EjbAnnotationReaderTest.assertFalse((boolean)listener.waitForEvents());
        this.getFixture().removeListener((IModelProviderListener)listener);
        EjbAnnotationReaderTest.assertEquals((Object)new Integer(1), (Object)new Integer(listener.getReceivedEvents().size()));
    }

    public void testDispose() throws Exception {
        EJBAnnotationReader reader = new EJBAnnotationReader(this.facetedProject, null);
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        reader.addListener((IModelProviderListener)listener);
        reader.dispose();
        EjbAnnotationReaderTest.assertTrue((boolean)listener.waitForEvents());
    }

    public void testAddBeanThenInterface() throws Exception {
        int oldSize = this.getEJBJar().getEnterpriseBeans().getSessionBeans().size();
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testAddBeanThenInterface.java");
        IFile interfaceFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/InterfaceForAddedBean.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;import javax.ejb.Stateless;@Stateless public class testAddBeanThenInterface implements InterfaceForAddedBean {}");
        EjbAnnotationReaderTest.assertEquals((Object)new Integer(oldSize + 1), (Object)new Integer(this.getEJBJar().getEnterpriseBeans().getSessionBeans().size()));
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testAddBeanThenInterface");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        EjbAnnotationReaderTest.assertEquals((Object)"InterfaceForAddedBean", result.getBusinessLocals().get(0));
        this.saveFileAndUpdate(interfaceFile, "package com.sap;public interface InterfaceForAddedBean {} ");
        EjbAnnotationReaderTest.assertEquals((Object)new Integer(oldSize + 1), (Object)new Integer(this.getEJBJar().getEnterpriseBeans().getSessionBeans().size()));
        result = TestUtils.getSessionBean(this.getEJBJar(), "testAddBeanThenInterface");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        EjbAnnotationReaderTest.assertEquals((Object)"com.sap.InterfaceForAddedBean", result.getBusinessLocals().get(0));
        this.deleteFileAndUpdate(beanFile);
        AbstractTest.deleteFile(interfaceFile);
    }

    public void testAddBeanThenInterfaceThenRemote() throws Exception {
        int oldSize = this.getEJBJar().getEnterpriseBeans().getSessionBeans().size();
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testAddBeanThenInterfaceThenRemote.java");
        IFile interfaceFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/InterfaceForAddedBean.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;import javax.ejb.Stateless;@Stateless public class testAddBeanThenInterfaceThenRemote implements InterfaceForAddedBean {}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testAddBeanThenInterfaceThenRemote");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        EjbAnnotationReaderTest.assertEquals((Object)new Integer(oldSize + 1), (Object)new Integer(this.getEJBJar().getEnterpriseBeans().getSessionBeans().size()));
        EjbAnnotationReaderTest.assertEquals((Object)"InterfaceForAddedBean", result.getBusinessLocals().get(0));
        this.saveFileAndUpdate(interfaceFile, "package com.sap;public interface InterfaceForAddedBean {} ");
        result = TestUtils.getSessionBean(this.getEJBJar(), "testAddBeanThenInterfaceThenRemote");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        EjbAnnotationReaderTest.assertEquals((Object)new Integer(oldSize + 1), (Object)new Integer(this.getEJBJar().getEnterpriseBeans().getSessionBeans().size()));
        EjbAnnotationReaderTest.assertEquals((Object)"com.sap.InterfaceForAddedBean", result.getBusinessLocals().get(0));
        EjbAnnotationReaderTest.assertTrue((boolean)result.getBusinessRemotes().isEmpty());
        this.saveFileAndUpdate(interfaceFile, "package com.sap;import javax.ejb.Remote@Remote public interface InterfaceForAddedBean {} ");
        result = TestUtils.getSessionBean(this.getEJBJar(), "testAddBeanThenInterfaceThenRemote");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        EjbAnnotationReaderTest.assertEquals((Object)new Integer(oldSize + 1), (Object)new Integer(this.getEJBJar().getEnterpriseBeans().getSessionBeans().size()));
        EjbAnnotationReaderTest.assertEquals((Object)"com.sap.InterfaceForAddedBean", result.getBusinessRemotes().get(0));
        EjbAnnotationReaderTest.assertTrue((boolean)result.getBusinessLocals().isEmpty());
        this.deleteFileAndUpdate(beanFile);
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testAddBeanThenInterfaceThenRemote"));
        AbstractTest.deleteFile(interfaceFile);
    }

    public void testAddBeanThenRemoteThenLocal() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testAddBeanThenRemoteThenLocal.java");
        IFile interfaceFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/InterfaceForAddedBean.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;import javax.ejb.Stateless;@Stateless public class testAddBeanThenRemoteThenLocal implements InterfaceForAddedBean {}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testAddBeanThenRemoteThenLocal");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        EjbAnnotationReaderTest.assertEquals((Object)"InterfaceForAddedBean", result.getBusinessLocals().get(0));
        this.saveFileAndUpdate(interfaceFile, "package com.sap;@Remote public interface InterfaceForAddedBean {} ");
        result = TestUtils.getSessionBean(this.getEJBJar(), "testAddBeanThenRemoteThenLocal");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        EjbAnnotationReaderTest.assertEquals((Object)"com.sap.InterfaceForAddedBean", result.getBusinessRemotes().get(0));
        EjbAnnotationReaderTest.assertTrue((boolean)result.getBusinessLocals().isEmpty());
        this.saveFileAndUpdate(interfaceFile, "package com.sap;import javax.ejb.Remote@Local public interface InterfaceForAddedBean {} ");
        result = TestUtils.getSessionBean(this.getEJBJar(), "testAddBeanThenRemoteThenLocal");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        EjbAnnotationReaderTest.assertEquals((Object)"com.sap.InterfaceForAddedBean", result.getBusinessLocals().get(0));
        EjbAnnotationReaderTest.assertTrue((boolean)result.getBusinessRemotes().isEmpty());
        this.deleteFileAndUpdate(beanFile);
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testAddBeanThenRemoteThenLocal"));
        AbstractTest.deleteFile(interfaceFile);
    }

    public void testAdd2BeansThenInterfaceThenRemote() throws InterruptedException, Exception {
        IFile bean1File = this.facetedProject.getProject().getFile("ejbModule/com/sap/testAdd2BeansThenInterfaceThenRemote1.java");
        IFile bean2File = this.facetedProject.getProject().getFile("ejbModule/com/sap/testAdd2BeansThenInterfaceThenRemote2.java");
        IFile interfaceFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/InterfaceForAddedBean.java");
        this.saveFileAndUpdate(bean1File, "package com.sap;import javax.ejb.Stateless;@Stateless public class testAdd2BeansThenInterfaceThenRemote1 implements InterfaceForAddedBean {}");
        this.saveFileAndUpdate(bean2File, "package com.sap;import javax.ejb.Stateless;@Stateless public class testAdd2BeansThenInterfaceThenRemote2 implements InterfaceForAddedBean {}");
        SessionBean result1 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote1");
        EjbAnnotationReaderTest.assertEquals((Object)"InterfaceForAddedBean", result1.getBusinessLocals().get(0));
        SessionBean result2 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote2");
        EjbAnnotationReaderTest.assertEquals((Object)"InterfaceForAddedBean", result2.getBusinessLocals().get(0));
        this.saveFileAndUpdate(interfaceFile, "package com.sap;public interface InterfaceForAddedBean {} ");
        this.saveFileAndUpdate(interfaceFile, "package com.sap;import javax.ejb.Remote@Remote public interface InterfaceForAddedBean {} ");
        result1 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote1");
        EjbAnnotationReaderTest.assertEquals((Object)"com.sap.InterfaceForAddedBean", result1.getBusinessRemotes().get(0));
        result2 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote2");
        EjbAnnotationReaderTest.assertEquals((Object)"com.sap.InterfaceForAddedBean", result2.getBusinessRemotes().get(0));
        EjbAnnotationReaderTest.assertTrue((boolean)result1.getBusinessLocals().isEmpty());
        EjbAnnotationReaderTest.assertTrue((boolean)result2.getBusinessLocals().isEmpty());
        this.deleteFileAndUpdate(bean1File);
        this.deleteFileAndUpdate(bean2File);
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote1"));
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote2"));
        AbstractTest.deleteFile(interfaceFile);
    }

    public void testBeanWithSourceAndBinaryInterface() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testBeanWithSourceAndBinaryInterface.java");
        this.saveFileAndUpdate(beanFile, "package com.sap; @Stateless @Local({java.util.List.class, SessionBeanLocal.class}) public class testBeanWithSourceAndBinaryInterface {}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testBeanWithSourceAndBinaryInterface");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        EjbAnnotationReaderTest.assertTrue((boolean)result.getBusinessLocals().contains("com.sap.SessionBeanLocal"));
        EjbAnnotationReaderTest.assertTrue((boolean)result.getBusinessLocals().contains("java.util.List"));
        this.deleteFileAndUpdate(beanFile);
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testBeanWithSourceAndBinaryInterface"));
    }

    public void testAddDeleteMessageBean() throws Exception {
        int oldSize = this.getEJBJar().getEnterpriseBeans().getMessageDrivenBeans().size();
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        IFile file = this.facetedProject.getProject().getFile("ejbModule/com/sap/AddedMessageBean.java");
        EjbAnnotationReaderTest.assertFalse((boolean)file.exists());
        this.getFixture().addListener((IModelProviderListener)listener);
        AbstractTest.saveFile(file, "package com.sap;import javax.ejb.MessageDriven;@MessageDriven public class AddedMessageBean {}");
        EjbAnnotationReaderTest.assertTrue((boolean)listener.waitForEvents());
        this.getFixture().removeListener((IModelProviderListener)listener);
        EjbAnnotationReaderTest.assertEquals((Object)new Integer(oldSize + 1), (Object)new Integer(this.getEJBJar().getEnterpriseBeans().getMessageDrivenBeans().size()));
        MessageDrivenBean result = TestUtils.getMessageDrivenBean(this.getEJBJar(), "AddedMessageBean");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        listener = new SynchronousModelChangedListener(1);
        this.getFixture().addListener((IModelProviderListener)listener);
        AbstractTest.deleteFile(file);
        EjbAnnotationReaderTest.assertTrue((boolean)listener.waitForEvents());
        this.getFixture().removeListener((IModelProviderListener)listener);
        EjbAnnotationReaderTest.assertEquals((Object)new Integer(oldSize), (Object)new Integer(this.getEJBJar().getEnterpriseBeans().getMessageDrivenBeans().size()));
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getMessageDrivenBean(this.getEJBJar(), "AddedMessageBean"));
    }

    public void testAddDeleteLocalHome() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testAddDeleteLocalHome.java");
        this.saveFileAndUpdate(beanFile, "package com.sap; @Stateless @LocalHome(value = LocalHomeInterface.class) public class testAddDeleteLocalHome {}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteLocalHome");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        EjbAnnotationReaderTest.assertEquals((String)"LocalHomeInterface", (String)result.getLocalHome());
        IFile interfaceFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/LocalHomeInterface.java");
        this.saveFileAndUpdate(interfaceFile, "package com.sap; public interface LocalHomeInterface {}");
        result = TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteLocalHome");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        EjbAnnotationReaderTest.assertEquals((String)"com.sap.LocalHomeInterface", (String)result.getLocalHome());
        this.deleteFileAndUpdate(interfaceFile);
        result = TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteLocalHome");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        EjbAnnotationReaderTest.assertEquals((String)"LocalHomeInterface", (String)result.getLocalHome());
        this.deleteFileAndUpdate(beanFile);
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteLocalHome"));
    }

    public void testAddDeleteHome() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testAddDeleteHome.java");
        this.saveFileAndUpdate(beanFile, "package com.sap; import javax.ejb.RemoteHome;@Stateless @RemoteHome(value = HomeInterface.class) public class testAddDeleteHome {}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteHome");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        EjbAnnotationReaderTest.assertEquals((String)"HomeInterface", (String)result.getHome());
        IFile interfaceFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/HomeInterface.java");
        this.saveFileAndUpdate(interfaceFile, "package com.sap; public interface HomeInterface {}");
        result = TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteHome");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        EjbAnnotationReaderTest.assertEquals((String)"com.sap.HomeInterface", (String)result.getHome());
        this.deleteFileAndUpdate(interfaceFile);
        result = TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteHome");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        EjbAnnotationReaderTest.assertEquals((String)"HomeInterface", (String)result.getHome());
        this.deleteFileAndUpdate(beanFile);
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteHome"));
    }

    public void testRemoveMethod() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testRemoveMethod.java");
        this.saveFileAndUpdate(beanFile, "package com.sap@Stateful public class testRemoveMethod implements SessionBeanLocal {@Remove public void removeMethod1() {}@Remove(retainIfException = true) public void removeMethod2() {}@Remove(retainIfException = true) public void removeMethodParam(java.lang.String str) {}}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testRemoveMethod");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        RemoveMethodType method1 = TestUtils.findRemoveMethodByName(result, "removeMethod1");
        RemoveMethodType method2 = TestUtils.findRemoveMethodByName(result, "removeMethod2");
        EjbAnnotationReaderTest.assertNotNull((Object)method1);
        EjbAnnotationReaderTest.assertNotNull((Object)method2);
        EjbAnnotationReaderTest.assertFalse((boolean)method1.isRetainIfException());
        EjbAnnotationReaderTest.assertTrue((boolean)method2.isRetainIfException());
        EjbAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getRemoveMethods().size()));
        this.deleteFileAndUpdate(beanFile);
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testRemoveMethod"));
    }

    public void testRemoveMethodOnStateless() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testRemoveMethodOnStateless.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@Stateless public class testRemoveMethodOnStateless implements SessionBeanLocal {@Remove public void removeMethod1() {}}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testRemoveMethodOnStateless");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        EjbAnnotationReaderTest.assertTrue((boolean)result.getRemoveMethods().isEmpty());
        this.deleteFileAndUpdate(beanFile);
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testRemoveMethodOnStateless"));
    }

    public void testInitMetod() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testInitMetod.java");
        this.saveFileAndUpdate(beanFile, "package com.sap@Stateful @RemoteHome(value = java.lang.Comparable.class) public class testInitMetod implements SessionBeanLocal {@Init public void createMethod1() {}@Init public void createMethod2(String arg0) {}}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testInitMetod");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        InitMethodType method1 = TestUtils.findInitMethodByName(result, "createMethod1");
        EjbAnnotationReaderTest.assertNotNull((Object)method1);
        InitMethodType method2 = TestUtils.findInitMethodByName(result, "createMethod2");
        EjbAnnotationReaderTest.assertNotNull((Object)method2);
        EjbAnnotationReaderTest.assertEquals((Object)new Integer(1), (Object)new Integer(method2.getBeanMethod().getMethodParams().getMethodParams().size()));
        EjbAnnotationReaderTest.assertEquals((String)"String", (String)method2.getBeanMethod().getMethodParams().getMethodParams().get(0).toString());
        EjbAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getInitMethods().size()));
        this.deleteFileAndUpdate(beanFile);
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testInitMethod"));
    }

    public void testInitMetodStateless() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testInitMetodStateless.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@Stateless @RemoteHome(value = java.lang.Comparable.class) public class testInitMetodStateless implements SessionBeanLocal {@Init public void createMethod1() {}@Init public void createMethod2(String arg0) {}}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testInitMetodStateless");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        EjbAnnotationReaderTest.assertEquals((Object)new Integer(0), (Object)new Integer(result.getInitMethods().size()));
        this.deleteFileAndUpdate(beanFile);
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testInitMetodStateless"));
    }

    public void testActivationConfigProperty() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testActivationConfigProperty.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@MessageDriven(activationConfig = { @ActivationConfigProperty(propertyName = \"name1\", propertyValue = \"value1\"),@ActivationConfigProperty(propertyName = \"name2\", propertyValue = \"value2\") })public class testActivationConfigProperty {}");
        MessageDrivenBean result = TestUtils.getMessageDrivenBean(this.getEJBJar(), "testActivationConfigProperty");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        ActivationConfigProperty property1 = TestUtils.findActivationConfigProperty(result, "name1");
        ActivationConfigProperty property2 = TestUtils.findActivationConfigProperty(result, "name2");
        EjbAnnotationReaderTest.assertEquals((String)"value1", (String)property1.getActivationConfigPropertyValue());
        EjbAnnotationReaderTest.assertEquals((String)"value2", (String)property2.getActivationConfigPropertyValue());
        EjbAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getActivationConfig().getActivationConfigProperties().size()));
        this.deleteFileAndUpdate(beanFile);
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testActivationConfigProperty"));
    }

    public void testMoveBeanFile() throws Exception {
        IFile file = this.facetedProject.getProject().getFile("ejbModule/com/sap/testMoveBeanFile.java");
        this.saveFileAndUpdate(file, "package com.sap;import javax.ejb.Stateless;@Stateless public class testMoveBeanFile implements\t\t SessionBeanLocal {}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testMoveBeanFile");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        this.getFixture().addListener((IModelProviderListener)listener);
        file.move(this.facetedProject.getProject().getFullPath().append("testMoveBeanFile.java"), true, (IProgressMonitor)new NullProgressMonitor());
        EjbAnnotationReaderTest.assertTrue((boolean)listener.waitForEvents());
        this.getFixture().removeListener((IModelProviderListener)listener);
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testMoveBeanFile"));
        AbstractTest.deleteFile(this.facetedProject.getProject().getFile("testMoveBeanFile.java"));
    }

    public void testMoveBeanFileToMetainf() throws Exception {
        IFile file = this.facetedProject.getProject().getFile("ejbModule/com/sap/testMoveBeanFileToMetainf.java");
        this.saveFileAndUpdate(file, "package com.sap;import javax.ejb.Stateless;@Stateless public class testMoveBeanFileToMetainf implements SessionBeanLocal {}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testMoveBeanFileToMetainf");
        EjbAnnotationReaderTest.assertNotNull((Object)result);
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        this.getFixture().addListener((IModelProviderListener)listener);
        IFolder metainfFolder = this.facetedProject.getProject().getFolder("ejbModule/META-INF");
        file.move(metainfFolder.getFullPath().append("testMoveBeanFileToMetainf.java"), true, (IProgressMonitor)new NullProgressMonitor());
        EjbAnnotationReaderTest.assertTrue((boolean)listener.waitForEvents());
        this.getFixture().removeListener((IModelProviderListener)listener);
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testMoveBeanFileToMetainf"));
        AbstractTest.deleteFile(this.facetedProject.getProject().getFile("ejbModule/META-INF/testMoveBeanFileToMetainf.java"));
    }

    public void testAdd2BeansThenInterfaceThenRemoteThenOverrideWithLocal() throws InterruptedException, Exception {
        IFile bean1File = this.facetedProject.getProject().getFile("ejbModule/com/sap/testAdd2BeansThenInterfaceThenRemote1.java");
        IFile bean2File = this.facetedProject.getProject().getFile("ejbModule/com/sap/testAdd2BeansThenInterfaceThenRemote2.java");
        IFile interfaceFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/InterfaceForAddedBean.java");
        this.saveFileAndUpdate(bean1File, "package com.sap;import javax.ejb.Stateless;@Stateless public class testAdd2BeansThenInterfaceThenRemote1 implements InterfaceForAddedBean {}");
        this.saveFileAndUpdate(bean2File, "package com.sap;import javax.ejb.Stateless;@Stateless public class testAdd2BeansThenInterfaceThenRemote2 implements InterfaceForAddedBean {}");
        SessionBean result1 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote1");
        EjbAnnotationReaderTest.assertEquals((Object)"InterfaceForAddedBean", result1.getBusinessLocals().get(0));
        SessionBean result2 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote2");
        EjbAnnotationReaderTest.assertEquals((Object)"InterfaceForAddedBean", result2.getBusinessLocals().get(0));
        this.saveFileAndUpdate(interfaceFile, "package com.sap;public interface InterfaceForAddedBean {} ");
        this.saveFileAndUpdate(interfaceFile, "package com.sap;import javax.ejb.Remote@Remote public interface InterfaceForAddedBean {} ");
        result1 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote1");
        EjbAnnotationReaderTest.assertEquals((Object)"com.sap.InterfaceForAddedBean", result1.getBusinessRemotes().get(0));
        result2 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote2");
        EjbAnnotationReaderTest.assertEquals((Object)"com.sap.InterfaceForAddedBean", result2.getBusinessRemotes().get(0));
        EjbAnnotationReaderTest.assertTrue((boolean)result1.getBusinessLocals().isEmpty());
        EjbAnnotationReaderTest.assertTrue((boolean)result2.getBusinessLocals().isEmpty());
        this.saveFileAndUpdate(bean1File, "package com.sap;import javax.ejb.Stateless;@Stateless @Local({InterfaceForAddedBean.class}) public class testAdd2BeansThenInterfaceThenRemote1 implements InterfaceForAddedBean {}");
        result1 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote1");
        EjbAnnotationReaderTest.assertEquals((Object)"com.sap.InterfaceForAddedBean", result1.getBusinessLocals().get(0));
        EjbAnnotationReaderTest.assertTrue((boolean)result1.getBusinessRemotes().isEmpty());
        this.deleteFileAndUpdate(bean1File);
        this.deleteFileAndUpdate(bean2File);
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote1"));
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote2"));
        AbstractTest.deleteFile(interfaceFile);
    }

    public void testAdd2BeansThenInterfaceThenLocalThenOverrideWithRemote() throws InterruptedException, Exception {
        IFile bean1File = this.facetedProject.getProject().getFile("ejbModule/com/sap/testAdd2BeansThenInterfaceThenRemote1.java");
        IFile bean2File = this.facetedProject.getProject().getFile("ejbModule/com/sap/testAdd2BeansThenInterfaceThenRemote2.java");
        IFile interfaceFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/InterfaceForAddedBean.java");
        this.saveFileAndUpdate(bean1File, "package com.sap;import javax.ejb.Stateless;@Stateless public class testAdd2BeansThenInterfaceThenRemote1 implements InterfaceForAddedBean {}");
        this.saveFileAndUpdate(bean2File, "package com.sap;import javax.ejb.Stateless;@Stateless public class testAdd2BeansThenInterfaceThenRemote2 implements InterfaceForAddedBean {}");
        SessionBean result1 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote1");
        EjbAnnotationReaderTest.assertEquals((Object)"InterfaceForAddedBean", result1.getBusinessLocals().get(0));
        SessionBean result2 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote2");
        EjbAnnotationReaderTest.assertEquals((Object)"InterfaceForAddedBean", result2.getBusinessLocals().get(0));
        this.saveFileAndUpdate(interfaceFile, "package com.sap;public interface InterfaceForAddedBean {} ");
        this.saveFileAndUpdate(bean1File, "package com.sap;import javax.ejb.Stateless;@Stateless @Remote({InterfaceForAddedBean.class}) public class testAdd2BeansThenInterfaceThenRemote1 implements InterfaceForAddedBean {}");
        result1 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote1");
        EjbAnnotationReaderTest.assertEquals((Object)"com.sap.InterfaceForAddedBean", result1.getBusinessRemotes().get(0));
        EjbAnnotationReaderTest.assertTrue((boolean)result1.getBusinessLocals().isEmpty());
        this.deleteFileAndUpdate(bean1File);
        this.deleteFileAndUpdate(bean2File);
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote1"));
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote2"));
        AbstractTest.deleteFile(interfaceFile);
    }

    public void testAdd2BeansThenInterfaceThenLocalThenOverrideWithLocal() throws InterruptedException, Exception {
        IFile bean1File = this.facetedProject.getProject().getFile("ejbModule/com/sap/testAdd2BeansThenInterfaceThenRemote1.java");
        IFile bean2File = this.facetedProject.getProject().getFile("ejbModule/com/sap/testAdd2BeansThenInterfaceThenRemote2.java");
        IFile interfaceFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/InterfaceForAddedBean.java");
        this.saveFileAndUpdate(bean1File, "package com.sap;import javax.ejb.Stateless;@Stateless public class testAdd2BeansThenInterfaceThenRemote1 implements InterfaceForAddedBean {}");
        this.saveFileAndUpdate(bean2File, "package com.sap;import javax.ejb.Stateless;@Stateless public class testAdd2BeansThenInterfaceThenRemote2 implements InterfaceForAddedBean {}");
        SessionBean result1 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote1");
        EjbAnnotationReaderTest.assertEquals((Object)"InterfaceForAddedBean", result1.getBusinessLocals().get(0));
        SessionBean result2 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote2");
        EjbAnnotationReaderTest.assertEquals((Object)"InterfaceForAddedBean", result2.getBusinessLocals().get(0));
        this.saveFileAndUpdate(interfaceFile, "package com.sap;public interface InterfaceForAddedBean {} ");
        this.saveFileAndUpdate(bean1File, "package com.sap;import javax.ejb.Stateless;@Stateless @Local({InterfaceForAddedBean.class}) public class testAdd2BeansThenInterfaceThenRemote1 implements InterfaceForAddedBean {}");
        result1 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote1");
        EjbAnnotationReaderTest.assertEquals((Object)"com.sap.InterfaceForAddedBean", result1.getBusinessLocals().get(0));
        EjbAnnotationReaderTest.assertTrue((boolean)result1.getBusinessRemotes().isEmpty());
        this.deleteFileAndUpdate(bean1File);
        this.deleteFileAndUpdate(bean2File);
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote1"));
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote2"));
        AbstractTest.deleteFile(interfaceFile);
    }

    public void testAdd2BeansThenInterfaceThenRemoteThenOverrideWithRemote() throws InterruptedException, Exception {
        IFile bean1File = this.facetedProject.getProject().getFile("ejbModule/com/sap/testAdd2BeansThenInterfaceThenRemote1.java");
        IFile bean2File = this.facetedProject.getProject().getFile("ejbModule/com/sap/testAdd2BeansThenInterfaceThenRemote2.java");
        IFile interfaceFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/InterfaceForAddedBean.java");
        this.saveFileAndUpdate(bean1File, "package com.sap;import javax.ejb.Stateless;@Stateless public class testAdd2BeansThenInterfaceThenRemote1 implements InterfaceForAddedBean {}");
        this.saveFileAndUpdate(bean2File, "package com.sap;import javax.ejb.Stateless;@Stateless public class testAdd2BeansThenInterfaceThenRemote2 implements InterfaceForAddedBean {}");
        SessionBean result1 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote1");
        EjbAnnotationReaderTest.assertEquals((Object)"InterfaceForAddedBean", result1.getBusinessLocals().get(0));
        SessionBean result2 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote2");
        EjbAnnotationReaderTest.assertEquals((Object)"InterfaceForAddedBean", result2.getBusinessLocals().get(0));
        this.saveFileAndUpdate(interfaceFile, "package com.sap;public interface InterfaceForAddedBean {} ");
        this.saveFileAndUpdate(interfaceFile, "package com.sap;import javax.ejb.Remote@Remote public interface InterfaceForAddedBean {} ");
        result1 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote1");
        EjbAnnotationReaderTest.assertEquals((Object)"com.sap.InterfaceForAddedBean", result1.getBusinessRemotes().get(0));
        result2 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote2");
        EjbAnnotationReaderTest.assertEquals((Object)"com.sap.InterfaceForAddedBean", result2.getBusinessRemotes().get(0));
        EjbAnnotationReaderTest.assertTrue((boolean)result1.getBusinessLocals().isEmpty());
        EjbAnnotationReaderTest.assertTrue((boolean)result2.getBusinessLocals().isEmpty());
        this.saveFileAndUpdate(bean1File, "package com.sap;import javax.ejb.Stateless;@Stateless @Remote({InterfaceForAddedBean.class}) public class testAdd2BeansThenInterfaceThenRemote1 implements InterfaceForAddedBean {}");
        result1 = TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote1");
        EjbAnnotationReaderTest.assertEquals((Object)"com.sap.InterfaceForAddedBean", result1.getBusinessRemotes().get(0));
        EjbAnnotationReaderTest.assertTrue((boolean)result1.getBusinessLocals().isEmpty());
        this.deleteFileAndUpdate(bean1File);
        this.deleteFileAndUpdate(bean2File);
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote1"));
        EjbAnnotationReaderTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testAdd2BeansThenInterfaceThenRemote2"));
        AbstractTest.deleteFile(interfaceFile);
    }
}

