/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.tests;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.model.IModelProviderListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronousModelChangedListener
implements IModelProviderListener {
    private final Semaphore s;
    private final int expectedEvents;
    private final Collection<IModelProviderEvent> receivedEvents;

    public SynchronousModelChangedListener(int expectedEvents) throws InterruptedException {
        this.expectedEvents = expectedEvents;
        this.s = new Semaphore(1);
        this.s.acquire();
        this.receivedEvents = Collections.synchronizedList(new LinkedList());
    }

    public boolean waitForEvents() throws InterruptedException {
        return this.s.tryAcquire(5L, TimeUnit.SECONDS);
    }

    public Collection<IModelProviderEvent> getReceivedEvents() {
        return this.receivedEvents;
    }

    public synchronized void modelsChanged(IModelProviderEvent event) {
        try {
            this.receivedEvents.add(event);
            if (this.receivedEvents.size() > this.expectedEvents) {
                throw new IllegalStateException("The expected events were already reached <" + this.dumpEvent(event) + ">");
            }
        }
        finally {
            if (this.expectedEvents == this.receivedEvents.size()) {
                this.s.release();
            }
        }
    }

    private String dumpEvent(IModelProviderEvent event) {
        StringBuilder builder = new StringBuilder();
        builder.append("Event for project <" + event.getProject() + "> with changed resources: \r\n");
        for (Object resource : event.getChangedResources()) {
            builder.append(resource + "\r\n");
        }
        return builder.toString();
    }
}

