/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.j2ee.verifiers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.Assert;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.tests.AssertWarn;
import org.eclipse.wst.common.tests.DataModelVerifier;
import org.eclipse.wst.common.tests.ProjectUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JEEImportDataModelVerifier
extends DataModelVerifier {
    private static final String CLASS_EXTENSION = "class";
    private static final String JAVA_EXTENSION = "java";
    private static final String JAR_EXTENSION = "jar";
    private static final String RAR_EXTENSION = "rar";
    private static final String WAR_EXTENSION = "war";
    protected IDataModel model;
    protected IProject project;
    protected final String DOT_CLASS = ".class";
    protected final String DOT_JAVA = ".java";

    public void verify(IDataModel model) throws Exception {
        super.verify(model);
        this.model = model;
        String projectName = model.getStringProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME");
        this.project = ProjectUtility.getProject((String)projectName);
        this.verifyProjectCreated();
        String archivePath = model.getStringProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME");
        IArchive archive = null;
        try {
            archive = JavaEEArchiveUtilities.INSTANCE.openArchive((IPath)new Path(archivePath));
            this.verifyImportedProjectTypeAndVersion(archive);
            this.verifyAllFilesImported(archive);
        }
        finally {
            if (archive != null && archive.isOpen()) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(archive);
            }
        }
    }

    public void verify(IDataModel nestedArchiveImportModel, IArchive importedNestedArchive) throws Exception {
        this.model = nestedArchiveImportModel;
        String projectName = this.model.getStringProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME");
        this.project = ProjectUtility.getProject((String)projectName);
        this.verifyProjectCreated();
        this.verifyImportedProjectTypeAndVersion(importedNestedArchive);
        this.verifyAllFilesImported(importedNestedArchive);
    }

    protected abstract int getExportType();

    private void verifyImportedProjectTypeAndVersion(IArchive archive) throws Exception {
        if (J2EEProjectUtilities.isUtilityProject((IProject)this.project)) {
            JavaEEQuickPeek archiveQuickPeek = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(archive);
            int type = archiveQuickPeek.getType();
            if (-1 != type) {
                AssertWarn.warnEquals((String)("Archive is not a utility, but was imported as such, archive=" + archive), (int)this.getExportType(), (int)type);
            }
        } else {
            int iVersionConstant;
            String sProjVersion;
            int iProjVersion;
            JavaEEQuickPeek archiveQuickPeek = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(archive);
            int type = archiveQuickPeek.getType();
            if (this.getExportType() != type) {
                AssertWarn.warnEquals((String)("Archive type did not match imported project type, archive=" + archive), (int)this.getExportType(), (int)type);
            }
            if ((iProjVersion = J2EEVersionUtil.convertVersionStringToInt((String)(sProjVersion = J2EEProjectUtilities.getJ2EEDDProjectVersion((IProject)this.project)))) != (iVersionConstant = archiveQuickPeek.getVersion())) {
                AssertWarn.warnEquals((String)("Archive version did not match imported project version, archive=" + archive), (int)iProjVersion, (int)iVersionConstant);
            }
        }
    }

    private void verifyProjectCreated() {
        Assert.assertTrue((String)("A project with name, " + this.project.getName() + ", should have been created by import"), (boolean)this.project.exists());
    }

    protected boolean isClassWithoutSource(IArchive archive, IArchiveResource aFile) {
        String javaUri = this.classUriToJavaUri(aFile.getPath().toString());
        if (javaUri == null) {
            return false;
        }
        return !archive.containsArchiveResource((IPath)new Path(javaUri));
    }

    public String classUriToJavaUri(String classUri) {
        if (classUri == null || !classUri.endsWith(".class")) {
            return null;
        }
        String truncated = JEEImportDataModelVerifier.truncateIgnoreCase(classUri, ".class");
        StringTokenizer tok = new StringTokenizer(truncated, "$");
        return tok.nextToken().concat(".java");
    }

    public static String truncateIgnoreCase(String aString, String trailingSubString) {
        int index = aString.toLowerCase().lastIndexOf(trailingSubString.toLowerCase());
        if (index != -1) {
            return aString.substring(0, index);
        }
        return aString;
    }

    private void verifyAllFilesImported(IArchive archive) throws Exception {
        List resources = archive.getArchiveResources();
        IPath resourcePath = null;
        IFolder importedClassesFolder = this.project.getFolder("ImportedClasses");
        IVirtualComponent projectComponent = ComponentUtilities.getComponent((String)this.project.getName());
        IVirtualFolder rootVirtFolder = projectComponent.getRootFolder();
        IFolder rootFolder = (IFolder)rootVirtFolder.getUnderlyingFolder();
        Assert.assertTrue((String)("The root folder " + rootFolder.getName() + " should exist in the project"), (boolean)rootFolder.exists());
        ArrayList<IArchiveResource> classes = new ArrayList<IArchiveResource>();
        ArrayList<IArchiveResource> sourceResources = new ArrayList<IArchiveResource>();
        ArrayList<IArchiveResource> otherResources = new ArrayList<IArchiveResource>();
        String extension = null;
        for (IArchiveResource resource : resources) {
            resourcePath = resource.getPath();
            switch (resource.getType()) {
                case 0: {
                    extension = resourcePath.getFileExtension();
                    if (extension.equals(CLASS_EXTENSION)) {
                        if (!this.isClassWithoutSource(archive, resource)) break;
                        classes.add(resource);
                        break;
                    }
                    if (extension.equals(JAVA_EXTENSION)) {
                        sourceResources.add(resource);
                        break;
                    }
                    if (extension.equals(JAR_EXTENSION) || extension.equals(RAR_EXTENSION) || extension.equals(WAR_EXTENSION)) {
                        archive.getNestedArchive(resource);
                        break;
                    }
                    otherResources.add(resource);
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
        List nestedArchives = archive.getNestedArchives();
        this.verifyImportedResources(sourceResources, classes, otherResources, nestedArchives, rootFolder, importedClassesFolder);
    }

    protected abstract void verifyImportedResources(Collection<IArchiveResource> var1, Collection<IArchiveResource> var2, Collection<IArchiveResource> var3, Collection<IArchive> var4, IFolder var5, IFolder var6) throws Exception;
}

