/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.web.verifiers;

import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.application.Module;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.verifiers.ModuleProjectCreationDataModelVerifier;

public class WebProjectCreationDataModelVerifier
extends ModuleProjectCreationDataModelVerifier {
    public void verify(IDataModel model) throws Exception {
        super.verify(model);
        this.verifyContextRoot();
        this.verifyContentDir();
        this.verifyJavaSrcDir();
    }

    protected void setFacetProjectType() {
        this.facetProjectType = "jst.web";
    }

    protected IFile getDDFile() {
        return this.component.getRootFolder().getFile("WEB-INF/web.xml").getUnderlyingFile();
    }

    protected void verifyDD(Object modelObj) {
        String version = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)this.project);
        if (version.equals("2.5")) {
            WebApp web = (WebApp)modelObj;
            Assert.assertEquals((String)"Invalid project version", (String)version, (String)web.getVersion().getLiteral());
        } else {
            org.eclipse.jst.j2ee.webapplication.WebApp web = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObj;
            Assert.assertEquals((String)"Invalid project version", (String)version, (String)web.getVersion());
        }
    }

    private void verifyContextRoot() {
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel("jst.web");
        boolean addToEAR = this.model.getBooleanProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR");
        if (addToEAR) {
            Object earModelObj;
            String expectedContextRoot = facetModel.getStringProperty("IWebFacetInstallDataModelProperties.CONTEXT_ROOT");
            String earName = this.model.getStringProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME");
            IProject ear = ProjectUtilities.getProject((String)earName);
            IVirtualComponent earComponent = ComponentCore.createComponent((IProject)ear);
            IVirtualReference projRef = J2EEProjectUtilities.getComponentReference((IVirtualComponent)earComponent, (String)this.project.getName());
            IVirtualComponent projComponentFromEARRef = projRef.getReferencedComponent();
            IProject projFromEARRef = projComponentFromEARRef.getProject();
            Assert.assertTrue((String)"EAR reference to the project should be identical to the project", (this.project == projFromEARRef ? 1 : 0) != 0);
            IModelProvider earProvider = ModelProviderManager.getModelProvider((IProject)ear);
            System.err.println("TODO -- see https://bugs.eclipse.org/bugs/show_bug.cgi?id=199920");
            IVirtualFolder rootFolder = earComponent.getRootFolder();
            Path path = new Path("META-INF/application.xml");
            IVirtualFile vFile = rootFolder.getFile((IPath)path);
            if (vFile.exists() && (earModelObj = earProvider.getModelObject()) != null) {
                String actualContextRoot = null;
                String projArchiveName = projRef.getArchiveName();
                String version = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)this.project);
                if (version.equals("2.5")) {
                    org.eclipse.jst.javaee.application.Application earApp = (org.eclipse.jst.javaee.application.Application)earModelObj;
                    Module projMod = earApp.getFirstModule(projArchiveName);
                    actualContextRoot = projMod.getWeb().getContextRoot();
                } else {
                    Application earApp = (Application)earModelObj;
                    org.eclipse.jst.j2ee.application.Module projMod = earApp.getFirstModule(projArchiveName);
                    WebModule webModule = (WebModule)projMod;
                    actualContextRoot = webModule.getContextRoot();
                }
                Assert.assertEquals((String)("EAR should have module with context root: " + expectedContextRoot), (String)expectedContextRoot, (String)actualContextRoot);
            }
        }
    }

    private void verifyContentDir() {
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel("jst.web");
        String contentDir = facetModel.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
        Path contentDirPath = new Path(contentDir);
        Assert.assertTrue((String)"Content directory should exist", (boolean)this.project.exists((IPath)contentDirPath));
    }

    private void verifyJavaSrcDir() {
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel("jst.web");
        String javaSrcDir = facetModel.getStringProperty("IWebFacetInstallDataModelProperties.SOURCE_FOLDER");
        Path javaSrcDirPath = new Path(javaSrcDir);
        Assert.assertTrue((String)"Java source directory should exist", (boolean)this.project.exists((IPath)javaSrcDirPath));
    }
}

