/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.project.facet;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;

public class TestJSFUtils
extends TestCase {
    private WebProjectTestEnvironment _webProjectTestEnv;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        this._webProjectTestEnv = new WebProjectTestEnvironment(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_" + this.getName());
        this._webProjectTestEnv.createProject(false);
        TestJSFUtils.assertNotNull((Object)this._webProjectTestEnv);
        TestJSFUtils.assertNotNull((Object)this._webProjectTestEnv.getTestProject());
        TestJSFUtils.assertTrue((boolean)this._webProjectTestEnv.getTestProject().isAccessible());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this._webProjectTestEnv.getTestProject().close(null);
    }

    public void testSearchServletMappings_NoPrefixMappings() {
        ArrayList<String> mappings = new ArrayList<String>();
        mappings.add("/notaprefixmapping/");
        mappings.add("*.faces");
        mappings.add("*.html");
        mappings.add("*.jsp");
        JSFUtils.MappingSearchResult result = JSFUtils.searchServletMappings(mappings, null, null);
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertTrue((boolean)result.isResult());
        TestJSFUtils.assertTrue((boolean)result.getExtensionMapping().equals("*.faces"));
        TestJSFUtils.assertNull((Object)result.getPrefixMapping());
        result = JSFUtils.searchServletMappings(mappings, (String)"*.faces", null);
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertTrue((boolean)result.isResult());
        TestJSFUtils.assertEquals((String)result.getExtensionMapping(), (String)"*.faces");
        TestJSFUtils.assertNull((Object)result.getPrefixMapping());
        result = JSFUtils.searchServletMappings(mappings, (String)"*.html", null);
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertTrue((boolean)result.isResult());
        TestJSFUtils.assertEquals((String)result.getExtensionMapping(), (String)"*.html");
        TestJSFUtils.assertNull((Object)result.getPrefixMapping());
        result = JSFUtils.searchServletMappings(mappings, (String)"*.jsp", null);
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertTrue((boolean)result.isResult());
        TestJSFUtils.assertEquals((String)result.getExtensionMapping(), (String)"*.jsp");
        TestJSFUtils.assertNull((Object)result.getPrefixMapping());
        result = JSFUtils.searchServletMappings(mappings, (String)"*.xhtml", null);
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertTrue((boolean)result.isResult());
        TestJSFUtils.assertEquals((String)result.getExtensionMapping(), (String)"*.faces");
        TestJSFUtils.assertNull((Object)result.getPrefixMapping());
    }

    public void testSearchServletMappings_NoExtensionMappings() {
        ArrayList<String> mappings = new ArrayList<String>();
        mappings.add("/notaprefixMapping/");
        mappings.add("/faces/*");
        mappings.add("/foo/*");
        mappings.add("/bar/*");
        JSFUtils.MappingSearchResult result = JSFUtils.searchServletMappings(mappings, null, null);
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertTrue((boolean)result.isResult());
        TestJSFUtils.assertEquals((String)result.getPrefixMapping(), (String)"/faces/*");
        TestJSFUtils.assertNull((Object)result.getExtensionMapping());
        result = JSFUtils.searchServletMappings(mappings, null, (String)"/faces/*");
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertTrue((boolean)result.isResult());
        TestJSFUtils.assertEquals((String)result.getPrefixMapping(), (String)"/faces/*");
        TestJSFUtils.assertNull((Object)result.getExtensionMapping());
        result = JSFUtils.searchServletMappings(mappings, null, (String)"/foo/*");
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertTrue((boolean)result.isResult());
        TestJSFUtils.assertEquals((String)result.getPrefixMapping(), (String)"/foo/*");
        TestJSFUtils.assertNull((Object)result.getExtensionMapping());
        result = JSFUtils.searchServletMappings(mappings, null, (String)"/bar/*");
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertTrue((boolean)result.isResult());
        TestJSFUtils.assertEquals((String)result.getPrefixMapping(), (String)"/bar/*");
        TestJSFUtils.assertNull((Object)result.getExtensionMapping());
        result = JSFUtils.searchServletMappings(mappings, null, (String)"/notfound/*");
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertTrue((boolean)result.isResult());
        TestJSFUtils.assertEquals((String)result.getPrefixMapping(), (String)"/faces/*");
        TestJSFUtils.assertNull((Object)result.getExtensionMapping());
    }

    public void testSearchServletMappings_BothKindsOfMappings() {
        ArrayList<String> mappings = new ArrayList<String>();
        mappings.add("/notaprefixmapping/");
        mappings.add("*.faces");
        mappings.add("/faces/*");
        mappings.add("*.html");
        mappings.add("/foo/*");
        mappings.add("*.jsp");
        mappings.add("/bar/*");
        JSFUtils.MappingSearchResult result = JSFUtils.searchServletMappings(mappings, null, null);
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertTrue((boolean)result.isResult());
        TestJSFUtils.assertEquals((String)result.getPrefixMapping(), (String)"/faces/*");
        TestJSFUtils.assertEquals((String)result.getExtensionMapping(), (String)"*.faces");
        result = JSFUtils.searchServletMappings(mappings, (String)"*.faces", (String)"/faces/*");
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertTrue((boolean)result.isResult());
        TestJSFUtils.assertEquals((String)result.getPrefixMapping(), (String)"/faces/*");
        TestJSFUtils.assertEquals((String)result.getExtensionMapping(), (String)"*.faces");
        result = JSFUtils.searchServletMappings(mappings, (String)"*.html", (String)"/foo/*");
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertTrue((boolean)result.isResult());
        TestJSFUtils.assertEquals((String)result.getPrefixMapping(), (String)"/foo/*");
        TestJSFUtils.assertEquals((String)result.getExtensionMapping(), (String)"*.html");
        result = JSFUtils.searchServletMappings(mappings, (String)"*.jsp", (String)"/bar/*");
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertTrue((boolean)result.isResult());
        TestJSFUtils.assertEquals((String)result.getPrefixMapping(), (String)"/bar/*");
        TestJSFUtils.assertEquals((String)result.getExtensionMapping(), (String)"*.jsp");
        result = JSFUtils.searchServletMappings(mappings, (String)"*.jsp", (String)"/bar2/*");
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertTrue((boolean)result.isResult());
        TestJSFUtils.assertEquals((String)result.getPrefixMapping(), (String)"/faces/*");
        TestJSFUtils.assertEquals((String)result.getExtensionMapping(), (String)"*.jsp");
        result = JSFUtils.searchServletMappings(mappings, (String)"*.jspx", (String)"/bar/*");
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertTrue((boolean)result.isResult());
        TestJSFUtils.assertEquals((String)result.getPrefixMapping(), (String)"/bar/*");
        TestJSFUtils.assertEquals((String)result.getExtensionMapping(), (String)"*.faces");
        result = JSFUtils.searchServletMappings(mappings, (String)"*.jspx", (String)"/bar2/*");
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertTrue((boolean)result.isResult());
        TestJSFUtils.assertEquals((String)result.getPrefixMapping(), (String)"/faces/*");
        TestJSFUtils.assertEquals((String)result.getExtensionMapping(), (String)"*.faces");
    }

    public void testSearchServletMappings_NoMatches() {
        ArrayList<String> mappings = new ArrayList<String>();
        mappings.add("/notaprefixmapping/");
        mappings.add("/alsoNotAMatch/");
        mappings.add("/");
        mappings.add("file.jsp");
        mappings.add("test.html");
        mappings.add("foo.jspx");
        JSFUtils.MappingSearchResult result = JSFUtils.searchServletMappings(mappings, null, null);
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertFalse((boolean)result.isResult());
        TestJSFUtils.assertNull((Object)result.getPrefixMapping());
        TestJSFUtils.assertNull((Object)result.getExtensionMapping());
        result = JSFUtils.searchServletMappings(mappings, (String)"*.faces", null);
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertFalse((boolean)result.isResult());
        TestJSFUtils.assertNull((Object)result.getPrefixMapping());
        TestJSFUtils.assertNull((Object)result.getExtensionMapping());
        result = JSFUtils.searchServletMappings(mappings, null, (String)"/faces/*");
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertFalse((boolean)result.isResult());
        TestJSFUtils.assertNull((Object)result.getPrefixMapping());
        TestJSFUtils.assertNull((Object)result.getExtensionMapping());
        result = JSFUtils.searchServletMappings(mappings, (String)"*.faces", (String)"/faces/*");
        TestJSFUtils.assertNotNull((Object)result);
        TestJSFUtils.assertFalse((boolean)result.isResult());
        TestJSFUtils.assertNull((Object)result.getPrefixMapping());
        TestJSFUtils.assertNull((Object)result.getExtensionMapping());
    }
}

