/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.region;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.jsf.common.dom.AttrDOMAdapter;
import org.eclipse.jst.jsf.common.dom.AttributeIdentifier;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.region.Region2AttrAdapter;
import org.eclipse.jst.jsf.core.internal.region.Region2ElementAdapter;
import org.eclipse.jst.jsf.core.internal.tld.IJSFConstants;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsp.core.internal.domdocument.DOMModelForJSP;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRegion2ElementAdapter
extends TestCase {
    private static final int OFFSET_OUTPUT_TEXT_WITH_EL = 883;
    private static final int OFFSET_PANELGRID_WITH_NO_EL = 958;
    private static final int OFFSET_OUTPUTLABEL_WITH_NO_EL = 990;
    private static final int OFFSET_INPUTTEXT_WITH_BOTH = 1044;
    private static final int OFFSET_COMMANDBUTTON_WITH_TWO_EL = 1255;
    private static final Map<String, String> OUTPUTLABEL_ATTRIBUTES;
    private static final Map<String, String> INPUTTEXT_ATTRIBUTES;
    private static final Map<String, String> COMMANDBUTTON_ATTRIBUTES;
    private WebProjectTestEnvironment _webProjectTestEnv;
    private IResource _res1;
    private IStructuredModel _model;
    private IStructuredDocument _sdoc;

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("for", "userId");
        map.put("value", "Username:");
        OUTPUTLABEL_ATTRIBUTES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put("id", "userId");
        map.put("value", "#{loginRequest.id}");
        INPUTTEXT_ATTRIBUTES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put("action", "#{appController.loginActions}");
        map.put("value", "#{bundle['login.button.value']}");
        COMMANDBUTTON_ATTRIBUTES = Collections.unmodifiableMap(map);
    }

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        this._webProjectTestEnv = new WebProjectTestEnvironment(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_" + this.getName());
        this._webProjectTestEnv.createProject(false);
        TestRegion2ElementAdapter.assertNotNull((Object)this._webProjectTestEnv);
        TestRegion2ElementAdapter.assertNotNull((Object)this._webProjectTestEnv.getTestProject());
        TestRegion2ElementAdapter.assertTrue((boolean)this._webProjectTestEnv.getTestProject().isAccessible());
        this._res1 = this._webProjectTestEnv.loadResourceInWebRoot(TestsPlugin.getDefault().getBundle(), "/testfiles/jsps/testdata1.jsp.data", "/testdata1.jsp");
        this._model = StructuredModelManager.getModelManager().getModelForRead((IFile)this._res1);
        assert (this._model instanceof DOMModelForJSP);
        this._sdoc = this._model.getStructuredDocument();
    }

    protected void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            this._model.releaseFromRead();
        }
    }

    public void testSanity() {
        this.assertExpectedTag(883, "h", "outputText", "http://java.sun.com/jsf/html");
        HashMap<String, String> expectedMap = new HashMap<String, String>();
        expectedMap.put("value", "#{bundle['page.header']}");
        this.assertExpectedAttributes(883, expectedMap);
        this.assertExpectedTag(958, "h", "panelGrid", "http://java.sun.com/jsf/html");
        expectedMap.clear();
        expectedMap.put("columns", "2");
        this.assertExpectedAttributes(958, expectedMap);
        this.assertExpectedTag(990, "h", "outputLabel", "http://java.sun.com/jsf/html");
        this.assertExpectedAttributes(990, OUTPUTLABEL_ATTRIBUTES);
        this.assertExpectedTag(1044, "h", "inputText", "http://java.sun.com/jsf/html");
        this.assertExpectedAttributes(1044, INPUTTEXT_ATTRIBUTES);
        this.assertExpectedTag(1255, "h", "commandButton", "http://java.sun.com/jsf/html");
        this.assertExpectedAttributes(1255, COMMANDBUTTON_ATTRIBUTES);
    }

    public void testOutputTextWithEL() throws Exception {
        IndexedRegion region = JSFTestUtil.getIndexedRegion((IStructuredDocument)this._sdoc, (int)883);
        IDOMNode domNode = (IDOMNode)region;
        IStructuredDocumentRegion textRegion = domNode.getFirstStructuredDocumentRegion();
        Region2ElementAdapter adapter = new Region2ElementAdapter((ITextRegion)textRegion);
        TestRegion2ElementAdapter.assertEquals((String)"h:outputText", (String)adapter.getNodeName());
        TestRegion2ElementAdapter.assertEquals((String)"outputText", (String)adapter.getLocalName());
        TestRegion2ElementAdapter.assertEquals((String)"h", (String)adapter.getPrefix());
        TestRegion2ElementAdapter.assertEquals((String)"http://java.sun.com/jsf/html", (String)adapter.getNamespace());
        TestRegion2ElementAdapter.assertEquals((int)1, (int)adapter.getAttributes().size());
        TagIdentifier tagId = adapter.getTagId();
        TestRegion2ElementAdapter.assertNotNull((Object)tagId);
        TestRegion2ElementAdapter.assertEquals((String)"http://java.sun.com/jsf/html", (String)tagId.getUri());
        TestRegion2ElementAdapter.assertEquals((String)"outputText", (String)tagId.getTagName());
        TestRegion2ElementAdapter.assertEquals((Object)IJSFConstants.TAG_IDENTIFIER_OUTPUTTEXT, (Object)tagId);
        TestRegion2ElementAdapter.assertTrue((boolean)adapter.getAttributes().containsKey("value"));
        AttrDOMAdapter attr = (AttrDOMAdapter)adapter.getAttributes().get("value");
        TestRegion2ElementAdapter.assertEquals((String)"value", (String)attr.getLocalName());
        TestRegion2ElementAdapter.assertEquals((String)"value", (String)attr.getNodeName());
        TestRegion2ElementAdapter.assertEquals((String)"#{bundle['page.header']}", (String)attr.getValue());
        AttributeIdentifier attrId = attr.getAttributeIdentifier();
        TestRegion2ElementAdapter.assertNotNull((Object)attrId);
        TestRegion2ElementAdapter.assertEquals((Object)tagId, (Object)attrId.getTagIdentifier());
        TestRegion2ElementAdapter.assertEquals((String)attr.getNodeName(), (String)attrId.getName());
    }

    public void testPanelGridWithNoEL() throws Exception {
        IndexedRegion region = JSFTestUtil.getIndexedRegion((IStructuredDocument)this._sdoc, (int)958);
        IDOMNode domNode = (IDOMNode)region;
        IStructuredDocumentRegion textRegion = domNode.getFirstStructuredDocumentRegion();
        Region2ElementAdapter adapter = new Region2ElementAdapter((ITextRegion)textRegion);
        TestRegion2ElementAdapter.assertEquals((String)"h:panelGrid", (String)adapter.getNodeName());
        TestRegion2ElementAdapter.assertEquals((String)"panelGrid", (String)adapter.getLocalName());
        TestRegion2ElementAdapter.assertEquals((String)"h", (String)adapter.getPrefix());
        TestRegion2ElementAdapter.assertEquals((String)"http://java.sun.com/jsf/html", (String)adapter.getNamespace());
        TestRegion2ElementAdapter.assertEquals((int)1, (int)adapter.getAttributes().size());
        TagIdentifier tagId = adapter.getTagId();
        TestRegion2ElementAdapter.assertNotNull((Object)tagId);
        TestRegion2ElementAdapter.assertEquals((String)"http://java.sun.com/jsf/html", (String)tagId.getUri());
        TestRegion2ElementAdapter.assertEquals((String)"panelGrid", (String)tagId.getTagName());
        TestRegion2ElementAdapter.assertEquals((Object)IJSFConstants.TAG_IDENTIFIER_PANEL_GRID, (Object)tagId);
        TestRegion2ElementAdapter.assertTrue((boolean)adapter.getAttributes().containsKey("columns"));
        AttrDOMAdapter attr = (AttrDOMAdapter)adapter.getAttributes().get("columns");
        TestRegion2ElementAdapter.assertEquals((String)"columns", (String)attr.getLocalName());
        TestRegion2ElementAdapter.assertEquals((String)"columns", (String)attr.getNodeName());
        TestRegion2ElementAdapter.assertEquals((String)"2", (String)attr.getValue());
        AttributeIdentifier attrId = attr.getAttributeIdentifier();
        TestRegion2ElementAdapter.assertNotNull((Object)attrId);
        TestRegion2ElementAdapter.assertEquals((Object)tagId, (Object)attrId.getTagIdentifier());
        TestRegion2ElementAdapter.assertEquals((String)attr.getNodeName(), (String)attrId.getName());
    }

    public void testOutputLabelWithNoEL() throws Exception {
        IndexedRegion region = JSFTestUtil.getIndexedRegion((IStructuredDocument)this._sdoc, (int)990);
        IDOMNode domNode = (IDOMNode)region;
        IStructuredDocumentRegion textRegion = domNode.getFirstStructuredDocumentRegion();
        Region2ElementAdapter adapter = new Region2ElementAdapter((ITextRegion)textRegion);
        TestRegion2ElementAdapter.assertEquals((String)"h:outputLabel", (String)adapter.getNodeName());
        TestRegion2ElementAdapter.assertEquals((String)"outputLabel", (String)adapter.getLocalName());
        TestRegion2ElementAdapter.assertEquals((String)"h", (String)adapter.getPrefix());
        TestRegion2ElementAdapter.assertEquals((String)"http://java.sun.com/jsf/html", (String)adapter.getNamespace());
        TagIdentifier tagId = adapter.getTagId();
        TestRegion2ElementAdapter.assertNotNull((Object)tagId);
        TestRegion2ElementAdapter.assertEquals((String)"http://java.sun.com/jsf/html", (String)tagId.getUri());
        TestRegion2ElementAdapter.assertEquals((String)"outputLabel", (String)tagId.getTagName());
        TestRegion2ElementAdapter.assertEquals((Object)IJSFConstants.TAG_IDENTIFIER_OUTPUTLABEL, (Object)tagId);
        TestRegion2ElementAdapter.assertEquals((int)OUTPUTLABEL_ATTRIBUTES.size(), (int)adapter.getAttributes().size());
        for (Map.Entry<String, String> entry : OUTPUTLABEL_ATTRIBUTES.entrySet()) {
            AttrDOMAdapter attrAdapter = (AttrDOMAdapter)adapter.getAttributes().get(entry.getKey());
            TestRegion2ElementAdapter.assertNotNull((Object)attrAdapter);
            TestRegion2ElementAdapter.assertEquals((String)entry.getKey(), (String)attrAdapter.getNodeName());
            TestRegion2ElementAdapter.assertEquals((String)entry.getValue(), (String)attrAdapter.getValue());
            AttributeIdentifier attrId = attrAdapter.getAttributeIdentifier();
            TestRegion2ElementAdapter.assertNotNull((Object)attrId);
            TestRegion2ElementAdapter.assertEquals((Object)tagId, (Object)attrId.getTagIdentifier());
            TestRegion2ElementAdapter.assertEquals((String)attrAdapter.getNodeName(), (String)attrId.getName());
        }
    }

    public void testInputTextWithBoth() throws Exception {
        IndexedRegion region = JSFTestUtil.getIndexedRegion((IStructuredDocument)this._sdoc, (int)1044);
        IDOMNode domNode = (IDOMNode)region;
        IStructuredDocumentRegion textRegion = domNode.getFirstStructuredDocumentRegion();
        Region2ElementAdapter adapter = new Region2ElementAdapter((ITextRegion)textRegion);
        TestRegion2ElementAdapter.assertEquals((String)"h:inputText", (String)adapter.getNodeName());
        TestRegion2ElementAdapter.assertEquals((String)"inputText", (String)adapter.getLocalName());
        TestRegion2ElementAdapter.assertEquals((String)"h", (String)adapter.getPrefix());
        TestRegion2ElementAdapter.assertEquals((String)"http://java.sun.com/jsf/html", (String)adapter.getNamespace());
        TagIdentifier tagId = adapter.getTagId();
        TestRegion2ElementAdapter.assertNotNull((Object)tagId);
        TestRegion2ElementAdapter.assertEquals((String)"http://java.sun.com/jsf/html", (String)tagId.getUri());
        TestRegion2ElementAdapter.assertEquals((String)"inputText", (String)tagId.getTagName());
        TestRegion2ElementAdapter.assertEquals((Object)IJSFConstants.TAG_IDENTIFIER_INPUTTEXT, (Object)tagId);
        TestRegion2ElementAdapter.assertEquals((int)INPUTTEXT_ATTRIBUTES.size(), (int)adapter.getAttributes().size());
        for (Map.Entry<String, String> entry : INPUTTEXT_ATTRIBUTES.entrySet()) {
            AttrDOMAdapter attrAdapter = (AttrDOMAdapter)adapter.getAttributes().get(entry.getKey());
            TestRegion2ElementAdapter.assertNotNull((Object)attrAdapter);
            TestRegion2ElementAdapter.assertEquals((String)entry.getKey(), (String)attrAdapter.getNodeName());
            TestRegion2ElementAdapter.assertEquals((String)entry.getValue(), (String)attrAdapter.getValue());
            AttributeIdentifier attrId = attrAdapter.getAttributeIdentifier();
            TestRegion2ElementAdapter.assertNotNull((Object)attrId);
            TestRegion2ElementAdapter.assertEquals((Object)tagId, (Object)attrId.getTagIdentifier());
            TestRegion2ElementAdapter.assertEquals((String)attrAdapter.getNodeName(), (String)attrId.getName());
        }
    }

    public void testCommandButtonWithTwoEL() throws Exception {
        IndexedRegion region = JSFTestUtil.getIndexedRegion((IStructuredDocument)this._sdoc, (int)1255);
        IDOMNode domNode = (IDOMNode)region;
        IStructuredDocumentRegion textRegion = domNode.getFirstStructuredDocumentRegion();
        Region2ElementAdapter adapter = new Region2ElementAdapter((ITextRegion)textRegion);
        TestRegion2ElementAdapter.assertEquals((String)"h:commandButton", (String)adapter.getNodeName());
        TestRegion2ElementAdapter.assertEquals((String)"commandButton", (String)adapter.getLocalName());
        TestRegion2ElementAdapter.assertEquals((String)"h", (String)adapter.getPrefix());
        TestRegion2ElementAdapter.assertEquals((String)"http://java.sun.com/jsf/html", (String)adapter.getNamespace());
        TagIdentifier tagId = adapter.getTagId();
        TestRegion2ElementAdapter.assertNotNull((Object)tagId);
        TestRegion2ElementAdapter.assertEquals((String)"http://java.sun.com/jsf/html", (String)tagId.getUri());
        TestRegion2ElementAdapter.assertEquals((String)"commandButton", (String)tagId.getTagName());
        TestRegion2ElementAdapter.assertEquals((Object)IJSFConstants.TAG_IDENTIFIER_COMMANDBUTTON, (Object)tagId);
        TestRegion2ElementAdapter.assertEquals((int)COMMANDBUTTON_ATTRIBUTES.size(), (int)adapter.getAttributes().size());
        for (Map.Entry<String, String> entry : COMMANDBUTTON_ATTRIBUTES.entrySet()) {
            AttrDOMAdapter attrAdapter = (AttrDOMAdapter)adapter.getAttributes().get(entry.getKey());
            TestRegion2ElementAdapter.assertNotNull((Object)attrAdapter);
            TestRegion2ElementAdapter.assertEquals((String)entry.getKey(), (String)attrAdapter.getNodeName());
            TestRegion2ElementAdapter.assertEquals((String)entry.getValue(), (String)attrAdapter.getValue());
            AttributeIdentifier attrId = attrAdapter.getAttributeIdentifier();
            TestRegion2ElementAdapter.assertNotNull((Object)attrId);
            TestRegion2ElementAdapter.assertEquals((Object)tagId, (Object)attrId.getTagIdentifier());
            TestRegion2ElementAdapter.assertEquals((String)attrAdapter.getNodeName(), (String)attrId.getName());
        }
    }

    public void testAdapterToRegionMappings() throws Exception {
        IndexedRegion region = JSFTestUtil.getIndexedRegion((IStructuredDocument)this._sdoc, (int)1044);
        IDOMNode domNode = (IDOMNode)region;
        IStructuredDocumentRegion textRegion = domNode.getFirstStructuredDocumentRegion();
        Region2ElementAdapter adapter = new Region2ElementAdapter((ITextRegion)textRegion);
        TestRegion2ElementAdapter.assertEquals((int)1044, (int)adapter.getTextRegion().getStart());
        TestRegion2ElementAdapter.assertEquals((Object)textRegion, (Object)adapter.getTextRegion());
        Region2AttrAdapter attrAdapter = (Region2AttrAdapter)adapter.getAttributes().get("id");
        TestRegion2ElementAdapter.assertEquals((int)1057, (int)attrAdapter.getStartOffset());
        this.assertExpectedAttributeName(attrAdapter, 13, 2);
        this.assertExpectedAttributeValue(attrAdapter, 16, 9);
        attrAdapter = (Region2AttrAdapter)adapter.getAttributes().get("value");
        TestRegion2ElementAdapter.assertEquals((int)1069, (int)attrAdapter.getStartOffset());
        this.assertExpectedAttributeName(attrAdapter, 25, 5);
        this.assertExpectedAttributeValue(attrAdapter, 31, 20);
    }

    private void assertExpectedAttributeName(Region2AttrAdapter attrAdapter, int expectedStart, int expectedLength) {
        ITextRegion nameRegion = attrAdapter.getAttributeNameRegion();
        TestRegion2ElementAdapter.assertEquals((int)expectedStart, (int)nameRegion.getStart());
        TestRegion2ElementAdapter.assertEquals((int)expectedLength, (int)nameRegion.getLength());
    }

    private void assertExpectedAttributeValue(Region2AttrAdapter attrAdapter, int expectedStart, int expectedLength) {
        ITextRegion valueRegion = attrAdapter.getAttributeValueRegion();
        TestRegion2ElementAdapter.assertEquals((int)expectedStart, (int)valueRegion.getStart());
        TestRegion2ElementAdapter.assertEquals((int)expectedLength, (int)valueRegion.getLength());
    }

    private void assertExpectedTag(int offset, String prefix, String tagName, String uri) {
        IndexedRegion region = JSFTestUtil.getIndexedRegion((IStructuredDocument)this._sdoc, (int)offset);
        TestRegion2ElementAdapter.assertTrue((boolean)(region instanceof IDOMElement));
        TestRegion2ElementAdapter.assertEquals((String)(String.valueOf(prefix) + ":" + tagName), (String)((IDOMElement)region).getNodeName());
        TestRegion2ElementAdapter.assertEquals((String)tagName, (String)((IDOMElement)region).getLocalName());
        TestRegion2ElementAdapter.assertEquals((String)prefix, (String)((IDOMElement)region).getPrefix());
    }

    private void assertExpectedAttributes(int offset, Map<String, String> attributes) {
        IndexedRegion region = JSFTestUtil.getIndexedRegion((IStructuredDocument)this._sdoc, (int)offset);
        TestRegion2ElementAdapter.assertTrue((boolean)(region instanceof IDOMElement));
        final IDOMElement domElement = (IDOMElement)region;
        this.assertExpectedAttributes(new Iterator<Node>(){
            int curElement = 0;

            @Override
            public boolean hasNext() {
                return this.curElement < domElement.getAttributes().getLength();
            }

            @Override
            public Node next() {
                return domElement.getAttributes().item(this.curElement++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("");
            }
        }, attributes);
    }

    private void assertExpectedAttributes(Iterator<Node> check, Map<String, String> expectedAttributes) {
        int count = 0;
        while (check.hasNext()) {
            Node node = check.next();
            TestRegion2ElementAdapter.assertTrue((boolean)expectedAttributes.containsKey(node.getNodeName()));
            TestRegion2ElementAdapter.assertEquals((String)expectedAttributes.get(node.getNodeName()), (String)node.getNodeValue());
            ++count;
        }
        TestRegion2ElementAdapter.assertEquals((int)expectedAttributes.size(), (int)count);
    }
}

