/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.set;

import org.eclipse.jst.jsf.common.sets.AxiomaticSet;
import org.eclipse.jst.jsf.core.internal.tld.IJSFConstants;
import org.eclipse.jst.jsf.core.set.mapping.ElementToTagIdentifierMapping;
import org.eclipse.jst.jsf.core.tagmatcher.XPathMatchingAlgorithm;
import org.eclipse.jst.jsf.core.tests.tagmatcher.BaseTagMatcherTestCase;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;

public class NodeSetTest
extends BaseTagMatcherTestCase {
    private AxiomaticSet _ancestorsOfInputText;
    private AxiomaticSet _ancestorsOfCommandButton;
    private AxiomaticSet _ancestorsOfOutputText;
    private AxiomaticSet _inputTextSingletonSet;

    protected void setUp() throws Exception {
        this._srcFileName = "/testfiles/jsps/testdata1.jsp.data";
        this._destFileName = "/testdata1.jsp";
        super.setUp();
        this._ancestorsOfInputText = this.getAncestorsOf("/view/html/body/form/panelGrid/inputText", 5);
        this._ancestorsOfCommandButton = this.getAncestorsOf("/view/html/body/form/commandButton", 4);
        this._ancestorsOfOutputText = this.getAncestorsOf("/view/html/body/form/h1/outputText", 5);
        IDOMDocument doc = ((IDOMModel)this._structuredModel).getDocument();
        XPathMatchingAlgorithm matcher = new XPathMatchingAlgorithm("/view/html/body/form/panelGrid/inputText");
        this._inputTextSingletonSet = matcher.evaluate((Node)doc);
        NodeSetTest.assertEquals((int)1, (int)this._inputTextSingletonSet.size());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIntersect() {
        AxiomaticSet set1 = this._ancestorsOfInputText.intersect(this._ancestorsOfCommandButton);
        set1 = new ElementToTagIdentifierMapping().map(set1);
        NodeSetTest.assertEquals((int)4, (int)set1.size());
        NodeSetTest.assertTrue((boolean)set1.contains((Object)IJSFConstants.TAG_IDENTIFIER_FORM));
        NodeSetTest.assertTrue((boolean)set1.contains((Object)IJSFConstants.TAG_IDENTIFIER_VIEW));
        NodeSetTest.assertFalse((boolean)set1.contains((Object)IJSFConstants.TAG_IDENTIFIER_PANEL_GRID));
        AxiomaticSet set2 = this._ancestorsOfOutputText.intersect(this._ancestorsOfCommandButton);
        set2 = new ElementToTagIdentifierMapping().map(set2);
        NodeSetTest.assertEquals((int)4, (int)set2.size());
        NodeSetTest.assertTrue((boolean)set2.contains((Object)IJSFConstants.TAG_IDENTIFIER_FORM));
        NodeSetTest.assertTrue((boolean)set2.contains((Object)IJSFConstants.TAG_IDENTIFIER_VIEW));
        NodeSetTest.assertFalse((boolean)set2.equals((Object)new ElementToTagIdentifierMapping().map(this._ancestorsOfOutputText)));
        NodeSetTest.assertTrue((boolean)set2.equals((Object)new ElementToTagIdentifierMapping().map(this._ancestorsOfCommandButton)));
    }

    public void testIsEquivalent() throws Exception {
        NodeSetTest.assertTrue((boolean)this._ancestorsOfInputText.isEquivalent(this._ancestorsOfInputText));
        NodeSetTest.assertFalse((boolean)this._ancestorsOfInputText.isEquivalent(this._ancestorsOfCommandButton));
        NodeSetTest.assertFalse((boolean)this._ancestorsOfInputText.isEquivalent(this._ancestorsOfOutputText));
        NodeSetTest.assertTrue((boolean)this._ancestorsOfInputText.isEquivalent(this.getAncestorsOf("/view/html/body/form/panelGrid/inputText", -1)));
    }

    public void testUnion() {
        AxiomaticSet set1 = this._ancestorsOfInputText.union(this._ancestorsOfCommandButton);
        set1 = new ElementToTagIdentifierMapping().map(set1);
        NodeSetTest.assertEquals((int)5, (int)set1.size());
        NodeSetTest.assertTrue((boolean)set1.contains((Object)IJSFConstants.TAG_IDENTIFIER_FORM));
        NodeSetTest.assertTrue((boolean)set1.contains((Object)IJSFConstants.TAG_IDENTIFIER_VIEW));
        NodeSetTest.assertTrue((boolean)set1.contains((Object)IJSFConstants.TAG_IDENTIFIER_PANEL_GRID));
        AxiomaticSet set2 = this._ancestorsOfOutputText.union(this._ancestorsOfCommandButton);
        set2 = new ElementToTagIdentifierMapping().map(set2);
        NodeSetTest.assertEquals((int)5, (int)set2.size());
        NodeSetTest.assertTrue((boolean)set2.contains((Object)IJSFConstants.TAG_IDENTIFIER_FORM));
        NodeSetTest.assertTrue((boolean)set2.contains((Object)IJSFConstants.TAG_IDENTIFIER_VIEW));
        NodeSetTest.assertFalse((boolean)set2.contains((Object)IJSFConstants.TAG_IDENTIFIER_PANEL_GRID));
    }

    public void testIsDisjoint() {
        NodeSetTest.assertFalse((boolean)this._ancestorsOfInputText.isDisjoint(this._ancestorsOfCommandButton));
        NodeSetTest.assertFalse((boolean)this._ancestorsOfInputText.isDisjoint(this._ancestorsOfOutputText));
        NodeSetTest.assertFalse((boolean)this._ancestorsOfInputText.isDisjoint(this._ancestorsOfInputText));
        NodeSetTest.assertTrue((boolean)this._ancestorsOfInputText.isDisjoint(this._inputTextSingletonSet));
        NodeSetTest.assertTrue((boolean)this._ancestorsOfOutputText.isDisjoint(this._inputTextSingletonSet));
        NodeSetTest.assertTrue((boolean)this._ancestorsOfCommandButton.isDisjoint(this._inputTextSingletonSet));
    }

    public void testSubtract() {
        AxiomaticSet set1 = this._ancestorsOfInputText.subtract(this._ancestorsOfCommandButton);
        set1 = new ElementToTagIdentifierMapping().map(set1);
        NodeSetTest.assertEquals((int)1, (int)set1.size());
        NodeSetTest.assertTrue((boolean)set1.contains((Object)IJSFConstants.TAG_IDENTIFIER_PANEL_GRID));
        set1 = this._ancestorsOfCommandButton.subtract(this._ancestorsOfInputText);
        set1 = new ElementToTagIdentifierMapping().map(set1);
        NodeSetTest.assertEquals((int)0, (int)set1.size());
        set1 = this._ancestorsOfCommandButton.subtract(this._inputTextSingletonSet);
        NodeSetTest.assertEquals((Object)this._ancestorsOfCommandButton, (Object)set1);
    }
}

