/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context;

import java.util.Iterator;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinTable;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.ReferenceTable;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.RelationshipReference;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.jpa2.context.AttributeMapping2_0;
import org.eclipse.jpt.core.jpa2.context.CollectionMapping2_0;
import org.eclipse.jpt.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.core.jpa2.context.MetamodelField;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;

public class MappingTools {
    public static String buildJoinTableDefaultName(RelationshipReference relationshipReference) {
        if (relationshipReference.getJpaProject().getDataSource().connectionProfileIsActive()) {
            return MappingTools.buildDbJoinTableDefaultName(relationshipReference);
        }
        String owningTableName = relationshipReference.getTypeMapping().getPrimaryTableName();
        if (owningTableName == null) {
            return null;
        }
        RelationshipMapping relationshipMapping = relationshipReference.getRelationshipMapping();
        if (relationshipMapping == null) {
            return null;
        }
        Entity targetEntity = relationshipMapping.getResolvedTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        String targetTableName = targetEntity.getPrimaryTableName();
        if (targetTableName == null) {
            return null;
        }
        return String.valueOf(owningTableName) + '_' + targetTableName;
    }

    protected static String buildDbJoinTableDefaultName(RelationshipReference relationshipReference) {
        Table owningTable = relationshipReference.getTypeMapping().getPrimaryDbTable();
        if (owningTable == null) {
            return null;
        }
        RelationshipMapping relationshipMapping = relationshipReference.getRelationshipMapping();
        if (relationshipMapping == null) {
            return null;
        }
        Entity targetEntity = relationshipMapping.getResolvedTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        Table targetTable = targetEntity.getPrimaryDbTable();
        if (targetTable == null) {
            return null;
        }
        String name = String.valueOf(owningTable.getName()) + '_' + targetTable.getName();
        return owningTable.getDatabase().convertNameToIdentifier(name);
    }

    public static String buildCollectionTableDefaultName(ElementCollectionMapping2_0 mapping) {
        Entity entity = mapping.getEntity();
        if (entity == null) {
            return null;
        }
        String owningEntityName = entity.getName();
        String attributeName = mapping.getName();
        return String.valueOf(owningEntityName) + '_' + attributeName;
    }

    public static String buildJoinColumnDefaultName(JoinColumn joinColumn, JoinColumn.Owner owner) {
        String targetColumnName;
        if (owner.joinColumnsSize() != 1) {
            return null;
        }
        String prefix = owner.getAttributeName();
        if (prefix == null) {
            Entity targetEntity = owner.getRelationshipTarget();
            if (targetEntity == null) {
                return null;
            }
            prefix = targetEntity.getName();
        }
        if ((targetColumnName = joinColumn.getReferencedColumnName()) == null) {
            return null;
        }
        String name = String.valueOf(prefix) + '_' + targetColumnName;
        return name;
    }

    public static String buildJoinColumnDefaultReferencedColumnName(JoinColumn.Owner joinColumnOwner) {
        if (joinColumnOwner.joinColumnsSize() != 1) {
            return null;
        }
        Entity targetEntity = joinColumnOwner.getRelationshipTarget();
        if (targetEntity == null) {
            return null;
        }
        return targetEntity.getPrimaryKeyColumnName();
    }

    public static ColumnMapping getColumnMapping(String attributeName, PersistentType persistentType) {
        if (attributeName == null || persistentType == null) {
            return null;
        }
        Iterator<PersistentAttribute> stream = persistentType.allAttributes();
        while (stream.hasNext()) {
            PersistentAttribute persAttribute = stream.next();
            if (!attributeName.equals(persAttribute.getName()) || !(persAttribute.getMapping() instanceof ColumnMapping)) continue;
            return (ColumnMapping)persAttribute.getMapping();
        }
        return null;
    }

    public static RelationshipMapping getRelationshipMapping(String attributeName, TypeMapping typeMapping) {
        if (attributeName == null || typeMapping == null) {
            return null;
        }
        Iterator<AttributeMapping> stream = typeMapping.allAttributeMappings();
        while (stream.hasNext()) {
            AttributeMapping attributeMapping = stream.next();
            if (!attributeName.equals(attributeMapping.getName()) || !(attributeMapping instanceof RelationshipMapping)) continue;
            return (RelationshipMapping)attributeMapping;
        }
        return null;
    }

    public static void convertReferenceTableDefaultToSpecifiedJoinColumn(ReferenceTable referenceTable) {
        JoinColumn defaultJoinColumn = referenceTable.getDefaultJoinColumn();
        if (defaultJoinColumn != null) {
            String columnName = defaultJoinColumn.getDefaultName();
            String referencedColumnName = defaultJoinColumn.getDefaultReferencedColumnName();
            JoinColumn joinColumn = referenceTable.addSpecifiedJoinColumn(0);
            joinColumn.setSpecifiedName(columnName);
            joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
        }
    }

    public static void convertJoinTableDefaultToSpecifiedInverseJoinColumn(JoinTable joinTable) {
        JoinColumn defaultInverseJoinColumn = joinTable.getDefaultInverseJoinColumn();
        if (defaultInverseJoinColumn != null) {
            String columnName = defaultInverseJoinColumn.getDefaultName();
            String referencedColumnName = defaultInverseJoinColumn.getDefaultReferencedColumnName();
            JoinColumn joinColumn = joinTable.addSpecifiedInverseJoinColumn(0);
            joinColumn.setSpecifiedName(columnName);
            joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
        }
    }

    public static String getMetamodelFieldMapKeyTypeName(CollectionMapping2_0 mapping) {
        PersistentType targetType = mapping.getResolvedTargetType();
        String mapKey = mapping.getMapKey();
        if (mapKey == null || targetType == null) {
            String mapKeyClass = mapping.getMapKeyClass();
            return mapKeyClass != null ? mapKeyClass : MetamodelField.DEFAULT_TYPE_NAME;
        }
        PersistentAttribute mapKeyAttribute = targetType.resolveAttribute(mapKey);
        if (mapKeyAttribute == null) {
            return MetamodelField.DEFAULT_TYPE_NAME;
        }
        AttributeMapping2_0 mapKeyMapping = (AttributeMapping2_0)mapKeyAttribute.getMapping();
        if (mapKeyMapping == null) {
            return MetamodelField.DEFAULT_TYPE_NAME;
        }
        return mapKeyMapping.getMetamodelTypeName();
    }

    public static Column resolveOverridenColumn(TypeMapping overridableTypeMapping, String attributeOverrideName) {
        if (overridableTypeMapping != null) {
            for (TypeMapping typeMapping : CollectionTools.iterable(overridableTypeMapping.inheritanceHierarchy())) {
                Column column = typeMapping.resolveOverriddenColumn(attributeOverrideName);
                if (column == null) continue;
                return column;
            }
        }
        return null;
    }

    public static RelationshipReference resolveRelationshipReference(TypeMapping overridableTypeMapping, String associationOverrideName) {
        if (overridableTypeMapping != null) {
            for (TypeMapping typeMapping : CollectionTools.iterable(overridableTypeMapping.inheritanceHierarchy())) {
                RelationshipReference relationshipReference = typeMapping.resolveRelationshipReference(associationOverrideName);
                if (relationshipReference == null) continue;
                return relationshipReference;
            }
        }
        return null;
    }

    private MappingTools() {
        throw new UnsupportedOperationException();
    }
}

