/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.Table;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.BaseTableAnnotation;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.Database;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.SchemaContainer;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.NameTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaTable
extends AbstractJavaJpaContextNode
implements Table,
UniqueConstraint.Owner {
    protected String specifiedName;
    protected String defaultName;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected final Vector<JavaUniqueConstraint> uniqueConstraints = new Vector();

    protected AbstractJavaTable(JavaJpaContextNode parent) {
        super(parent);
    }

    protected abstract BaseTableAnnotation getAnnotation();

    protected abstract String getAnnotationName();

    protected abstract String buildDefaultName();

    protected abstract String buildDefaultSchema();

    protected abstract String buildDefaultCatalog();

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.getAnnotation().setName(name);
        this.firePropertyChanged("specifiedName", old, name);
    }

    protected void setSpecifiedName_(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.getAnnotation().setSchema(schema);
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    protected void setSpecifiedSchema_(String newSpecifiedSchema) {
        String oldSpecifiedSchema = this.specifiedSchema;
        this.specifiedSchema = newSpecifiedSchema;
        this.firePropertyChanged("specifiedSchema", oldSpecifiedSchema, newSpecifiedSchema);
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.getAnnotation().setCatalog(catalog);
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    protected void setSpecifiedCatalog_(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    public ListIterator<JavaUniqueConstraint> uniqueConstraints() {
        return new CloneListIterator(this.uniqueConstraints);
    }

    @Override
    public int uniqueConstraintsSize() {
        return this.uniqueConstraints.size();
    }

    @Override
    public JavaUniqueConstraint addUniqueConstraint(int index) {
        JavaUniqueConstraint uniqueConstraint = this.getJpaFactory().buildJavaUniqueConstraint(this, this);
        this.uniqueConstraints.add(index, uniqueConstraint);
        UniqueConstraintAnnotation uniqueConstraintAnnotation = this.getAnnotation().addUniqueConstraint(index);
        uniqueConstraint.initialize(uniqueConstraintAnnotation);
        this.fireItemAdded("uniqueConstraints", index, uniqueConstraint);
        return uniqueConstraint;
    }

    @Override
    public void removeUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.removeUniqueConstraint(this.uniqueConstraints.indexOf(uniqueConstraint));
    }

    @Override
    public void removeUniqueConstraint(int index) {
        JavaUniqueConstraint removedUniqueConstraint = this.uniqueConstraints.remove(index);
        this.getAnnotation().removeUniqueConstraint(index);
        this.fireItemRemoved("uniqueConstraints", index, removedUniqueConstraint);
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.uniqueConstraints, (int)targetIndex, (int)sourceIndex);
        this.getAnnotation().moveUniqueConstraint(targetIndex, sourceIndex);
        this.fireItemMoved("uniqueConstraints", targetIndex, sourceIndex);
    }

    protected void addUniqueConstraint(int index, JavaUniqueConstraint uniqueConstraint) {
        this.addItemToList(index, uniqueConstraint, this.uniqueConstraints, "uniqueConstraints");
    }

    protected void addUniqueConstraint(JavaUniqueConstraint uniqueConstraint) {
        this.addUniqueConstraint(this.uniqueConstraints.size(), uniqueConstraint);
    }

    protected void removeUniqueConstraint_(JavaUniqueConstraint uniqueConstraint) {
        this.removeItemFromList(uniqueConstraint, this.uniqueConstraints, "uniqueConstraints");
    }

    protected void initializeUniqueConstraints(BaseTableAnnotation baseTableAnnotation) {
        ListIterator<UniqueConstraintAnnotation> stream = baseTableAnnotation.uniqueConstraints();
        while (stream.hasNext()) {
            this.uniqueConstraints.add(this.buildUniqueConstraint((UniqueConstraintAnnotation)stream.next()));
        }
    }

    protected void updateUniqueConstraints(BaseTableAnnotation baseTableAnnotation) {
        ListIterator<UniqueConstraintAnnotation> constraintAnnotations = baseTableAnnotation.uniqueConstraints();
        ListIterator<JavaUniqueConstraint> constraints = this.uniqueConstraints();
        while (constraints.hasNext()) {
            JavaUniqueConstraint uniqueConstraint = constraints.next();
            if (constraintAnnotations.hasNext()) {
                uniqueConstraint.update(constraintAnnotations.next());
                continue;
            }
            this.removeUniqueConstraint_(uniqueConstraint);
        }
        while (constraintAnnotations.hasNext()) {
            this.addUniqueConstraint(this.buildUniqueConstraint(constraintAnnotations.next()));
        }
    }

    protected JavaUniqueConstraint buildUniqueConstraint(UniqueConstraintAnnotation uniqueConstraintAnnotation) {
        JavaUniqueConstraint uniqueConstraint = this.getJpaFactory().buildJavaUniqueConstraint(this, this);
        uniqueConstraint.initialize(uniqueConstraintAnnotation);
        return uniqueConstraint;
    }

    protected TextRange getTextRange(TextRange textRange, CompilationUnit astRoot) {
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    protected TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getTextRange(this.getAnnotation().getNameTextRange(astRoot), astRoot);
    }

    protected boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.getAnnotation().nameTouches(pos, astRoot);
    }

    protected TextRange getSchemaTextRange(CompilationUnit astRoot) {
        return this.getTextRange(this.getAnnotation().getSchemaTextRange(astRoot), astRoot);
    }

    protected boolean schemaTouches(int pos, CompilationUnit astRoot) {
        return this.getAnnotation().schemaTouches(pos, astRoot);
    }

    protected TextRange getCatalogTextRange(CompilationUnit astRoot) {
        return this.getTextRange(this.getAnnotation().getCatalogTextRange(astRoot), astRoot);
    }

    protected boolean catalogTouches(int pos, CompilationUnit astRoot) {
        return this.getAnnotation().catalogTouches(pos, astRoot);
    }

    protected void initialize(BaseTableAnnotation baseTableAnnotation) {
        this.defaultName = this.buildDefaultName();
        this.specifiedName = baseTableAnnotation.getName();
        this.defaultSchema = this.buildDefaultSchema();
        this.specifiedSchema = baseTableAnnotation.getSchema();
        this.defaultCatalog = this.buildDefaultCatalog();
        this.specifiedCatalog = baseTableAnnotation.getCatalog();
        this.initializeUniqueConstraints(baseTableAnnotation);
    }

    protected void update(BaseTableAnnotation baseTableAnnotation) {
        this.setDefaultName(this.buildDefaultName());
        this.setSpecifiedName_(baseTableAnnotation.getName());
        this.setDefaultSchema(this.buildDefaultSchema());
        this.setSpecifiedSchema_(baseTableAnnotation.getSchema());
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.setSpecifiedCatalog_(baseTableAnnotation.getCatalog());
        this.updateUniqueConstraints(baseTableAnnotation);
    }

    @Override
    public org.eclipse.jpt.db.Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getName());
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.getDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        return catalog == null ? null : this.getDbCatalog(catalog);
    }

    @Override
    public boolean isResolved() {
        return this.getDbTable() != null;
    }

    @Override
    public boolean hasResolvedSchema() {
        return this.getDbSchema() != null;
    }

    @Override
    public boolean hasResolvedCatalog() {
        String catalog = this.getCatalog();
        return catalog == null || this.getDbCatalog(catalog) != null;
    }

    @Override
    public Iterator<String> candidateUniqueConstraintColumnNames() {
        org.eclipse.jpt.db.Table dbTable = this.getDbTable();
        return dbTable != null ? dbTable.getSortedColumnIdentifiers().iterator() : EmptyIterator.instance();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getTextRange(this.getAnnotation().getTextRange(astRoot), astRoot);
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaUniqueConstraint constraint : CollectionTools.iterable(this.uniqueConstraints())) {
            result = constraint.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Iterator<String> connectedJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.nameTouches(pos, astRoot)) {
            return this.getJavaCandidateNames(filter).iterator();
        }
        if (this.schemaTouches(pos, astRoot)) {
            return this.getJavaCandidateSchemata(filter).iterator();
        }
        if (this.catalogTouches(pos, astRoot)) {
            return this.getJavaCandidateCatalogs(filter).iterator();
        }
        return null;
    }

    protected Iterable<String> getJavaCandidateNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateNames(filter));
    }

    protected Iterable<String> getCandidateNames(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateNames(), filter);
    }

    protected Iterable<String> getCandidateNames() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema != null ? dbSchema.getSortedTableIdentifiers() : EmptyIterable.instance();
    }

    protected Iterable<String> getJavaCandidateSchemata(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateSchemata(filter));
    }

    protected Iterable<String> getCandidateSchemata(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateSchemata(), filter);
    }

    protected Iterable<String> getCandidateSchemata() {
        return this.getDbSchemaContainer().getSortedSchemaIdentifiers();
    }

    protected Iterable<String> getJavaCandidateCatalogs(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateCatalogs(filter));
    }

    protected Iterable<String> getCandidateCatalogs(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateCatalogs(), filter);
    }

    protected Iterable<String> getCandidateCatalogs() {
        Database db = this.getDatabase();
        return db != null ? db.getSortedCatalogIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public JavaJpaContextNode getParent() {
        return (JavaJpaContextNode)super.getParent();
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.getQualifiedName());
    }

    protected String getQualifiedName() {
        return NameTools.buildQualifiedDatabaseObjectName((String)this.getCatalog(), (String)this.getSchema(), (String)this.getName());
    }
}

