/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.persistence;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.java.JarFile;
import org.eclipse.jpt.core.context.persistence.JarFileRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.context.persistence.AbstractPersistenceXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePackageFragmentRoot;
import org.eclipse.jpt.core.resource.persistence.XmlJarFileRef;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.EmptyIterable;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJarFileRef
extends AbstractPersistenceXmlContextNode
implements JarFileRef {
    protected XmlJarFileRef xmlJarFileRef;
    protected String fileName;
    protected JarFile jarFile;

    public AbstractJarFileRef(PersistenceUnit parent, XmlJarFileRef xmlJarFileRef) {
        super(parent);
        this.xmlJarFileRef = xmlJarFileRef;
        this.fileName = xmlJarFileRef.getFileName();
        this.jarFile = this.buildJarFile();
    }

    protected JarFile buildJarFile() {
        if (StringTools.stringIsEmpty((String)this.fileName)) {
            return null;
        }
        JavaResourcePackageFragmentRoot jrpfr = this.getJpaProject().getJavaResourcePackageFragmentRoot(this.getFileName());
        return jrpfr == null ? null : this.buildJarFile(jrpfr);
    }

    @Override
    public PersistenceUnit getParent() {
        return (PersistenceUnit)super.getParent();
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String newFileName) {
        String old = this.fileName;
        this.fileName = newFileName;
        this.xmlJarFileRef.setFileName(newFileName);
        this.firePropertyChanged("fileName", old, newFileName);
    }

    protected void setFileName_(String newFileName) {
        String old = this.fileName;
        this.fileName = newFileName;
        this.firePropertyChanged("fileName", old, newFileName);
    }

    @Override
    public JarFile getJarFile() {
        return this.jarFile;
    }

    protected void setJarFile(JarFile jarFile) {
        JarFile old = this.jarFile;
        this.jarFile = jarFile;
        this.firePropertyChanged("jarFile", old, jarFile);
    }

    @Override
    public PersistentType getPersistentType(String typeName) {
        return this.jarFile == null ? null : this.jarFile.getPersistentType(typeName);
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.xmlJarFileRef != null && this.xmlJarFileRef.containsOffset(textOffset);
    }

    @Override
    public Iterable<? extends PersistentType> getPersistentTypes() {
        return this.jarFile != null ? this.jarFile.getPersistentTypes() : EmptyIterable.instance();
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.persistence.jarFileRef";
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlJarFileRef == null ? null : this.xmlJarFileRef.getSelectionTextRange();
    }

    @Override
    public void dispose() {
        if (this.jarFile != null) {
            this.jarFile.dispose();
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.xmlJarFileRef == null ? null : this.xmlJarFileRef.getValidationTextRange();
    }

    @Override
    public void update(XmlJarFileRef xjfr) {
        this.xmlJarFileRef = xjfr;
        this.setFileName_(xjfr.getFileName());
        this.updateJarFile();
    }

    protected void updateJarFile() {
        JavaResourcePackageFragmentRoot jrpfr = null;
        if (!StringTools.stringIsEmpty((String)this.fileName) && (jrpfr = this.javaPackageRoot_specifically()) == null) {
            jrpfr = this.javaPackageRoot_guess();
        }
        if (jrpfr == null) {
            if (this.jarFile != null) {
                this.jarFile.dispose();
                this.setJarFile(null);
            }
        } else if (this.jarFile == null) {
            this.setJarFile(this.buildJarFile(jrpfr));
        } else {
            this.jarFile.update(jrpfr);
        }
    }

    private JavaResourcePackageFragmentRoot javaPackageRoot_specifically() {
        IPath[] iPathArray = this.resolveDeploymentJarFilePath((IPath)new Path(this.fileName));
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath deploymentPath = iPathArray[n2];
            IVirtualFile virtualJar = ComponentCore.createFile((IProject)this.getProject(), (IPath)deploymentPath);
            IFile realJar = virtualJar.getUnderlyingFile();
            if (realJar.exists() && realJar.getProject().equals((Object)this.getProject())) {
                return this.getJpaProject().getJavaResourcePackageFragmentRoot(realJar.getProjectRelativePath().toString());
            }
            ++n2;
        }
        return null;
    }

    private JavaResourcePackageFragmentRoot javaPackageRoot_guess() {
        String jarFileName = new Path(this.fileName).lastSegment();
        for (JpaFile jpaFile : CollectionTools.iterable(this.getJpaProject().jpaFiles())) {
            if (!jpaFile.getFile().getName().equals(jarFileName) || !JptCorePlugin.JAR_CONTENT_TYPE.equals(jpaFile.getContentType())) continue;
            return (JavaResourcePackageFragmentRoot)jpaFile.getResourceModel();
        }
        return null;
    }

    protected IPath[] resolveDeploymentJarFilePath(IPath jarFilePath) {
        IPath root = this.getJarDeploymentRootPath();
        return this.projectHasWebFacet() ? this.resolveDeploymentJarFilePathWeb(root, jarFilePath) : this.resolveDeploymentJarFilePathNonWeb(root, jarFilePath);
    }

    protected IPath getJarDeploymentRootPath() {
        return JptCorePlugin.getJarDeploymentRootPath(this.getProject());
    }

    protected boolean projectHasWebFacet() {
        return JptCorePlugin.projectHasWebFacet(this.getProject());
    }

    protected IPath[] resolveDeploymentJarFilePathWeb(IPath root, IPath jarFilePath) {
        return new IPath[]{root.append(jarFilePath.removeFirstSegments(1)), root.append(jarFilePath)};
    }

    protected IPath[] resolveDeploymentJarFilePathNonWeb(IPath root, IPath jarFilePath) {
        return new IPath[]{root.append(jarFilePath)};
    }

    protected JarFile buildJarFile(JavaResourcePackageFragmentRoot jrpfr) {
        return this.getContextNodeFactory().buildJarFile(this, jrpfr);
    }

    protected IProject getProject() {
        return this.getJpaProject().getProject();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (StringTools.stringIsEmpty((String)this.xmlJarFileRef.getFileName())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_UNSPECIFIED_JAR_FILE", this, this.getValidationTextRange()));
            return;
        }
        messages.add(DefaultJpaValidationMessages.buildMessage(2, "PERSISTENCE_UNIT_JAR_FILE_DEPLOYMENT_PATH_WARNING", this, this.getValidationTextRange()));
        if (this.jarFile == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_NONEXISTENT_JAR_FILE", new String[]{this.xmlJarFileRef.getFileName()}, this, this.getValidationTextRange()));
            return;
        }
        this.jarFile.validate(messages, reporter);
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.getFileName());
    }
}

